/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelui.trace;

import java.io.IOException;
import java.util.Collection;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelui.trace.TestProjectActionBase;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

public class TestReparseAction
extends TestProjectActionBase {
    private static boolean running = false;

    public String getName() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_TestProjectReparse");
    }

    @Override
    protected void performAction(Collection<CsmProject> csmProjects) {
        if (csmProjects != null && !csmProjects.isEmpty()) {
            this.testReparse(csmProjects);
        }
    }

    private void testReparse(Collection<CsmProject> projects) {
        for (CsmProject p : projects) {
            this.testReparse((ProjectBase)p);
        }
    }

    private void testReparse(ProjectBase project) {
        String task = "Parser Errors " + project.getName();
        ProgressHandle handle = ProgressHandleFactory.createHandle((String)task);
        handle.start();
        handle.switchToDeterminate(project.getAllFiles().size());
        int handled = 0;
        InputOutput io = IOProvider.getDefault().getIO(task, false);
        io.select();
        OutputWriter out = io.getOut();
        for (CsmFile file : project.getSourceFiles()) {
            handle.progress("Parsing " + file.getName(), handled++);
            this.testReparse((FileImpl)file, out);
        }
        for (CsmFile file : project.getHeaderFiles()) {
            handle.progress("Parsing " + file.getName(), handled++);
            this.testReparse((FileImpl)file, out);
        }
        handle.finish();
        out.flush();
        out.close();
    }

    private void testReparse(final FileImpl fileImpl, final OutputWriter out) {
        for (CsmInclude include : fileImpl.getIncludes()) {
            if (include.getIncludeFile() != null) continue;
            int line = include.getStartPosition().getLine();
            int column = include.getStartPosition().getColumn();
            char lBracket = include.isSystem() ? (char)'<' : '\"';
            char rBracket = include.isSystem() ? (char)'>' : '\"';
            this.printError(out, (CsmFile)fileImpl, line, column, "Unresolved include: " + lBracket + include.getIncludeName() + rBracket);
        }
        fileImpl.getErrors(new FileImpl.ErrorListener(){

            public void error(String text, int line, int column) {
                TestReparseAction.this.printError(out, (CsmFile)fileImpl, line, column, text);
            }
        });
    }

    private void printError(OutputWriter out, CsmFile fileImpl, int line, int column, String text) {
        ErrorInfo info = new ErrorInfo(line, column, text);
        text = ((Object)fileImpl.getAbsolutePath()).toString() + ':' + info.line + ':' + info.column + ": " + info.text;
        try {
            out.println(text, (OutputListener)new MyOutputListener(fileImpl, info));
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static class MyOutputListener
    implements OutputListener {
        private CsmFile file;
        private ErrorInfo info;

        public MyOutputListener(CsmFile file, ErrorInfo info) {
            this.file = file;
            this.info = info;
        }

        public void outputLineAction(OutputEvent ev) {
            CsmUtilities.openSource((CsmFile)this.file, (int)this.info.line, (int)this.info.column);
        }

        public void outputLineSelected(OutputEvent ev) {
        }

        public void outputLineCleared(OutputEvent ev) {
        }
    }

    private static class ErrorInfo {
        public final int line;
        public final int column;
        public final String text;

        public ErrorInfo(int line, int column, String text) {
            this.line = line;
            this.column = column;
            this.text = text;
        }
    }
}

