/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.stp;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.profiler.ui.stp.SelectProfilingTask;

public class DefaultSettingsPanel
extends JPanel
implements Scrollable {
    private SettingsChangeListener settingsChangeListener;
    private Vector<ChangeListener> changeListeners;

    public DefaultSettingsPanel() {
        this.setOpaque(true);
        this.setBackground(SelectProfilingTask.BACKGROUND_COLOR);
        this.changeListeners = new Vector();
        this.settingsChangeListener = new SettingsChangeListener();
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return null;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        Container parent = this.getParent();
        if (parent == null || !(parent instanceof JViewport)) {
            return 50;
        }
        return (int)((float)((JViewport)parent).getHeight() * 0.95f);
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        Container parent = this.getParent();
        if (parent == null || !(parent instanceof JViewport)) {
            return false;
        }
        return this.getPreferredSize().height < ((JViewport)parent).getHeight();
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 20;
    }

    public void addChangeListener(ChangeListener listener) {
        if (!this.changeListeners.contains(listener)) {
            this.changeListeners.add(listener);
        }
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    SettingsChangeListener getSettingsChangeListener() {
        return this.settingsChangeListener;
    }

    private void fireSettingsChanged() {
        for (ChangeListener listener : this.changeListeners) {
            listener.stateChanged(new ChangeEvent(this));
        }
    }

    private class SettingsChangeListener
    implements ActionListener,
    ChangeListener {
        private SettingsChangeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultSettingsPanel.this.fireSettingsChanged();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            DefaultSettingsPanel.this.fireSettingsChanged();
        }
    }
}

