/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.lib.profiler.client.RuntimeProfilingPoint;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.modules.profiler.ppoints.CodeProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ProfilingPointFactory;
import org.netbeans.modules.profiler.ppoints.Utils;
import org.netbeans.modules.profiler.ppoints.ui.LoadGeneratorCustomizer;
import org.netbeans.modules.profiler.ppoints.ui.ValidityAwarePanel;
import org.netbeans.modules.profiler.spi.LoadGenPlugin;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class LoadGenProfilingPoint
extends CodeProfilingPoint.Paired
implements PropertyChangeListener {
    private static final String ONE_HIT_STRING = NbBundle.getMessage(LoadGenProfilingPoint.class, (String)"LoadGenProfilingPoint_OneHitString");
    private static final String N_HITS_STRING = NbBundle.getMessage(LoadGenProfilingPoint.class, (String)"LoadGenProfilingPoint_NHitsString");
    private static final String NO_RESULTS_STRING = NbBundle.getMessage(LoadGenProfilingPoint.class, (String)"LoadGenProfilingPoint_NoResultsString");
    private static final String ANNOTATION_START_STRING = NbBundle.getMessage(LoadGenProfilingPoint.class, (String)"LoadGenProfilingPoint_AnnotationStartString");
    private static final String ANNOTATION_END_STRING = NbBundle.getMessage(LoadGenProfilingPoint.class, (String)"LoadGenProfilingPoint_AnnotationEndString");
    private static final String REPORT_ACCESS_DESCR = NbBundle.getMessage(LoadGenProfilingPoint.class, (String)"LoadGenProfilingPoint_ReportAccessDescr");
    private static final String NO_HITS_STRING = NbBundle.getMessage(LoadGenProfilingPoint.class, (String)"LoadGenProfilingPoint_NoHitsString");
    private static final String HEADER_TYPE_STRING = NbBundle.getMessage(LoadGenProfilingPoint.class, (String)"LoadGenProfilingPoint_HeaderTypeString");
    private static final String HEADER_ENABLED_STRING = NbBundle.getMessage(LoadGenProfilingPoint.class, (String)"LoadGenProfilingPoint_HeaderEnabledString");
    private static final String HEADER_PROJECT_STRING = NbBundle.getMessage(LoadGenProfilingPoint.class, (String)"LoadGenProfilingPoint_HeaderProjectString");
    private static final String HEADER_LOCATION_STRING = NbBundle.getMessage(LoadGenProfilingPoint.class, (String)"LoadGenProfilingPoint_HeaderLocationString");
    private static final String HEADER_START_LOCATION_STRING = NbBundle.getMessage(LoadGenProfilingPoint.class, (String)"LoadGenProfilingPoint_HeaderStartLocationString");
    private static final String HEADER_END_LOCATION_STRING = NbBundle.getMessage(LoadGenProfilingPoint.class, (String)"LoadGenProfilingPoint_HeaderEndLocationString");
    private static final String HEADER_HITS_STRING = NbBundle.getMessage(LoadGenProfilingPoint.class, (String)"LoadGenProfilingPoint_HeaderHitsString");
    private static final String HIT_SUCCESS_STRING = NbBundle.getMessage(LoadGenProfilingPoint.class, (String)"LoadGenProfilingPoint_HitSuccessString");
    private static final String HIT_FAILED_STRING = NbBundle.getMessage(LoadGenProfilingPoint.class, (String)"LoadGenProfilingPoint_HitFailedString");
    private static final String DATA_STRING = NbBundle.getMessage(LoadGenProfilingPoint.class, (String)"LoadGenProfilingPoint_DataString");
    private static final Logger LOGGER = Logger.getLogger(LoadGenProfilingPoint.class.getName());
    public static final String PROPERTY_SCRIPTNAME = "p_ScriptName";
    private static final String ANNOTATION_ENABLED = "loadgenProfilingPoint";
    private static final String ANNOTATION_DISABLED = "loadgenProfilingPointD";
    private Annotation endAnnotation;
    private Annotation startAnnotation;
    private final List<Result> results = new ArrayList<Result>();
    private final Object resultsSync = new Object();
    private String scriptFileName;
    private WeakReference<Report> reportReference;

    public LoadGenProfilingPoint(String name, CodeProfilingPoint.Location startLocation, CodeProfilingPoint.Location endLocation, Project project, ProfilingPointFactory factory) {
        this(name, startLocation, endLocation, project, factory, false);
    }

    public LoadGenProfilingPoint(String name, CodeProfilingPoint.Location startLocation, CodeProfilingPoint.Location endLocation, Project project, ProfilingPointFactory factory, boolean existing) {
        super(name, startLocation, endLocation, project, factory, existing);
        this.getChangeSupport().addPropertyChangeListener(this);
    }

    @Override
    public void setEnabled(boolean value) {
        LoadGenPlugin lg = (LoadGenPlugin)Lookup.getDefault().lookup(LoadGenPlugin.class);
        if (lg != null) {
            super.setEnabled(value);
        } else {
            LOGGER.warning("Can not enable the Load Generator profiling point. The appropriate modules are not installed.");
        }
    }

    @Override
    public boolean isEnabled() {
        boolean retValue = super.isEnabled();
        if (retValue) {
            LoadGenPlugin lg = (LoadGenPlugin)Lookup.getDefault().lookup(LoadGenPlugin.class);
            retValue &= lg != null;
        }
        return retValue;
    }

    public String getScriptFileName() {
        return this.scriptFileName != null ? this.scriptFileName : "";
    }

    public void setSriptFileName(String fileName) {
        this.scriptFileName = fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasResults() {
        Object object = this.resultsSync;
        synchronized (object) {
            return !this.results.isEmpty();
        }
    }

    @Override
    public void hideResults() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (LoadGenProfilingPoint.this.hasReport()) {
                    LoadGenProfilingPoint.this.getReport().close();
                }
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.hasReport()) {
            if (evt.getPropertyName() == "p_name") {
                this.getReport().refreshProperties();
            }
            this.getReport().refreshData();
        }
    }

    @Override
    public void showResults(URL url) {
        Report topComponent = this.getReport();
        topComponent.open();
        topComponent.requestActive();
    }

    @Override
    protected CodeProfilingPoint.Annotation getEndAnnotation() {
        if (!this.usesEndLocation()) {
            this.endAnnotation = null;
        } else if (this.endAnnotation == null) {
            this.endAnnotation = new Annotation(false);
        }
        return this.endAnnotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String getResultsText() {
        Object object = this.resultsSync;
        synchronized (object) {
            if (this.hasResults()) {
                return this.results.size() == 1 ? MessageFormat.format(ONE_HIT_STRING, Utils.formatProfilingPointTime(this.results.get(this.results.size() - 1).getTimestamp())) : MessageFormat.format(N_HITS_STRING, this.results.size(), Utils.formatProfilingPointTime(this.results.get(this.results.size() - 1).getTimestamp()));
            }
            return NO_RESULTS_STRING;
        }
    }

    @Override
    protected CodeProfilingPoint.Annotation getStartAnnotation() {
        if (this.startAnnotation == null) {
            this.startAnnotation = new Annotation(true);
        }
        return this.startAnnotation;
    }

    @Override
    protected void updateCustomizer(ValidityAwarePanel c) {
        LoadGeneratorCustomizer customizer = (LoadGeneratorCustomizer)c;
        customizer.setPPName(this.getName());
        customizer.setPPStartLocation(this.getStartLocation());
        customizer.setPPEndLocation(this.getEndLocation());
        customizer.setScriptFile(this.getScriptFileName());
        customizer.setProject(this.getProject());
    }

    @Override
    protected boolean usesEndLocation() {
        return this.getEndLocation() != null;
    }

    @Override
    void setValues(ValidityAwarePanel c) {
        LoadGeneratorCustomizer customizer = (LoadGeneratorCustomizer)c;
        this.setName(customizer.getPPName());
        this.setStartLocation(customizer.getPPStartLocation());
        this.setEndLocation(customizer.getPPEndLocation());
        this.setSriptFileName(customizer.getScriptFile());
        Utils.checkLocation(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void hit(final RuntimeProfilingPoint.HitEvent hitEvent, int index) {
        LoadGenPlugin lg = (LoadGenPlugin)Lookup.getDefault().lookup(LoadGenPlugin.class);
        Object object = this.resultsSync;
        synchronized (object) {
            if (this.usesEndLocation() && index == 1) {
                if (lg != null) {
                    lg.stop(this.getScriptFileName());
                    for (Result result : this.results) {
                        if (result.getEndTimestamp() != -1L || result.getThreadID() != hitEvent.getThreadId()) continue;
                        result.setEndTimestamp(hitEvent.getTimestamp());
                        break;
                    }
                }
            } else if (lg != null) {
                lg.start(this.getScriptFileName(), new LoadGenPlugin.Callback(){
                    private long correlationId;
                    {
                        this.correlationId = hitEvent.getTimestamp();
                    }

                    @Override
                    public void afterStart(LoadGenPlugin.Result result) {
                        Result rslt = new Result(hitEvent.getTimestamp(), hitEvent.getThreadId(), result == LoadGenPlugin.Result.SUCCESS);
                        LoadGenProfilingPoint.this.results.add(rslt);
                        this.correlationId = hitEvent.getTimestamp();
                        LoadGenProfilingPoint.this.getChangeSupport().firePropertyChange("p_results", false, true);
                    }

                    @Override
                    public void afterStop(LoadGenPlugin.Result result) {
                        for (Result rslt : LoadGenProfilingPoint.this.results) {
                            if (rslt.getTimestamp() != this.correlationId) continue;
                            rslt.setEndTimestamp(this.correlationId);
                            rslt.setStopTime();
                            break;
                        }
                        LoadGenProfilingPoint.this.getChangeSupport().firePropertyChange("p_results", false, true);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void reset() {
        Object object = this.resultsSync;
        synchronized (object) {
            boolean change = this.results.size() > 0;
            this.results.clear();
            if (change) {
                this.getChangeSupport().firePropertyChange("p_results", false, true);
            }
        }
    }

    private Report getReport() {
        if (this.hasReport()) {
            return (Report)((Object)this.reportReference.get());
        }
        Report report = new Report();
        this.reportReference = new WeakReference<Report>(report);
        return report;
    }

    private boolean hasReport() {
        return this.reportReference != null && this.reportReference.get() != null;
    }

    private class Report
    extends TopComponent {
        private static final String START_LOCATION_URLMASK = "file:/1";
        private static final String END_LOCATION_URLMASK = "file:/2";
        private HTMLTextArea dataArea;
        private HTMLTextArea headerArea;

        public Report() {
            this.initDefaults();
            this.initComponents();
            this.refreshData();
        }

        public int getPersistenceType() {
            return 2;
        }

        protected String preferredID() {
            return ((Object)((Object)this)).getClass().getName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void refreshData() {
            StringBuilder headerAreaTextBuilder = new StringBuilder();
            headerAreaTextBuilder.append(this.getHeaderName());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderType());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderEnabled());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderProject());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderStartLocation());
            headerAreaTextBuilder.append("<br>");
            if (LoadGenProfilingPoint.this.usesEndLocation()) {
                headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
                headerAreaTextBuilder.append(this.getHeaderEndLocation());
                headerAreaTextBuilder.append("<br>");
            }
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderHitsCount());
            this.headerArea.setText(headerAreaTextBuilder.toString());
            StringBuilder dataAreaTextBuilder = new StringBuilder();
            Object object = LoadGenProfilingPoint.this.resultsSync;
            synchronized (object) {
                if (LoadGenProfilingPoint.this.results.size() == 0) {
                    dataAreaTextBuilder.append("&nbsp;&nbsp;&lt;" + NO_HITS_STRING + "&gt;");
                } else {
                    if (LoadGenProfilingPoint.this.results.size() > 1) {
                        Collections.sort(LoadGenProfilingPoint.this.results, new Comparator<Result>(){

                            @Override
                            public int compare(Result o1, Result o2) {
                                return Long.valueOf(o1.getTimestamp()).compareTo(o2.getTimestamp());
                            }
                        });
                    }
                    for (int i = 0; i < LoadGenProfilingPoint.this.results.size(); ++i) {
                        dataAreaTextBuilder.append("&nbsp;&nbsp;");
                        dataAreaTextBuilder.append(this.getDataResultItem(i));
                        dataAreaTextBuilder.append("<br>");
                    }
                }
            }
            this.dataArea.setText(dataAreaTextBuilder.toString());
        }

        void refreshProperties() {
            this.setName(LoadGenProfilingPoint.this.getName());
            this.setIcon(((ImageIcon)LoadGenProfilingPoint.this.getFactory().getIcon()).getImage());
            this.getAccessibleContext().setAccessibleDescription(MessageFormat.format(REPORT_ACCESS_DESCR, this.getName()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getDataResultItem(int index) {
            Object object = LoadGenProfilingPoint.this.resultsSync;
            synchronized (object) {
                Result result = (Result)LoadGenProfilingPoint.this.results.get(index);
                String hitTime = Utils.formatProfilingPointTimeHiRes(result.getTimestamp());
                if (result.isSuccess()) {
                    return MessageFormat.format(HIT_SUCCESS_STRING, index + 1, hitTime);
                }
                return MessageFormat.format(HIT_FAILED_STRING, index + 1, hitTime);
            }
        }

        private String getHeaderEnabled() {
            return MessageFormat.format(HEADER_ENABLED_STRING, LoadGenProfilingPoint.this.isEnabled());
        }

        private String getHeaderEndLocation() {
            CodeProfilingPoint.Location location = LoadGenProfilingPoint.this.getEndLocation();
            File file = new File(location.getFile());
            String shortFileName = file.getName();
            int lineNumber = location.getLine();
            String locationUrl = "<a href='file:/2'>";
            return MessageFormat.format(HEADER_END_LOCATION_STRING, locationUrl + shortFileName, lineNumber) + "</a>";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getHeaderHitsCount() {
            Object object = LoadGenProfilingPoint.this.resultsSync;
            synchronized (object) {
                return MessageFormat.format(HEADER_HITS_STRING, LoadGenProfilingPoint.this.results.size());
            }
        }

        private String getHeaderName() {
            return "<h2><b>" + LoadGenProfilingPoint.this.getName() + "</b></h2>";
        }

        private String getHeaderProject() {
            return MessageFormat.format(HEADER_PROJECT_STRING, ProjectUtils.getInformation((Project)LoadGenProfilingPoint.this.getProject()).getDisplayName());
        }

        private String getHeaderStartLocation() {
            CodeProfilingPoint.Location location = LoadGenProfilingPoint.this.getStartLocation();
            File file = new File(location.getFile());
            String shortFileName = file.getName();
            int lineNumber = location.getLine();
            String locationUrl = "<a href='file:/1'>";
            return LoadGenProfilingPoint.this.usesEndLocation() ? MessageFormat.format(HEADER_START_LOCATION_STRING, locationUrl + shortFileName, lineNumber) + "</a>" : MessageFormat.format(HEADER_LOCATION_STRING, locationUrl + shortFileName, lineNumber) + "</a>";
        }

        private String getHeaderType() {
            return MessageFormat.format(HEADER_TYPE_STRING, LoadGenProfilingPoint.this.getFactory().getType());
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            JPanel contentsPanel = new JPanel(new BorderLayout());
            contentsPanel.setBackground(UIUtils.getProfilerResultsBackground());
            contentsPanel.setOpaque(true);
            contentsPanel.setBorder(BorderFactory.createMatteBorder(0, 15, 15, 15, UIUtils.getProfilerResultsBackground()));
            this.headerArea = new HTMLTextArea(){

                protected void showURL(URL url) {
                    String urlString = url.toString();
                    if (Report.START_LOCATION_URLMASK.equals(urlString)) {
                        Utils.openLocation(LoadGenProfilingPoint.this.getStartLocation());
                    } else if (LoadGenProfilingPoint.this.usesEndLocation()) {
                        Utils.openLocation(LoadGenProfilingPoint.this.getEndLocation());
                    }
                }
            };
            JScrollPane headerAreaScrollPane = new JScrollPane((Component)this.headerArea, 20, 30);
            headerAreaScrollPane.setBorder(BorderFactory.createMatteBorder(0, 0, 15, 0, UIUtils.getProfilerResultsBackground()));
            headerAreaScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
            contentsPanel.add((Component)headerAreaScrollPane, "North");
            this.dataArea = new HTMLTextArea();
            JScrollPane dataAreaScrollPane = new JScrollPane((Component)this.dataArea, 20, 30);
            TitledBorder tb = new TitledBorder(DATA_STRING);
            tb.setTitleFont(tb.getTitleFont().deriveFont(1));
            tb.setTitleColor(UIManager.getColor("Label.foreground"));
            dataAreaScrollPane.setBorder(tb);
            dataAreaScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
            dataAreaScrollPane.setBackground(UIUtils.getProfilerResultsBackground());
            contentsPanel.add((Component)dataAreaScrollPane, "Center");
            this.add(contentsPanel, "Center");
        }

        private void initDefaults() {
            this.refreshProperties();
            this.setFocusable(true);
        }
    }

    private static class Result {
        private final int threadId;
        private final long timestamp;
        private boolean success = false;
        private long endTimestamp = -1L;
        private long startTime;
        private long stopTime;

        public Result(long timestamp, int threadId, boolean success) {
            this.timestamp = timestamp;
            this.threadId = threadId;
            this.success = success;
            this.startTime = System.currentTimeMillis();
            this.stopTime = 0L;
        }

        public long getDuration() {
            return this.stopTime > this.startTime ? this.stopTime - this.startTime : -1L;
        }

        public void setEndTimestamp(long endTimestamp) {
            this.endTimestamp = endTimestamp;
        }

        public long getEndTimestamp() {
            return this.endTimestamp;
        }

        public void setStopTime() {
            this.stopTime = System.currentTimeMillis();
        }

        public boolean isSuccess() {
            return this.success;
        }

        public int getThreadID() {
            return this.threadId;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }

    private class Annotation
    extends CodeProfilingPoint.Annotation {
        private boolean isStartAnnotation;

        public Annotation(boolean isStartAnnotation) {
            this.isStartAnnotation = isStartAnnotation;
        }

        public String getAnnotationType() {
            return LoadGenProfilingPoint.this.isEnabled() ? LoadGenProfilingPoint.ANNOTATION_ENABLED : LoadGenProfilingPoint.ANNOTATION_DISABLED;
        }

        public String getShortDescription() {
            if (!LoadGenProfilingPoint.this.usesEndLocation()) {
                return LoadGenProfilingPoint.this.getName();
            }
            return this.isStartAnnotation ? MessageFormat.format(ANNOTATION_START_STRING, LoadGenProfilingPoint.this.getName()) : MessageFormat.format(ANNOTATION_END_STRING, LoadGenProfilingPoint.this.getName());
        }

        @Override
        public CodeProfilingPoint profilingPoint() {
            return LoadGenProfilingPoint.this;
        }
    }
}

