/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.actions;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Properties;
import javax.swing.Action;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.SessionSettings;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.lib.profiler.utils.MiscUtils;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ProfilerIDESettings;
import org.netbeans.modules.profiler.actions.FileSensitiveAction;
import org.netbeans.modules.profiler.actions.JavaPlatformSelector;
import org.netbeans.modules.profiler.actions.ProfilingSupport;
import org.netbeans.modules.profiler.actions.ProjectSensitiveAction;
import org.netbeans.modules.profiler.projectsupport.utilities.SourceUtils;
import org.netbeans.modules.profiler.spi.ProjectTypeProfiler;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.netbeans.modules.profiler.utils.ProjectUtilities;
import org.netbeans.spi.project.ui.support.MainProjectSensitiveActions;
import org.netbeans.spi.project.ui.support.ProjectActionPerformer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class AntActions {
    private static final String FILE_TEST_NOT_FOUND_MSG = NbBundle.getMessage(AntActions.class, (String)"AntActions_FileTestNotFoundMsg");
    private static final String FAILED_DETERMINE_JAVA_PLATFORM_MSG = NbBundle.getMessage(AntActions.class, (String)"AntActions_FailedDetermineJavaPlatformMsg");
    private static final String FAILED_DETERMINE_PROJECT_BUILDSCRIPT_MSG = NbBundle.getMessage(AntActions.class, (String)"AntActions_FailedDetermineProjectBuildScriptMsg");
    private static final String INCORRECT_JAVA_SPECVERSION_DIALOG_CAPTION = NbBundle.getMessage(AntActions.class, (String)"AntActions_IncorrectJavaSpecVersionDialogCaption");
    private static final String INCORRECT_JAVA_SPECVERSION_DIALOG_MSG = NbBundle.getMessage(AntActions.class, (String)"AntActions_IncorrectJavaSpecVersionDialogMsg");
    private static final String LINUX_THREAD_TIMER_KEY = "-XX:+UseLinuxPosixThreadCPUClocks";
    private static final String UNSUPPORTED_PROJECT_TYPE_MSG = NbBundle.getMessage(AntActions.class, (String)"AntActions_UnsupportedProjectTypeMsg");
    private static final String INVALID_JAVAPLATFORM_MSG = NbBundle.getMessage(AntActions.class, (String)"AntActions_InvalidJavaplatformMsg");

    private AntActions() {
    }

    public static Action profileMainProject() {
        Action a = MainProjectSensitiveActions.mainProjectSensitiveAction((ProjectActionPerformer)new ProjectActionPerformer(){

            public boolean enable(Project project) {
                if (!NetBeansProfiler.isInitialized()) {
                    return false;
                }
                if (OpenProjects.getDefault().getOpenProjects().length == 0) {
                    return false;
                }
                if (project == null) {
                    return true;
                }
                return AntActions.isProjectTypeSupported(project);
            }

            public void perform(Project project) {
                if (AntActions.isProjectTypeSupported(project)) {
                    AntActions.doProfileProject(project, null, false);
                } else {
                    NetBeansProfiler.getDefaultNB().displayError(UNSUPPORTED_PROJECT_TYPE_MSG);
                }
            }
        }, (String)NbBundle.getMessage(AntActions.class, (String)"LBL_ProfileMainProjectAction"), null);
        a.putValue("ShortDescription", NbBundle.getMessage(AntActions.class, (String)"HINT_ProfileMainProjectAction"));
        a.putValue("iconBase", "org/netbeans/modules/profiler/actions/resources/profile.png");
        a.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/actions/resources/profile.png", (boolean)false));
        return a;
    }

    public static Action profileProject() {
        ProjectSensitiveAction a = ProjectSensitiveAction.projectSensitiveAction(new ProjectSensitiveAction.ProfilerProjectActionPerformer(){

            @Override
            public boolean enable(Project project, Lookup context, boolean lightweightOnly) {
                if (!NetBeansProfiler.isInitialized()) {
                    return false;
                }
                if (project == null) {
                    return false;
                }
                return AntActions.isProjectTypeSupported(project);
            }

            @Override
            public void perform(Project project, Lookup context) {
                AntActions.doProfileProject(project, null, false);
            }
        }, NbBundle.getMessage(AntActions.class, (String)"LBL_ProfileProjectAction40_General"), NbBundle.getMessage(AntActions.class, (String)"LBL_ProfileProjectAction40"), null);
        a.putValue("noIconInMenu", Boolean.TRUE);
        return a;
    }

    public static Action profileProjectPopup() {
        ProjectSensitiveAction a = ProjectSensitiveAction.projectSensitiveAction(new ProjectSensitiveAction.ProfilerProjectActionPerformer(){

            @Override
            public boolean enable(Project project, Lookup context, boolean lightweightOnly) {
                if (!NetBeansProfiler.isInitialized()) {
                    return false;
                }
                if (project == null) {
                    return false;
                }
                return AntActions.isProjectTypeSupported(project);
            }

            @Override
            public void perform(Project project, Lookup context) {
                AntActions.doProfileProject(project, null, false);
            }
        }, NbBundle.getMessage(AntActions.class, (String)"LBL_ProfileProjectActionPopup"), NbBundle.getMessage(AntActions.class, (String)"LBL_ProfileProjectActionPopup"), null);
        a.putValue("noIconInMenu", Boolean.TRUE);
        return a;
    }

    public static Action profileSingle() {
        FileSensitiveAction a = FileSensitiveAction.fileSensitiveAction(new ProjectSensitiveAction.ProfilerProjectActionPerformer(){

            @Override
            public boolean enable(Project project, Lookup context, boolean lightweightOnly) {
                if (!NetBeansProfiler.isInitialized()) {
                    return false;
                }
                if (project == null) {
                    return false;
                }
                FileObject[] fos = ProjectSensitiveAction.ActionsUtil.getFilesFromLookup(context, project);
                if (fos.length != 1) {
                    return false;
                }
                ProjectTypeProfiler ptp = ProjectUtilities.getProjectTypeProfiler(project);
                if (!lightweightOnly) {
                    if (!ptp.isFileObjectSupported(project, fos[0])) {
                        return org.netbeans.modules.profiler.projectsupport.utilities.ProjectUtilities.hasAction((Project)project, (String)"profile-single");
                    }
                } else {
                    return ptp.isProfilingSupported(project) || org.netbeans.modules.profiler.projectsupport.utilities.ProjectUtilities.hasAction((Project)project, (String)"profile-single");
                }
                return true;
            }

            @Override
            public void perform(Project project, Lookup context) {
                FileObject[] fos = ProjectSensitiveAction.ActionsUtil.getFilesFromLookup(context, project);
                if (fos.length != 1) {
                    throw new IllegalStateException();
                }
                AntActions.doProfileProject(project, fos[0], SourceUtils.isTest((FileObject)fos[0]));
            }
        }, NbBundle.getMessage(AntActions.class, (String)"LBL_ProfileSingleAction40_General"), NbBundle.getMessage(AntActions.class, (String)"LBL_ProfileSingleAction40"), null);
        a.putValue("noIconInMenu", Boolean.TRUE);
        return a;
    }

    public static Action profileSinglePopup() {
        FileSensitiveAction a = FileSensitiveAction.fileSensitiveAction(new ProjectSensitiveAction.ProfilerProjectActionPerformer(){

            @Override
            public boolean enable(Project project, Lookup context, boolean lightweightOnly) {
                if (!NetBeansProfiler.isInitialized()) {
                    return false;
                }
                if (project == null) {
                    return false;
                }
                FileObject[] fos = ProjectSensitiveAction.ActionsUtil.getFilesFromLookup(context, project);
                if (fos.length != 1) {
                    return false;
                }
                ProjectTypeProfiler ptp = ProjectUtilities.getProjectTypeProfiler(project);
                if (!lightweightOnly) {
                    if (!ptp.isFileObjectSupported(project, fos[0])) {
                        return org.netbeans.modules.profiler.projectsupport.utilities.ProjectUtilities.hasAction((Project)project, (String)"profile-single");
                    }
                } else {
                    return ptp.isProfilingSupported(project) || org.netbeans.modules.profiler.projectsupport.utilities.ProjectUtilities.hasAction((Project)project, (String)"profile-single");
                }
                return true;
            }

            @Override
            public void perform(Project project, Lookup context) {
                FileObject[] fos = ProjectSensitiveAction.ActionsUtil.getFilesFromLookup(context, project);
                if (fos.length != 1) {
                    throw new IllegalStateException();
                }
                ProjectTypeProfiler ptp = ProjectUtilities.getProjectTypeProfiler(project);
                if (!ptp.isFileObjectSupported(project, fos[0]) && !org.netbeans.modules.profiler.projectsupport.utilities.ProjectUtilities.hasAction((Project)project, (String)"profile-single")) {
                    throw new IllegalStateException();
                }
                AntActions.doProfileProject(project, fos[0], SourceUtils.isTest((FileObject)fos[0]));
            }
        }, NbBundle.getMessage(AntActions.class, (String)"LBL_ProfileSingleActionPopup"), NbBundle.getMessage(AntActions.class, (String)"LBL_ProfileSingleActionPopup"), null);
        a.putValue("noIconInMenu", Boolean.TRUE);
        return a;
    }

    public static Action profileTest() {
        FileSensitiveAction a = FileSensitiveAction.fileSensitiveAction(new ProjectSensitiveAction.ProfilerProjectActionPerformer(){

            @Override
            public boolean enable(Project project, Lookup context, boolean lightweightOnly) {
                if (!NetBeansProfiler.isInitialized()) {
                    return false;
                }
                if (project == null) {
                    return false;
                }
                FileObject[] fos = ProjectSensitiveAction.ActionsUtil.getFilesFromLookup(context, project);
                if (fos.length != 1) {
                    return false;
                }
                FileObject fo = org.netbeans.modules.profiler.projectsupport.utilities.ProjectUtilities.findTestForFile((FileObject)fos[0]);
                if (fo == null) {
                    return false;
                }
                ProjectTypeProfiler ptp = ProjectUtilities.getProjectTypeProfiler(project);
                if (!lightweightOnly) {
                    return ptp.isFileObjectSupported(project, fo);
                }
                return ptp.isProfilingSupported(project);
            }

            @Override
            public void perform(Project project, Lookup context) {
                FileObject[] fos = ProjectSensitiveAction.ActionsUtil.getFilesFromLookup(context, project);
                if (fos.length != 1) {
                    throw new IllegalStateException();
                }
                FileObject fo = org.netbeans.modules.profiler.projectsupport.utilities.ProjectUtilities.findTestForFile((FileObject)fos[0]);
                if (fo == null) {
                    throw new IllegalStateException(FILE_TEST_NOT_FOUND_MSG);
                }
                if (!ProjectUtilities.getProjectTypeProfiler(project).isFileObjectSupported(project, fo)) {
                    throw new IllegalStateException();
                }
                AntActions.doProfileProject(project, fo, true);
            }
        }, NbBundle.getMessage(AntActions.class, (String)"LBL_ProfileTestAction_General"), NbBundle.getMessage(AntActions.class, (String)"LBL_ProfileTestAction"), null);
        a.putValue("noIconInMenu", Boolean.TRUE);
        return a;
    }

    public static Action unintegrateProfiler() {
        ProjectSensitiveAction a = ProjectSensitiveAction.projectSensitiveAction(new ProjectSensitiveAction.ProfilerProjectActionPerformer(){

            @Override
            public boolean enable(Project project, Lookup context, boolean lightweightOnly) {
                if (!NetBeansProfiler.isInitialized()) {
                    return false;
                }
                if (project == null) {
                    return false;
                }
                ProjectTypeProfiler ptp = ProjectUtilities.getProjectTypeProfiler(project);
                return ptp.supportsUnintegrate(project);
            }

            @Override
            public void perform(Project project, Lookup context) {
                ProjectTypeProfiler ptp = ProjectUtilities.getProjectTypeProfiler(project);
                try {
                    ptp.unintegrateProfiler(project);
                }
                catch (Exception e) {
                    ProfilerLogger.log((Exception)e);
                }
            }
        }, NbBundle.getMessage(AntActions.class, (String)"LBL_UnintegrateProfilerAction"), NbBundle.getMessage(AntActions.class, (String)"LBL_UnintegrateProfilerAction"), null);
        a.putValue("noIconInMenu", Boolean.TRUE);
        return a;
    }

    private static String getHeapDumpPath(ProfilerIDESettings gps, Project project) {
        int oomeDetectionMode = gps.getOOMDetectionMode();
        switch (oomeDetectionMode) {
            case 1: {
                return System.getProperty("java.io.tmpdir");
            }
            case 2: {
                try {
                    return FileUtil.toFile((FileObject)IDEUtils.getProjectSettingsFolder(project, true)).getAbsolutePath();
                }
                catch (IOException e) {
                    ErrorManager.getDefault().annotate((Throwable)e, "Cannot resolve project settings directory:\n" + e.getMessage());
                    ErrorManager.getDefault().notify(65536, (Throwable)e);
                    return null;
                }
            }
            case 3: {
                return gps.getCustomHeapdumpPath();
            }
        }
        return null;
    }

    private static void activateLinuxPosixThreadTime(ProfilingSettings ps, Properties props, Project project) {
        if (ps.getThreadCPUTimerOn()) {
            props.setProperty("profiler.info.jvmargs", "-XX:+UseLinuxPosixThreadCPUClocks " + props.getProperty("profiler.info.jvmargs"));
            ProfilerLogger.log((String)"Profiler.UseLinuxPosixThreadCPUClocks: Enabled");
        }
    }

    private static void activateOOMProtection(ProfilerIDESettings gps, Properties props, Project project) {
        if (gps.isOOMDetectionEnabled()) {
            String oldArgs = props.getProperty("profiler.info.jvmargs");
            oldArgs = oldArgs != null ? oldArgs : "";
            StringBuilder oomArgsBuffer = new StringBuilder(oldArgs);
            String heapDumpPath = AntActions.getHeapDumpPath(gps, project);
            if (heapDumpPath != null && heapDumpPath.length() > 0) {
                props.setProperty("profiler.info.oomeprotection", "yes");
                props.setProperty("profiler.info.oomeprotection.dumppath", heapDumpPath);
                if (heapDumpPath.contains(" ")) {
                    heapDumpPath = "\"" + heapDumpPath + "\"";
                }
                oomArgsBuffer.append(" -XX:+HeapDumpOnOutOfMemoryError");
                oomArgsBuffer.append(" -XX:HeapDumpPath=").append(heapDumpPath).append(" ");
                ProfilerLogger.log((String)"Profiler.OutOfMemoryDetection: Enabled");
            }
            props.setProperty("profiler.info.jvmargs", oomArgsBuffer.toString());
        }
    }

    private static void doProfileProject(final Project project, final FileObject profiledClassFile, final boolean isTest) {
        if (ProfilingSupport.getDefault().isProfilingActionInvoked()) {
            return;
        }
        ProfilingSupport.getDefault().setProfilingActionInvoked(true);
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (ProfilingSupport.checkProfilingInProgress()) {
                        return;
                    }
                    ProjectTypeProfiler ptp = ProjectUtilities.getProjectTypeProfiler(project);
                    if (!ptp.isProfilingSupported(project)) {
                        org.netbeans.modules.profiler.projectsupport.utilities.ProjectUtilities.invokeAction((Project)project, (String)(isTest ? "profile-tests" : "profile"));
                    } else {
                        if (!ptp.checkProjectIsModifiedForProfiler(project)) {
                            return;
                        }
                        JavaPlatform platform = AntActions.initPlatform(project, ptp);
                        if (platform == null) {
                            return;
                        }
                        if (!ptp.checkProjectCanBeProfiled(project, profiledClassFile)) {
                            return;
                        }
                        ProfilerIDESettings gps = ProfilerIDESettings.getInstance();
                        String javaFile = IDEUtils.getPlatformJavaFile(platform);
                        if (javaFile == null) {
                            return;
                        }
                        String javaVersion = IDEUtils.getPlatformJDKVersion(platform);
                        if (javaVersion == null) {
                            Profiler.getDefault().displayError(MessageFormat.format(FAILED_DETERMINE_JAVA_PLATFORM_MSG, platform.getDisplayName()));
                            return;
                        }
                        SessionSettings ss = new SessionSettings();
                        ss.setJavaExecutable(javaFile);
                        ss.setJavaVersionString(javaVersion);
                        ss.setSystemArchitecture(IDEUtils.getPlatformArchitecture(platform));
                        ss.setPortNo(gps.getPortNo());
                        ptp.setupProjectSessionSettings(project, ss);
                        boolean settingsAccepted = false;
                        ProfilingSettings pSettings = null;
                        while (!settingsAccepted) {
                            pSettings = ProfilingSupport.getDefault().selectTaskForProfiling(project, ss, profiledClassFile, ptp.supportsSettingsOverride());
                            if (pSettings == null) {
                                return;
                            }
                            settingsAccepted = true;
                        }
                        ProfilingSettings profilingSettings = pSettings;
                        Properties props = new Properties();
                        profilingSettings.store((Map)props);
                        ss.store((Map)props);
                        String projectDir = FileUtil.toFile((FileObject)project.getProjectDirectory()).getAbsolutePath();
                        props.setProperty("profiler.info.project.dir", projectDir);
                        if (profiledClassFile != null) {
                            String singleFile = FileUtil.toFile((FileObject)profiledClassFile).getAbsolutePath();
                            props.setProperty("profiler.info.single.file", singleFile);
                        }
                        String usedJavaExecutable = ss.getJavaExecutable();
                        String usedJvmArgs = ss.getJVMArgs();
                        if (profilingSettings.getOverrideGlobalSettings()) {
                            JavaPlatform jp;
                            String javaPlatformName = profilingSettings.getJavaPlatformName();
                            if (javaPlatformName != null) {
                                usedJavaExecutable = Profiler.getDefault().getPlatformJavaFile(javaPlatformName);
                                jp = IDEUtils.getJavaPlatformByName(javaPlatformName);
                                if (jp == null) {
                                    String text = MessageFormat.format(INVALID_JAVAPLATFORM_MSG, javaPlatformName);
                                    NetBeansProfiler.getDefaultNB().displayWarningAndWait(text);
                                    jp = platform;
                                }
                            } else {
                                jp = platform;
                            }
                            props.setProperty("profiler.info.javaPlatform", (String)jp.getProperties().get("platform.ant.name"));
                            usedJvmArgs = profilingSettings.getJVMArgs();
                        } else {
                            props.setProperty("profiler.info.javaPlatform", ((String)platform.getProperties().get("platform.ant.name")).toString());
                        }
                        props.setProperty("profiler.info.jvm", usedJavaExecutable);
                        props.setProperty("profiler.info.jvmargs", usedJvmArgs);
                        if (javaVersion.equals("jdk15")) {
                            props.setProperty("profiler.info.jvmargs.agent", IDEUtils.getAntProfilerStartArgument15(ss.getPortNo(), ss.getSystemArchitecture()));
                            if (IDEUtils.getPlatformJDKMinor(platform) >= 7) {
                                AntActions.activateOOMProtection(gps, props, project);
                            } else {
                                ProfilerLogger.log((String)"Profiler.OutOfMemoryDetection: Disabled. Not supported JVM. Use at least 1.4.2_12 or 1.5.0_07");
                            }
                        } else if (javaVersion.equals("jdk16")) {
                            props.setProperty("profiler.info.jvmargs.agent", IDEUtils.getAntProfilerStartArgument16(ss.getPortNo(), ss.getSystemArchitecture()));
                            AntActions.activateOOMProtection(gps, props, project);
                        } else if (javaVersion.equals("jdk17")) {
                            props.setProperty("profiler.info.jvmargs.agent", IDEUtils.getAntProfilerStartArgument17(ss.getPortNo(), ss.getSystemArchitecture()));
                            AntActions.activateOOMProtection(gps, props, project);
                        } else {
                            throw new IllegalArgumentException("Unsupported JDK " + javaVersion);
                        }
                        if (Platform.isLinux() && javaVersion.equals("jdk16")) {
                            AntActions.activateLinuxPosixThreadTime(pSettings, props, project);
                        }
                        if (!ptp.startProfilingSession(project, profiledClassFile, isTest, props)) {
                            FileObject buildScriptFO = ptp.getProjectBuildScript(project);
                            if (buildScriptFO == null) {
                                Profiler.getDefault().displayError(MessageFormat.format(FAILED_DETERMINE_PROJECT_BUILDSCRIPT_MSG, ProjectUtils.getInformation((Project)project).getName()));
                                return;
                            }
                            int type = isTest ? (profiledClassFile == null ? 3 : 4) : (profiledClassFile == null ? 1 : 2);
                            String profileTarget = ptp.getProfilerTargetName(project, buildScriptFO, type, profiledClassFile);
                            if (profileTarget == null) {
                                return;
                            }
                            ptp.configurePropertiesForProfiling(props, project, profiledClassFile);
                            NetBeansProfiler.getDefaultNB().runTarget(buildScriptFO, profileTarget, props);
                        }
                    }
                }
                finally {
                    ProfilingSupport.getDefault().setProfilingActionInvoked(false);
                }
            }
        });
    }

    private static JavaPlatform initPlatform(Project project, ProjectTypeProfiler ptp) {
        ProfilerIDESettings gps = ProfilerIDESettings.getInstance();
        JavaPlatform platform = IDEUtils.getJavaPlatformByName(gps.getJavaPlatformForProfiling());
        JavaPlatform projectPlatform = ptp.getProjectJavaPlatform(project);
        if (!(platform != null || (platform = projectPlatform) != null && MiscUtils.isSupportedJVM((Map)platform.getSystemProperties()) || (platform = JavaPlatformSelector.getDefault().selectPlatformToUse()) != null)) {
            return null;
        }
        if (projectPlatform != null) {
            Object res;
            while (projectPlatform.getSpecification().getVersion().compareTo((Object)platform.getSpecification().getVersion()) > 0 && (res = ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)INCORRECT_JAVA_SPECVERSION_DIALOG_MSG, INCORRECT_JAVA_SPECVERSION_DIALOG_CAPTION, 1))) != NotifyDescriptor.YES_OPTION) {
                if (res == NotifyDescriptor.NO_OPTION) {
                    platform = JavaPlatformSelector.getDefault().selectPlatformToUse();
                    if (platform != null) continue;
                    return null;
                }
                return null;
            }
        }
        return platform;
    }

    private static boolean isProjectTypeSupported(Project project) {
        ProjectTypeProfiler ptp = ProjectUtilities.getProjectTypeProfiler(project);
        if (ptp.isProfilingSupported(project)) {
            return true;
        }
        return org.netbeans.modules.profiler.projectsupport.utilities.ProjectUtilities.hasAction((Project)project, (String)"profile");
    }
}

