/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.osgi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.jdom.Element;
import org.netbeans.modules.maven.grammar.AbstractSchemaBasedGrammar;
import org.netbeans.modules.maven.grammar.spi.GrammarExtensionProvider;
import org.netbeans.modules.xml.api.model.GrammarResult;
import org.netbeans.modules.xml.api.model.HintContext;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FelixPluginGrammarExtension
implements GrammarExtensionProvider {
    private static final String[] txtInstructions = new String[]{"Export-Package", "Private-Package", "Bundle-Activator", "Bundle-SymbolicName", "Import-Package", "Include-Resource", "Embed-Dependency", "Embed-Directory", "Embed-StripGroup", "Embed-StripVersion", "Embed-Transitive"};

    public List<GrammarResult> getDynamicCompletion(String path, HintContext hintCtx, Element parent) {
        if (path.endsWith("plugins/plugin/configuration") && FelixPluginGrammarExtension.isFelixPlugin(hintCtx.getParentNode())) {
            ArrayList<GrammarResult> result = new ArrayList<GrammarResult>();
            result.add((GrammarResult)new AbstractSchemaBasedGrammar.MyTextElement("instructions", hintCtx.getCurrentPrefix()));
            return result;
        }
        if (path.endsWith("plugins/plugin/configuration/instructions") && FelixPluginGrammarExtension.isFelixPlugin(hintCtx.getParentNode().getParentNode())) {
            ArrayList<GrammarResult> result = new ArrayList<GrammarResult>();
            for (String curInst : txtInstructions) {
                result.add((GrammarResult)new AbstractSchemaBasedGrammar.MyTextElement(curInst, hintCtx.getCurrentPrefix()));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public Enumeration<GrammarResult> getDynamicValueCompletion(String path, HintContext virtualTextCtx, Element el) {
        return null;
    }

    private static boolean isFelixPlugin(Node configNode) {
        Node pluginNode = configNode.getParentNode();
        if (pluginNode == null) {
            return false;
        }
        NodeList pluginChildren = pluginNode.getChildNodes();
        boolean felixGroupId = false;
        boolean felixArtifactId = false;
        for (int i = 0; i < pluginChildren.getLength(); ++i) {
            NodeList children;
            Node curNode = pluginChildren.item(i);
            if ("groupId".equals(curNode.getNodeName())) {
                children = curNode.getChildNodes();
                if (children.getLength() > 0 && "org.apache.felix".equals(children.item(0).getNodeValue())) {
                    felixGroupId = true;
                } else {
                    return false;
                }
            }
            if (!"artifactId".equals(curNode.getNodeName())) continue;
            children = curNode.getChildNodes();
            if (children.getLength() > 0 && "maven-bundle-plugin".equals(children.item(0).getNodeValue())) {
                felixArtifactId = true;
                continue;
            }
            return false;
        }
        return felixGroupId && felixArtifactId;
    }
}

