/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.impl.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.impl.ArtifactResolver;
import org.sonatype.aether.impl.DependencyCollector;
import org.sonatype.aether.impl.Deployer;
import org.sonatype.aether.impl.Installer;
import org.sonatype.aether.impl.MetadataResolver;
import org.sonatype.aether.impl.RemoteRepositoryManager;
import org.sonatype.aether.impl.RepositoryEventDispatcher;
import org.sonatype.aether.impl.SyncContextFactory;
import org.sonatype.aether.impl.UpdateCheckManager;
import org.sonatype.aether.impl.internal.DefaultArtifactResolver;
import org.sonatype.aether.impl.internal.DefaultDependencyCollector;
import org.sonatype.aether.impl.internal.DefaultDeployer;
import org.sonatype.aether.impl.internal.DefaultFileProcessor;
import org.sonatype.aether.impl.internal.DefaultInstaller;
import org.sonatype.aether.impl.internal.DefaultMetadataResolver;
import org.sonatype.aether.impl.internal.DefaultRemoteRepositoryManager;
import org.sonatype.aether.impl.internal.DefaultRepositoryEventDispatcher;
import org.sonatype.aether.impl.internal.DefaultRepositorySystem;
import org.sonatype.aether.impl.internal.DefaultSyncContextFactory;
import org.sonatype.aether.impl.internal.DefaultUpdateCheckManager;
import org.sonatype.aether.impl.internal.EnhancedLocalRepositoryManagerFactory;
import org.sonatype.aether.impl.internal.SimpleLocalRepositoryManagerFactory;
import org.sonatype.aether.spi.io.FileProcessor;
import org.sonatype.aether.spi.localrepo.LocalRepositoryManagerFactory;
import org.sonatype.aether.spi.locator.Service;
import org.sonatype.aether.spi.locator.ServiceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultServiceLocator
implements ServiceLocator {
    private Map<Class<?>, Collection<Class<?>>> classes = new HashMap();
    private Map<Class<?>, List<?>> instances = new HashMap();

    public DefaultServiceLocator() {
        this.addService(RepositorySystem.class, DefaultRepositorySystem.class);
        this.addService(ArtifactResolver.class, DefaultArtifactResolver.class);
        this.addService(DependencyCollector.class, DefaultDependencyCollector.class);
        this.addService(Deployer.class, DefaultDeployer.class);
        this.addService(Installer.class, DefaultInstaller.class);
        this.addService(MetadataResolver.class, DefaultMetadataResolver.class);
        this.addService(RemoteRepositoryManager.class, DefaultRemoteRepositoryManager.class);
        this.addService(UpdateCheckManager.class, DefaultUpdateCheckManager.class);
        this.addService(FileProcessor.class, DefaultFileProcessor.class);
        this.addService(SyncContextFactory.class, DefaultSyncContextFactory.class);
        this.addService(RepositoryEventDispatcher.class, DefaultRepositoryEventDispatcher.class);
        this.addService(LocalRepositoryManagerFactory.class, SimpleLocalRepositoryManagerFactory.class);
        this.addService(LocalRepositoryManagerFactory.class, EnhancedLocalRepositoryManagerFactory.class);
    }

    public <T> DefaultServiceLocator setService(Class<T> type, Class<? extends T> impl) {
        this.classes.remove(type);
        return this.addService(type, impl);
    }

    public <T> DefaultServiceLocator addService(Class<T> type, Class<? extends T> impl) {
        if (impl == null) {
            throw new IllegalArgumentException("implementation class must not be null");
        }
        Collection<Class<?>> impls = this.classes.get(type);
        if (impls == null) {
            impls = new LinkedHashSet();
            this.classes.put(type, impls);
        }
        impls.add(impl);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> DefaultServiceLocator setServices(Class<T> type, T ... services) {
        Map<Class<?>, List<?>> map = this.instances;
        synchronized (map) {
            this.instances.put(type, Arrays.asList(services));
        }
        return this;
    }

    public <T> T getService(Class<T> type) {
        List<T> objs = this.getServices(type);
        return objs.isEmpty() ? null : (T)objs.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> getServices(Class<T> type) {
        Map<Class<?>, List<?>> map = this.instances;
        synchronized (map) {
            List<Object> objs = this.instances.get(type);
            if (objs == null) {
                Iterator<Object> it;
                Collection<Class<?>> impls = this.classes.get(type);
                if (impls == null || impls.isEmpty()) {
                    objs = Collections.emptyList();
                    it = objs.iterator();
                } else {
                    objs = new ArrayList(impls.size());
                    for (Class<?> impl : impls) {
                        try {
                            Object obj = impl.newInstance();
                            objs.add(type.cast(obj));
                        }
                        catch (Exception e) {
                            this.serviceCreationFailed(type, impl, e);
                        }
                    }
                    it = objs.iterator();
                    objs = Collections.unmodifiableList(objs);
                }
                this.instances.put(type, objs);
                while (it.hasNext()) {
                    Object obj = it.next();
                    if (!(obj instanceof Service)) continue;
                    try {
                        ((Service)obj).initService((ServiceLocator)this);
                    }
                    catch (Exception e) {
                        it.remove();
                        this.serviceCreationFailed(type, obj.getClass(), e);
                    }
                }
            }
            return objs;
        }
    }

    protected void serviceCreationFailed(Class<?> type, Class<?> impl, Throwable exception) {
        exception.printStackTrace();
    }
}

