/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.project.support.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ant.FileChooser;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.spi.java.project.support.ui.Bundle;
import org.netbeans.spi.java.project.support.ui.MakeSharableWizardPanel1;
import org.netbeans.spi.java.project.support.ui.MakeSharableWizardPanel2;
import org.netbeans.spi.project.libraries.LibraryTypeProvider;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;
import org.openide.util.NbPreferences;

public final class SharableLibrariesUtils {
    static final String PROP_LOCATION = "location";
    static final String PROP_ACTIONS = "actions";
    static final String PROP_HELPER = "helper";
    static final String PROP_REFERENCE_HELPER = "refhelper";
    static final String PROP_LIBRARIES = "libraries";
    static final String PROP_JAR_REFS = "jars";
    public static final String DEFAULT_LIBRARIES_FILENAME = "nblibraries.properties";
    private static String PROP_LAST_SHARABLE = "lastSharable";

    public static boolean isLastProjectSharable() {
        return NbPreferences.forModule(SharableLibrariesUtils.class).getBoolean(PROP_LAST_SHARABLE, NbPreferences.root().node("org.netbeans.modules.java.project.share").getBoolean(PROP_LAST_SHARABLE, false));
    }

    public static void setLastProjectSharable(boolean sharable) {
        NbPreferences.forModule(SharableLibrariesUtils.class).putBoolean(PROP_LAST_SHARABLE, sharable);
    }

    public static String browseForLibraryLocation(String current, Component comp, File projectLocation) {
        File lib = PropertyUtils.resolveFile((File)projectLocation, (String)current);
        if (!lib.exists()) {
            lib = lib.getParentFile();
        }
        lib = FileUtil.normalizeFile((File)lib);
        FileChooser chooser = new FileChooser(projectLocation, null);
        chooser.setCurrentDirectory(lib);
        chooser.setFileSelectionMode(1);
        chooser.setDialogTitle(NbBundle.getMessage(SharableLibrariesUtils.class, (String)"LBL_Browse_Libraries_Title"));
        chooser.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SharableLibrariesUtils.class, (String)"ASCD_Browse_Libraries_Title"));
        if (0 == chooser.showOpenDialog(comp)) {
            String[] files;
            try {
                files = chooser.getSelectedPaths();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
            if (files.length == 1) {
                String currentLibrariesLocation = files[0];
                return currentLibrariesLocation;
            }
        }
        return null;
    }

    public static boolean showMakeSharableWizard(AntProjectHelper helper, ReferenceHelper ref, List<String> libraryNames, List<String> jarReferences) {
        WizardDescriptor wizardDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)new CopyIterator(helper));
        wizardDescriptor.setTitleFormat(new MessageFormat("{0}"));
        wizardDescriptor.setTitle(NbBundle.getMessage(SharableLibrariesUtils.class, (String)"TIT_MakeSharableWizard"));
        wizardDescriptor.putProperty(PROP_HELPER, (Object)helper);
        wizardDescriptor.putProperty(PROP_REFERENCE_HELPER, (Object)ref);
        wizardDescriptor.putProperty(PROP_LIBRARIES, libraryNames);
        wizardDescriptor.putProperty(PROP_JAR_REFS, jarReferences);
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wizardDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SharableLibrariesUtils.class, (String)"ACSD_MakeSharableWizard"));
        dialog.setVisible(true);
        dialog.toFront();
        return wizardDescriptor.getValue() == WizardDescriptor.FINISH_OPTION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void execute(WizardDescriptor wizardDescriptor, final AntProjectHelper helper, final ProgressHandle handle) {
        final String loc = (String)wizardDescriptor.getProperty(PROP_LOCATION);
        final List actions = NbCollections.checkedListByCopy((List)((List)wizardDescriptor.getProperty(PROP_ACTIONS)), Action.class, (boolean)true);
        assert (loc != null);
        handle.start(Math.max(1, actions.size() + 1));
        try {
            File f = new File(loc);
            if (!f.isAbsolute()) {
                f = new File(FileUtil.toFile((FileObject)helper.getProjectDirectory()), loc);
            }
            if (!(f = FileUtil.normalizeFile((File)f)).exists()) {
                FileUtil.createData((File)f);
            }
            try {
                ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                    public Void run() throws IOException {
                        try {
                            helper.getProjectDirectory().getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                                public void run() throws IOException {
                                    helper.setLibrariesLocation(loc);
                                    int count = 1;
                                    for (Action act : actions) {
                                        handle.progress(count);
                                        ++count;
                                        act.actionPerformed(null);
                                    }
                                    ProjectManager.getDefault().saveProject(FileOwnerQuery.getOwner((FileObject)helper.getProjectDirectory()));
                                }
                            });
                        }
                        catch (IllegalArgumentException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        return null;
                    }
                });
            }
            catch (MutexException ex) {
                throw (IOException)ex.getException();
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            handle.finish();
        }
    }

    private static List<WizardDescriptor.Panel<WizardDescriptor>> getPanels() {
        ArrayList<WizardDescriptor.Panel<WizardDescriptor>> panels = new ArrayList<WizardDescriptor.Panel<WizardDescriptor>>();
        panels.add(new MakeSharableWizardPanel1());
        panels.add(new MakeSharableWizardPanel2());
        String[] steps = new String[panels.size()];
        for (int i = 0; i < panels.size(); ++i) {
            Component c = ((WizardDescriptor.Panel)panels.get(i)).getComponent();
            steps[i] = c.getName();
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
            jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
            jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
            jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
        }
        return panels;
    }

    private static String getJarFolder(URI uri) {
        String u = uri.toString();
        int index = u.indexOf("!/");
        if (index != -1 && index + 2 < u.length()) {
            return u.substring(index + 2);
        }
        return null;
    }

    private static URI appendJarFolder(URI u, String jarFolder) {
        try {
            if (u.isAbsolute()) {
                return new URI("jar:" + u.toString() + "!/" + (jarFolder == null ? "" : jarFolder.replace('\\', '/')));
            }
            return new URI(u.toString() + "!/" + (jarFolder == null ? "" : jarFolder.replace('\\', '/')));
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
    }

    static class CopyLibraryJars
    extends AbstractAction {
        private Library library;
        private ReferenceHelper refHelper;

        CopyLibraryJars(ReferenceHelper h, Library l) {
            this.refHelper = h;
            this.library = l;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            assert (this.library.getManager() == LibraryManager.getDefault()) : "Only converting from non-sharable to sharable is supported.";
            try {
                this.refHelper.copyLibrary(this.library);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    static class KeepLibraryAtLocation
    extends AbstractAction {
        private boolean keepRelativeLocations;
        private Library library;
        private AntProjectHelper helper;

        KeepLibraryAtLocation(Library l, boolean relative, AntProjectHelper h) {
            this.library = l;
            this.keepRelativeLocations = relative;
            this.helper = h;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String loc = this.helper.getLibrariesLocation();
            assert (loc != null);
            File mainPropertiesFile = this.helper.resolveFile(loc);
            try {
                LibraryManager man = LibraryManager.forLocation((URL)mainPropertiesFile.toURI().toURL());
                HashMap volumes = new HashMap();
                LibraryTypeProvider provider = LibrariesSupport.getLibraryTypeProvider((String)this.library.getType());
                assert (provider != null);
                for (String volume : provider.getSupportedVolumeTypes()) {
                    List urls = this.library.getContent(volume);
                    ArrayList<URI> newurls = new ArrayList<URI>();
                    for (URL url : urls) {
                        FileObject fo;
                        String jarFolder = null;
                        if ("jar".equals(url.getProtocol())) {
                            jarFolder = SharableLibrariesUtils.getJarFolder(URI.create(url.toExternalForm()));
                            url = FileUtil.getArchiveFile((URL)url);
                        }
                        if ((fo = URLMapper.findFileObject((URL)url)) != null) {
                            URI uri;
                            File path;
                            if (this.keepRelativeLocations) {
                                path = FileUtil.toFile((FileObject)fo);
                                String str = PropertyUtils.relativizeFile((File)mainPropertiesFile.getParentFile(), (File)path);
                                uri = str == null ? path.toURI() : LibrariesSupport.convertFilePathToURI((String)str);
                            } else {
                                path = FileUtil.toFile((FileObject)fo);
                                uri = path.toURI();
                            }
                            if (FileUtil.isArchiveFile((FileObject)fo)) {
                                uri = SharableLibrariesUtils.appendJarFolder(uri, jarFolder);
                            }
                            newurls.add(uri);
                            continue;
                        }
                        try {
                            newurls.add(url.toURI());
                        }
                        catch (URISyntaxException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                    volumes.put(volume, newurls);
                }
                if (man.getLibrary(this.library.getName()) != null) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(SharableLibrariesUtils.class, (String)"ERR_LibraryExists", (Object)this.library.getDisplayName()), 2));
                } else {
                    man.createURILibrary(this.library.getType(), this.library.getName(), volumes);
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    static class KeepJarAtLocation
    extends AbstractAction {
        private ReferenceHelper refhelper;
        private AntProjectHelper ahelper;
        private String reference;
        private boolean relative;

        public KeepJarAtLocation(String ref, boolean b, AntProjectHelper anthelper, ReferenceHelper helper) {
            this.reference = ref;
            this.ahelper = anthelper;
            this.refhelper = helper;
            this.relative = b;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String value = this.ahelper.getStandardPropertyEvaluator().evaluate(this.reference);
            this.updateReference(value, this.reference, true);
            String source = this.reference.replace("${file.reference", "${source.reference");
            value = this.ahelper.getStandardPropertyEvaluator().evaluate(source);
            if (!value.startsWith("${source.")) {
                this.updateReference(value, source.replace("${", "").replace("}", ""), false);
            }
            String javadoc = this.reference.replace("${file.reference", "${javadoc.reference");
            value = this.ahelper.getStandardPropertyEvaluator().evaluate(javadoc);
            if (!value.startsWith("${javadoc.")) {
                this.updateReference(value, javadoc.replace("${", "").replace("}", ""), false);
            }
        }

        private void updateReference(String value, String key, boolean main) {
            String newVal;
            File absFile = this.ahelper.resolveFile(value);
            String string = newVal = this.relative ? PropertyUtils.relativizeFile((File)FileUtil.toFile((FileObject)this.ahelper.getProjectDirectory()), (File)absFile) : absFile.getAbsolutePath();
            if (newVal == null) {
                newVal = absFile.getAbsolutePath();
            }
            if (!newVal.equals(value)) {
                if (main) {
                    this.refhelper.createForeignFileReferenceAsIs(newVal, key);
                } else {
                    this.refhelper.createExtraForeignFileReferenceAsIs(newVal, key);
                }
            }
        }
    }

    static class CopyJars
    extends AbstractAction {
        private ReferenceHelper refhelper;
        private AntProjectHelper ahelper;
        private String reference;

        public CopyJars(ReferenceHelper helper, AntProjectHelper anthelper, String ref) {
            this.reference = ref;
            this.ahelper = anthelper;
            this.refhelper = helper;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                String value = this.ahelper.getStandardPropertyEvaluator().evaluate(this.reference);
                File absFile = this.ahelper.resolveFile(value);
                String location = this.ahelper.getLibrariesLocation();
                File libraryFile = this.ahelper.resolveFile(location);
                File directory = libraryFile.getParentFile();
                FileObject dir = FileUtil.createFolder((File)directory);
                if (!absFile.exists()) {
                    return;
                }
                this.updateReference(absFile, this.reference, true, dir);
                String source = this.reference.replace("${file.reference", "${source.reference");
                value = this.ahelper.getStandardPropertyEvaluator().evaluate(source);
                if (!value.startsWith("${source.")) {
                    absFile = this.ahelper.resolveFile(value);
                    this.updateReference(absFile, source.replace("${", "").replace("}", ""), false, dir);
                }
                String javadoc = this.reference.replace("${file.reference", "${javadoc.reference");
                value = this.ahelper.getStandardPropertyEvaluator().evaluate(javadoc);
                if (!value.startsWith("${javadoc.")) {
                    absFile = this.ahelper.resolveFile(value);
                    this.updateReference(absFile, javadoc.replace("${", "").replace("}", ""), false, dir);
                }
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }

        private void updateReference(File oldFile, String key, boolean main, FileObject dir) {
            FileObject newFile;
            final FileObject src = FileUtil.toFileObject((File)oldFile);
            if (src == null) {
                assert (!oldFile.exists()) : "The file: " + oldFile.getAbsolutePath() + " exists but FileObject cannot be found.";
                return;
            }
            try {
                newFile = dir.getFileObject(src.getNameExt());
                if (newFile != null) {
                    Runnable action = new Runnable(){

                        @Override
                        public void run() {
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.TXT_AlreadyExists(src.getNameExt()), 2));
                        }
                    };
                    if (SwingUtilities.isEventDispatchThread()) {
                        action.run();
                    } else {
                        SwingUtilities.invokeLater(action);
                    }
                } else {
                    newFile = FileUtil.copyFile((FileObject)src, (FileObject)dir, (String)src.getName());
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                newFile = src;
            }
            File absFile = FileUtil.toFile((FileObject)newFile);
            String newVal = PropertyUtils.relativizeFile((File)FileUtil.toFile((FileObject)this.ahelper.getProjectDirectory()), (File)absFile);
            if (newVal == null) {
                newVal = absFile.getAbsolutePath();
            }
            if (main) {
                this.refhelper.destroyReference(key);
                this.refhelper.createForeignFileReferenceAsIs(newVal, key);
            } else {
                this.refhelper.destroyReference(key);
                this.refhelper.createExtraForeignFileReferenceAsIs(newVal, key);
            }
        }
    }

    private static class CopyIterator
    extends WizardDescriptor.ArrayIterator<WizardDescriptor>
    implements WizardDescriptor.ProgressInstantiatingIterator<WizardDescriptor> {
        private AntProjectHelper helper;
        private WizardDescriptor desc;

        private CopyIterator(AntProjectHelper helper) {
            super(SharableLibrariesUtils.getPanels());
            this.helper = helper;
        }

        public Set instantiate(ProgressHandle handle) throws IOException {
            SharableLibrariesUtils.execute(this.desc, this.helper, handle);
            return Collections.EMPTY_SET;
        }

        public Set instantiate() throws IOException {
            throw new UnsupportedOperationException("Not supported");
        }

        public void initialize(WizardDescriptor wizard) {
            this.desc = wizard;
        }

        public void uninitialize(WizardDescriptor wizard) {
            this.desc = wizard;
        }
    }
}

