/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.utils.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.netbeans.modules.cnd.debugger.common2.utils.options.Option;
import org.netbeans.modules.cnd.debugger.common2.utils.options.OptionSet;
import org.netbeans.modules.cnd.debugger.common2.utils.options.OptionUI;
import org.netbeans.modules.cnd.debugger.common2.utils.options.TextFieldOptionUI;

class RadioButtonOptionUI
extends OptionUI
implements ItemListener {
    JRadioButton[] buttons;
    String[] buttonLabels;
    String[] buttonDescrs;
    String[] buttonValues;
    ButtonGroup buttonGroup = new ButtonGroup();
    private TextFieldOptionUI subOptionUI;
    public static int RB_COLUMNS = 12;

    public RadioButtonOptionUI(Option inOption) {
        super(inOption);
    }

    protected JPanel createButtonPanel(int index) {
        this.buttons[index] = new JRadioButton();
        if (index == 0 && this.hasLabel) {
            this.label.setLabelFor(this.buttons[index]);
        }
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.add((Component)this.buttons[index], "West");
        this.buttons[index].setText(this.buttonLabels[index]);
        this.buttons[index].getAccessibleContext().setAccessibleDescription(this.buttonDescrs[index]);
        this.buttonGroup.add(this.buttons[index]);
        this.updateUI();
        return buttonPanel;
    }

    protected int getSelectionIndex() {
        for (int i = 0; i < this.buttons.length; ++i) {
            if (!this.buttons[i].isSelected()) continue;
            return i;
        }
        return -1;
    }

    public void itemStateChanged(ItemEvent ie) {
        String value = null;
        JRadioButton rb = (JRadioButton)ie.getItem();
        for (int i = 0; i < this.buttons.length; ++i) {
            if (this.buttons[i] != rb) continue;
            value = this.buttonValues[i];
        }
        Option subOption = this.optionType.getSubOption(value);
        if (subOption != null) {
            this.subOptionUI.setEnabled(rb.isSelected());
        }
    }

    void bind(OptionSet options) {
        super.bind(options);
        if (this.subOptionUI != null) {
            this.subOptionUI.bind(options);
        }
    }

    public void applyChanges() {
        super.applyChanges();
        if (this.subOptionUI != null) {
            Option VSubOption = this.optionType.getSubOption(this.getValueFromUI());
            if (VSubOption != null) {
                this.subOptionUI.applyChanges();
            } else {
                this.subOptionUI.setValue(null);
                this.subOptionUI.applyChanges();
            }
        }
    }

    public void cancelChanges() {
        Option subOption = this.optionType.getSubOption();
        if (subOption != null) {
            this.subOptionUI.cancelChanges();
        }
        super.cancelChanges();
    }

    protected String getValueFromUI() {
        return this.buttonValues[this.getSelectionIndex()];
    }

    protected void updateUI() {
        if (this.currValue == null) {
            return;
        }
        for (int i = 0; i < this.buttons.length; ++i) {
            if (!this.buttonValues[i].equals(this.currValue)) continue;
            this.buttons[i].setSelected(true);
        }
    }

    public void addTo(JPanel parent) {
        GridBagConstraints gridBagConstraints;
        if (this.hasLabel) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.5;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 12, 5, 12);
            this.label = this.createLabel();
            parent.add((Component)this.label, gridBagConstraints);
        }
        JPanel buttonsPanel = new JPanel(new FlowLayout(0, 2, 2));
        if (this.optionType.verticalLayout()) {
            buttonsPanel.setLayout(new GridLayout(0, 2));
        }
        this.buttonLabels = this.optionType.getValueLabels();
        this.buttonDescrs = this.optionType.getValueDescrs();
        this.buttonValues = this.optionType.getValues();
        this.buttons = new JRadioButton[this.buttonLabels.length];
        Option subOption = null;
        JPanel buttonPanel = null;
        JPanel jp = null;
        for (int i = 0; i < this.buttonLabels.length; ++i) {
            buttonPanel = this.createButtonPanel(i);
            subOption = this.optionType.getSubOption(this.buttonValues[i]);
            if (subOption != null) {
                jp = new JPanel();
                jp.setLayout(new GridBagLayout());
                this.subOptionUI = new TextFieldOptionUI(subOption, 10);
                this.subOptionUI.addTo(jp, 0);
                if (!this.buttons[i].isSelected()) {
                    this.subOptionUI.setEnabled(false);
                }
                this.buttons[i].addItemListener(this);
            }
            buttonsPanel.add(buttonPanel);
        }
        if (jp != null) {
            buttonPanel.add(jp, "East");
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 5, 12);
        parent.add((Component)buttonsPanel, gridBagConstraints);
    }
}

