/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.utils.options;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.MissingResourceException;
import org.netbeans.modules.cnd.debugger.common2.utils.IpeUtils;
import org.netbeans.modules.cnd.debugger.common2.utils.options.Catalog;
import org.netbeans.modules.cnd.debugger.common2.utils.options.CatalogDynamic;
import org.netbeans.modules.cnd.debugger.common2.utils.options.CheckBoxOptionUI;
import org.netbeans.modules.cnd.debugger.common2.utils.options.ComboBoxOptionUI;
import org.netbeans.modules.cnd.debugger.common2.utils.options.DirectoryOptionUI;
import org.netbeans.modules.cnd.debugger.common2.utils.options.OptionLayers;
import org.netbeans.modules.cnd.debugger.common2.utils.options.OptionPropertySupport;
import org.netbeans.modules.cnd.debugger.common2.utils.options.OptionSet;
import org.netbeans.modules.cnd.debugger.common2.utils.options.OptionSetOwner;
import org.netbeans.modules.cnd.debugger.common2.utils.options.OptionUI;
import org.netbeans.modules.cnd.debugger.common2.utils.options.OptionValue;
import org.netbeans.modules.cnd.debugger.common2.utils.options.RadioButtonOptionUI;
import org.netbeans.modules.cnd.debugger.common2.utils.options.TextFieldOptionUI;
import org.netbeans.modules.cnd.debugger.common2.utils.options.Validity;
import org.openide.awt.Actions;
import org.openide.nodes.PropertySupport;

public abstract class Option {
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private String name;
    private String label;
    private char mnemonic;
    private String tooltip;
    private String[] values;
    private String[] valueLabels;
    private String[] valueDescrs;
    private String optionDescr;
    private String defaultValue;
    private boolean clientOption;
    private boolean trim;
    private int type;
    private CatalogDynamic catalog;
    public static final int TEXT_AREA = 1;
    public static final int RADIO_BUTTON = 2;
    public static final int COMBO_BOX = 3;
    public static final int CHECK_BOX = 4;
    public static final int DIRECTORY = 5;
    public static final int FILE = 6;
    private static String yesString = null;
    private static String noString = null;

    protected Option(String name, CatalogDynamic catalog, String[] values, String defaultValue, boolean clientOption, int type, boolean hasTooltip, boolean hasMnemonic) {
        this.name = name;
        this.catalog = catalog;
        this.values = values;
        this.defaultValue = defaultValue;
        this.clientOption = clientOption;
        this.type = type;
        this.label = catalog.get("LABEL_" + name);
        this.tooltip = hasTooltip ? name : null;
        this.mnemonic = hasMnemonic ? catalog.getMnemonic("MNEM_" + name) : (char)'\u0000';
        this.setValueLabels();
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDisplayName() {
        return this.label;
    }

    public char getMnemonic() {
        return this.mnemonic;
    }

    public String getLabelTip() {
        return this.tooltip;
    }

    public String getShortDescription() {
        return this.tooltip;
    }

    public String[] getValues() {
        return this.values;
    }

    public String[] getValueLabels() {
        return this.valueLabels;
    }

    public String[] getValueDescrs() {
        return this.valueDescrs;
    }

    public String getOptionDescription() {
        return this.optionDescr;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isClientOption() {
        return this.clientOption;
    }

    public int getType() {
        return this.type;
    }

    public String getCurrValue(OptionSet optionSet) {
        OptionValue ov = optionSet.byType(this);
        if (ov != null) {
            return ov.get();
        }
        return null;
    }

    protected boolean canWrite(OptionSet optionSet) {
        return true;
    }

    public void setCurrValue(OptionSet optionSet, String v) {
        OptionValue ov = optionSet.byType(this);
        if (ov != null) {
            String oldValue = ov.get();
            ov.set(v);
            this.firePropertyChange(ov, oldValue, v);
        }
    }

    public void setEnabled(OptionLayers optionLayers, boolean enabled) {
        OptionValue ov = optionLayers.byType(this);
        if (ov != null) {
            boolean oldValue = this.isEnabled(ov.owner());
            ov.setEnabled(enabled);
            this.firePropertyChange(ov, oldValue, enabled);
        }
    }

    public boolean isEnabled(OptionSet optionSet) {
        assert (this.isYesNoOption());
        return "on".equals(this.getCurrValue(optionSet));
    }

    public String getValueLabel(String value) {
        if (this.values == null || this.valueLabels == null) {
            return null;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (!value.equals(this.values[i])) continue;
            return this.valueLabels[i];
        }
        return null;
    }

    public String getValue(String valueLabel) {
        if (this.values == null || this.valueLabels == null) {
            return null;
        }
        for (int i = 0; i < this.valueLabels.length; ++i) {
            if (!valueLabel.equals(this.valueLabels[i])) continue;
            return this.values[i];
        }
        return null;
    }

    private void setValueLabels() {
        if (this.type == 1 || this.type == 4 || this.type == 5 || this.type == 6) {
            this.valueLabels = null;
            this.setValueDescrs();
            return;
        }
        if (this.isYesNoOption()) {
            this.valueLabels = this.values[0].equals("on") ? new String[]{yesString, noString} : new String[]{noString, yesString};
            this.setValueDescrs();
            return;
        }
        this.valueLabels = new String[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            if (Option.isNumber(this.values[i])) {
                this.valueLabels[i] = this.values[i];
                continue;
            }
            try {
                this.valueLabels[i] = this.catalog.get("VALUE_" + this.name + "_" + this.values[i]);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.setValueDescrs();
    }

    private static boolean isNumber(String text) {
        try {
            Integer.parseInt(text);
        }
        catch (NumberFormatException x) {
            return false;
        }
        return true;
    }

    private void setValueDescrs() {
        if (this.type == 2) {
            this.valueDescrs = new String[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                if (Option.isNumber(this.values[i])) {
                    this.valueDescrs[i] = this.values[i];
                    continue;
                }
                try {
                    this.valueDescrs[i] = this.catalog.get("ACSD_" + this.name + "_" + this.values[i]);
                    continue;
                }
                catch (MissingResourceException ex) {
                    String pattern = this.catalog.get("ACSD_option_pattern");
                    String labTxt = Actions.cutAmpersand((String)this.label);
                    if (labTxt.endsWith(":")) {
                        labTxt = labTxt.substring(0, labTxt.length() - 1);
                    }
                    String valTxt = Actions.cutAmpersand((String)this.valueLabels[i]);
                    this.valueDescrs[i] = Catalog.format(pattern, labTxt, valTxt);
                }
            }
        } else {
            try {
                this.optionDescr = this.catalog.get("ACSD_" + this.name);
            }
            catch (MissingResourceException ex) {
                String labTxt = Actions.cutAmpersand((String)this.label);
                if (labTxt.endsWith(":")) {
                    labTxt = labTxt.substring(0, labTxt.length() - 1);
                }
                this.optionDescr = labTxt;
            }
        }
    }

    public boolean isYesNoOption() {
        if (this.type == 4) {
            return true;
        }
        return !(this.type != 2 || this.values.length != 2 || !this.values[0].equals("on") && !this.values[0].equals("off") || !this.values[1].equals("on") && !this.values[1].equals("off"));
    }

    public boolean equals(Option option) {
        return option.getName().equals(this.name);
    }

    public abstract Option getSubOption(String var1);

    public abstract boolean verticalLayout();

    public abstract boolean overrideHasLabel();

    public abstract Option getSubOption();

    public abstract boolean isSubOption();

    public abstract boolean persist(OptionValue var1);

    public abstract Validity getValidity(String var1);

    public abstract boolean isTrim();

    public OptionUI createUI() {
        OptionUI panel = null;
        switch (this.getType()) {
            case 5: 
            case 6: {
                panel = new DirectoryOptionUI(this);
                break;
            }
            case 1: {
                panel = new TextFieldOptionUI(this);
                break;
            }
            case 2: {
                panel = new RadioButtonOptionUI(this);
                break;
            }
            case 3: {
                panel = new ComboBoxOptionUI(this);
                break;
            }
            case 4: {
                panel = new CheckBoxOptionUI(this);
                break;
            }
        }
        return panel;
    }

    public PropertySupport createNodeProp(OptionSetOwner optionSetOwner) {
        return new OptionPropertySupport(optionSetOwner, this, null);
    }

    public PropertySupport createBasedNodeProp(OptionSetOwner optionSetOwner, String base) {
        return new OptionPropertySupport(optionSetOwner, this, base);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public boolean caused(PropertyChangeEvent e) {
        return IpeUtils.sameString(e.getPropertyName(), this.name);
    }

    private void firePropertyChange(OptionValue ov, String oldValue, String newValue) {
        PropertyChangeEvent e = new PropertyChangeEvent(ov.owner(), this.name, oldValue, newValue);
        this.pcs.firePropertyChange(e);
    }

    private void firePropertyChange(OptionValue ov, boolean oldValue, boolean newValue) {
        PropertyChangeEvent e = new PropertyChangeEvent(ov.owner(), this.name, oldValue, newValue);
        this.pcs.firePropertyChange(e);
    }

    static {
        try {
            yesString = Catalog.get("VALUE_on");
            noString = Catalog.get("VALUE_off");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

