/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.remote;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Platform
extends Enum<Platform> {
    public static final /* enum */ Platform Linux_x86 = new Platform("intel-Linux", "amd64-Linux", true, false);
    public static final /* enum */ Platform Solaris_x86 = new Platform("intel-S2", "amd64-S2", false, true);
    public static final /* enum */ Platform Solaris_Sparc = new Platform("sparc-S2", "sparcv9-S2", false, true);
    public static final /* enum */ Platform MacOSX_x86 = new Platform("intel-MacOSX", "", false, false);
    public static final /* enum */ Platform Windows_x86 = new Platform("intel-Windows", "", false, false);
    public static final /* enum */ Platform Unknown = new Platform("", "", false, false);
    private String variant;
    private String variant64;
    private boolean isLinux;
    private boolean isSolaris;
    private static final /* synthetic */ Platform[] $VALUES;

    public static Platform[] values() {
        return (Platform[])$VALUES.clone();
    }

    public static Platform valueOf(String name) {
        return Enum.valueOf(Platform.class, name);
    }

    private Platform(String variant, String variant64, boolean isLinux, boolean isSolaris) {
        this.variant = variant;
        this.variant64 = variant64;
        this.isLinux = isLinux;
        this.isSolaris = isSolaris;
    }

    public static Platform byName(String name) {
        if (name == null) {
            return Unknown;
        }
        try {
            return Platform.valueOf(Platform.class, name);
        }
        catch (IllegalArgumentException x) {
            return Unknown;
        }
    }

    public static Platform local() {
        String os_name = System.getProperty("os.name", "");
        String os_arch = System.getProperty("os.arch", "");
        String platform_arch = "";
        if (os_arch.equals("sparc")) {
            platform_arch = "Sparc";
        } else if (os_arch.equals("sparcv9")) {
            platform_arch = "Sparc";
        } else if (os_arch.equals("x86")) {
            platform_arch = "x86";
        } else if (os_arch.equals("i386")) {
            platform_arch = "x86";
        } else if (os_arch.equals("x86_64")) {
            platform_arch = "x86";
        } else if (os_arch.equals("amd64")) {
            platform_arch = "x86";
        } else assert (false) : String.format("Unrecognized os.arch '%s'", os_arch);
        String platform_os = "";
        if (os_name.equals("SunOS")) {
            platform_os = "Solaris";
        } else if (os_name.equals("Linux")) {
            platform_os = "Linux";
        } else if (os_name.equals("Mac OS X")) {
            platform_os = "MacOSX";
        } else if (os_name.startsWith("Windows")) {
            platform_os = "Windows";
        } else assert (false) : String.format("Unrecognized os.name '%s'", os_name);
        return Platform.byName(platform_os + "_" + platform_arch);
    }

    public boolean isSolaris() {
        return this.isSolaris;
    }

    public boolean isLinux() {
        return this.isLinux;
    }

    public String variant() {
        return this.variant;
    }

    public String variant64() {
        return this.variant64;
    }

    static {
        $VALUES = new Platform[]{Linux_x86, Solaris_x86, Solaris_Sparc, MacOSX_x86, Windows_x86, Unknown};
    }
}

