/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.options;

import org.netbeans.modules.cnd.debugger.common2.debugger.options.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.DbgProfile;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.ProfileCategory;
import org.netbeans.modules.cnd.debugger.common2.utils.IpeUtils;

public final class Exceptions
extends ProfileCategory {
    private String[] interceptList = null;
    private String[] interceptExceptList = null;
    private boolean interceptUnhandled = true;
    private boolean interceptUnexpected = true;
    private boolean all = false;

    public Exceptions(DbgProfile owner) {
        super(owner, "interceptlist");
    }

    public boolean equals(Object thatObject) {
        if (this == thatObject) {
            return true;
        }
        if (!(thatObject instanceof Exceptions)) {
            return false;
        }
        Exceptions that = (Exceptions)thatObject;
        if (this.interceptUnhandled != that.interceptUnhandled) {
            return false;
        }
        if (this.interceptUnexpected != that.interceptUnexpected) {
            return false;
        }
        if (this.all != that.all) {
            return false;
        }
        if (!IpeUtils.sameStringArray(this.interceptList, that.interceptList)) {
            return false;
        }
        return IpeUtils.sameStringArray(this.interceptExceptList, that.interceptExceptList);
    }

    public Object clone() {
        Exceptions clone = new Exceptions(null);
        clone.interceptUnhandled = this.interceptUnhandled;
        clone.interceptUnexpected = this.interceptUnexpected;
        clone.all = this.all;
        clone.interceptList = IpeUtils.cloneStringArray(this.interceptList);
        clone.interceptExceptList = IpeUtils.cloneStringArray(this.interceptExceptList);
        return clone;
    }

    public void assign(Object thatObject) {
        if (this.equals(thatObject)) {
            return;
        }
        if (!(thatObject instanceof Exceptions)) {
            return;
        }
        Exceptions that = (Exceptions)thatObject;
        Exceptions old = (Exceptions)this.clone();
        this.interceptUnhandled = that.interceptUnhandled;
        this.interceptUnexpected = that.interceptUnexpected;
        this.all = that.all;
        this.interceptList = IpeUtils.cloneStringArray(that.interceptList);
        this.interceptExceptList = IpeUtils.cloneStringArray(that.interceptExceptList);
        this.delta(old, this);
    }

    public String[] getInterceptList() {
        if (this.interceptList == null) {
            return new String[0];
        }
        return this.interceptList;
    }

    public String[] getInterceptExceptList() {
        if (this.interceptExceptList == null) {
            return new String[0];
        }
        return this.interceptExceptList;
    }

    public boolean isInterceptUnhandled() {
        return this.interceptUnhandled;
    }

    public boolean isInterceptUnexpected() {
        return this.interceptUnexpected;
    }

    public boolean isAll() {
        return this.all;
    }

    public boolean isDefaultValue() {
        return !(this.all || this.interceptList != null && this.interceptList.length != 0 || this.interceptExceptList != null && this.interceptExceptList.length != 0 || !this.interceptUnhandled || !this.interceptUnexpected);
    }

    public void restoreDefaultValue() {
        Exceptions old = (Exceptions)this.clone();
        this.all = false;
        this.interceptList = null;
        this.interceptExceptList = null;
        this.interceptUnhandled = true;
        this.interceptUnexpected = true;
        this.delta(old, this);
    }

    public void setInterceptList(String[] typenames, boolean unhandled, boolean unexpected) {
        String[] newInterceptList = this.checkForAll(typenames);
        if (IpeUtils.sameStringArray(this.interceptList, newInterceptList) && this.interceptUnhandled == unhandled && this.interceptUnexpected == unexpected) {
            return;
        }
        this.interceptList = newInterceptList;
        this.interceptUnhandled = unhandled;
        this.interceptUnexpected = unexpected;
        this.delta(null, null);
    }

    public void setInterceptExceptList(String[] typenames) {
        if (IpeUtils.sameStringArray(this.interceptExceptList, typenames)) {
            return;
        }
        this.interceptExceptList = typenames;
        this.delta(null, null);
    }

    public void setInterceptList(String[] typenames, String[] xtypenames, boolean all, boolean unhandled, boolean unexpected) {
        if (IpeUtils.sameStringArray(this.interceptList, typenames) && IpeUtils.sameStringArray(this.interceptExceptList, xtypenames) && this.all == all && this.interceptUnhandled == unhandled && this.interceptUnexpected == unexpected) {
            return;
        }
        this.interceptList = typenames;
        this.interceptExceptList = xtypenames;
        this.all = all;
        this.interceptUnhandled = unhandled;
        this.interceptUnexpected = unexpected;
        this.delta(null, null);
    }

    private String[] checkForAll(String[] list) {
        for (int lx = 0; lx < list.length; ++lx) {
            if (!"-all".equals(list[lx]) && !"-a".equals(list[lx])) continue;
            this.all = true;
            String[] list2 = new String[list.length - 1];
            System.arraycopy(list, 0, list2, 0, lx);
            System.arraycopy(list, lx + 1, list2, lx, list.length - lx - 1);
            return list2.length == 0 ? null : list2;
        }
        this.all = false;
        return list;
    }

    public String toString() {
        int i;
        String ret = "";
        boolean addSep = false;
        boolean needSpace = false;
        if (this.all) {
            ret = ret + Catalog.get("STR_InterceptAll");
            needSpace = true;
        } else {
            addSep = false;
            if (this.interceptList != null && this.interceptList.length > 0) {
                if (needSpace) {
                    ret = ret + " ";
                }
                ret = ret + Catalog.get("STR_Intercept") + "=";
                for (i = 0; i < this.interceptList.length; ++i) {
                    if (addSep) {
                        ret = ret + ",";
                    }
                    ret = ret + this.interceptList[i];
                    addSep = true;
                }
                needSpace = true;
            }
        }
        addSep = false;
        if (this.interceptExceptList != null && this.interceptExceptList.length > 0) {
            if (needSpace) {
                ret = ret + " ";
            }
            ret = ret + Catalog.get("STR_Ignore") + "=";
            for (i = 0; i < this.interceptExceptList.length; ++i) {
                if (addSep) {
                    ret = ret + ",";
                }
                ret = ret + this.interceptExceptList[i];
                addSep = true;
            }
            needSpace = true;
        }
        if (this.interceptUnhandled) {
            if (needSpace) {
                ret = ret + " ";
            }
            ret = ret + Catalog.get("STR_Unhandled");
            needSpace = true;
        }
        if (this.interceptUnexpected) {
            if (needSpace) {
                ret = ret + " ";
            }
            ret = ret + Catalog.get("STR_Unexpected");
            needSpace = true;
        }
        return ret;
    }
}

