/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.io;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.EnumSet;
import org.netbeans.lib.terminalemulator.ActiveTerm;
import org.netbeans.lib.terminalemulator.Term;
import org.netbeans.modules.cnd.debugger.common2.debugger.DebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.io.TermComponent;
import org.netbeans.modules.cnd.debugger.common2.debugger.io.TermComponentFactory;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.DebuggerOption;
import org.netbeans.modules.cnd.debugger.common2.utils.NotifyingInputSteam;
import org.netbeans.modules.terminal.api.IOTerm;
import org.netbeans.modules.terminal.api.IOTopComponent;
import org.netbeans.modules.terminal.api.IOVisibility;
import org.openide.windows.IOProvider;
import org.openide.windows.IOSelect;
import org.openide.windows.InputOutput;

public class NewTermComponent
implements TermComponent {
    private final IOTopComponent owner;
    private final int flags;
    private final InputOutput io;
    private final ActiveTerm term;

    public NewTermComponent(IOTopComponent owner, int flags) {
        this.owner = owner;
        this.flags = flags;
        TermComponentFactory.ckFlags(flags);
        IOProvider iop = IOProvider.get((String)"Terminal");
        if (iop == null) {
            throw new UnsupportedOperationException("Terminal IO's not available");
        }
        String tabTitle = null;
        this.io = iop.getIO(tabTitle, null, owner.ioContainer());
        if (!IOTerm.isSupported((InputOutput)this.io)) {
            this.io.closeInputOutput();
            throw new UnsupportedOperationException("Terminal IO doesn't provide a Term");
        }
        this.term = (ActiveTerm)IOTerm.term((InputOutput)this.io);
        if (IOVisibility.isSupported((InputOutput)this.io)) {
            IOVisibility.setClosable((InputOutput)this.io, (boolean)false);
        }
    }

    private InputStream interposeActivityDetector(InputStream out) {
        NotifyingInputSteam notifier = new NotifyingInputSteam(out);
        notifier.setListener(new NotifyingInputSteam.Listener(){

            public void activity() {
                if (DebuggerOption.FRONT_PIO.isEnabled(DebuggerManager.get().globalOptions())) {
                    NewTermComponent.this.requestVisible();
                }
            }
        });
        notifier.arm();
        out = notifier;
        return out;
    }

    public void connectIO(OutputStream in, InputStream out) {
        out = this.interposeActivityDetector(out);
        this.term.connect(in, out, null);
    }

    public ActiveTerm getActiveTerm() {
        return this.term;
    }

    public Term getTerm() {
        return this.term;
    }

    public int flags() {
        return this.flags;
    }

    public boolean isPty() {
        return TermComponentFactory.isPty(this.flags);
    }

    public boolean isActive() {
        return TermComponentFactory.isActive(this.flags);
    }

    public boolean isPacketMode() {
        return TermComponentFactory.isPacketMode(this.flags);
    }

    public boolean isRaw() {
        return TermComponentFactory.isRaw(this.flags);
    }

    public void requestVisible() {
        this.owner.topComponent().requestVisible();
    }

    public void switchTo() {
        IOSelect.select((InputOutput)this.io, EnumSet.noneOf(IOSelect.AdditionalOperation.class));
    }

    public void open() {
        this.owner.topComponent().open();
    }

    public void bringUp() {
    }

    public void bringDown() {
        this.io.closeInputOutput();
    }

    public InputOutput getIO() {
        return this.io;
    }
}

