/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.updater;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import java.util.Date;
import java.util.zip.GZIPInputStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexWriter;
import org.apache.maven.index.context.IndexUtils;
import org.apache.maven.index.context.IndexingContext;

public class IndexDataReader {
    private final DataInputStream dis;

    public IndexDataReader(InputStream is) throws IOException {
        FilterInputStream data;
        BufferedInputStream bis = new BufferedInputStream(is, 8192);
        bis.mark(2);
        if (bis.read() == 31 && bis.read() == 139) {
            bis.reset();
            data = new GZIPInputStream((InputStream)bis, 2048);
        } else {
            bis.reset();
            data = bis;
        }
        this.dis = new DataInputStream(data);
    }

    public IndexDataReadResult readIndex(IndexWriter w, IndexingContext context) throws IOException {
        Document doc;
        long timestamp = this.readHeader();
        Date date = null;
        if (timestamp != -1L) {
            date = new Date(timestamp);
            IndexUtils.updateTimestamp(w.getDirectory(), date);
        }
        int n = 0;
        while ((doc = this.readDocument()) != null) {
            w.addDocument(IndexUtils.updateDocument(doc, context, false));
            ++n;
        }
        w.commit();
        w.optimize();
        IndexDataReadResult result = new IndexDataReadResult();
        result.setDocumentCount(n);
        result.setTimestamp(date);
        return result;
    }

    public long readHeader() throws IOException {
        boolean HDRBYTE = true;
        if (1 != this.dis.readByte()) {
            throw new IOException("Provided input contains unexpected data (0x01 expected as 1st byte)!");
        }
        return this.dis.readLong();
    }

    public Document readDocument() throws IOException {
        int fieldCount;
        try {
            fieldCount = this.dis.readInt();
        }
        catch (EOFException ex) {
            return null;
        }
        Document doc = new Document();
        for (int i = 0; i < fieldCount; ++i) {
            doc.add((Fieldable)this.readField());
        }
        return doc;
    }

    private Field readField() throws IOException {
        int flags = this.dis.read();
        Field.Index index = Field.Index.NO;
        if ((flags & 1) > 0) {
            boolean isTokenized = (flags & 2) > 0;
            index = isTokenized ? Field.Index.ANALYZED : Field.Index.NOT_ANALYZED;
        }
        Field.Store store = Field.Store.NO;
        if ((flags & 4) > 0) {
            store = Field.Store.YES;
        }
        String name = this.dis.readUTF();
        String value = IndexDataReader.readUTF(this.dis);
        return new Field(name, value, store, index);
    }

    private static final String readUTF(DataInput in) throws IOException {
        int c;
        int count;
        int utflen = in.readInt();
        byte[] bytearr = new byte[utflen];
        char[] chararr = new char[utflen];
        int chararr_count = 0;
        in.readFully(bytearr, 0, utflen);
        for (count = 0; count < utflen && (c = bytearr[count] & 0xFF) <= 127; ++count) {
            chararr[chararr_count++] = (char)c;
        }
        block6: while (count < utflen) {
            c = bytearr[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    chararr[chararr_count++] = (char)c;
                    continue block6;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + count);
                    }
                    chararr[chararr_count++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block6;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + (count - 1));
                    }
                    chararr[chararr_count++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    continue block6;
                }
            }
            throw new UTFDataFormatException("malformed input around byte " + count);
        }
        return new String(chararr, 0, chararr_count);
    }

    public IndexDataReadResult readIndex(IndexDataReadVisitor visitor, IndexingContext context) throws IOException {
        Document doc;
        this.dis.readByte();
        long timestamp = this.dis.readLong();
        Date date = null;
        if (timestamp != -1L) {
            date = new Date(timestamp);
        }
        int n = 0;
        while ((doc = this.readDocument()) != null) {
            visitor.visitDocument(IndexUtils.updateDocument(doc, context, false));
            ++n;
        }
        IndexDataReadResult result = new IndexDataReadResult();
        result.setDocumentCount(n);
        result.setTimestamp(date);
        return result;
    }

    public static interface IndexDataReadVisitor {
        public void visitDocument(Document var1);
    }

    public static class IndexDataReadResult {
        private Date timestamp;
        private int documentCount;

        public void setDocumentCount(int documentCount) {
            this.documentCount = documentCount;
        }

        public int getDocumentCount() {
            return this.documentCount;
        }

        public void setTimestamp(Date timestamp) {
            this.timestamp = timestamp;
        }

        public Date getTimestamp() {
            return this.timestamp;
        }
    }
}

