/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.context;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.maven.index.artifact.GavCalculator;
import org.apache.maven.index.artifact.M2GavCalculator;
import org.apache.maven.index.context.AbstractIndexingContext;
import org.apache.maven.index.context.ContextMemberProvider;
import org.apache.maven.index.context.DocumentFilter;
import org.apache.maven.index.context.IndexCreator;
import org.apache.maven.index.context.IndexingContext;
import org.apache.maven.index.context.NexusAnalyzer;
import org.apache.maven.index.context.NexusIndexSearcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergedIndexingContext
extends AbstractIndexingContext {
    private final String id;
    private final String repositoryId;
    private final File repository;
    private final ContextMemberProvider membersProvider;
    private final GavCalculator gavCalculator;
    private final Directory directory;
    private File directoryFile;
    private boolean searchable;

    private MergedIndexingContext(ContextMemberProvider membersProvider, String id, String repositoryId, File repository, Directory indexDirectory, boolean searchable) throws IOException {
        this.id = id;
        this.repositoryId = repositoryId;
        this.repository = repository;
        this.membersProvider = membersProvider;
        this.gavCalculator = new M2GavCalculator();
        this.directory = indexDirectory;
        this.searchable = searchable;
    }

    public MergedIndexingContext(String id, String repositoryId, File repository, File indexDirectoryFile, boolean searchable, ContextMemberProvider membersProvider) throws IOException {
        this(membersProvider, id, repositoryId, repository, (Directory)FSDirectory.open((File)indexDirectoryFile), searchable);
        this.directoryFile = indexDirectoryFile;
    }

    public MergedIndexingContext(String id, String repositoryId, File repository, Directory indexDirectory, boolean searchable, ContextMemberProvider membersProvider) throws IOException {
        this(membersProvider, id, repositoryId, repository, indexDirectory, searchable);
        if (indexDirectory instanceof FSDirectory) {
            this.directoryFile = ((FSDirectory)indexDirectory).getFile();
        }
    }

    public Collection<IndexingContext> getMembers() {
        return this.membersProvider.getMembers();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getRepositoryId() {
        return this.repositoryId;
    }

    @Override
    public File getRepository() {
        return this.repository;
    }

    @Override
    public String getRepositoryUrl() {
        return null;
    }

    @Override
    public String getIndexUpdateUrl() {
        return null;
    }

    @Override
    public boolean isSearchable() {
        return this.searchable;
    }

    @Override
    public void setSearchable(boolean searchable) {
        this.searchable = searchable;
    }

    @Override
    public Date getTimestamp() {
        Date ts = null;
        for (IndexingContext ctx : this.getMembers()) {
            Date cts = ctx.getTimestamp();
            if (cts == null || ts != null && !cts.after(ts)) continue;
            ts = cts;
        }
        return ts;
    }

    @Override
    public void updateTimestamp() throws IOException {
    }

    @Override
    public void updateTimestamp(boolean save) throws IOException {
    }

    @Override
    public void updateTimestamp(boolean save, Date date) throws IOException {
    }

    @Override
    public int getSize() throws IOException {
        int size = 0;
        for (IndexingContext ctx : this.getMembers()) {
            size += ctx.getSize();
        }
        return size;
    }

    @Override
    public IndexReader getIndexReader() throws IOException {
        Collection<IndexingContext> members = this.getMembers();
        ArrayList<IndexReader> contextsToSearch = new ArrayList<IndexReader>(members.size());
        for (IndexingContext ctx : members) {
            contextsToSearch.add(ctx.getIndexReader());
        }
        MultiReader multiReader = new MultiReader(contextsToSearch.toArray(new IndexReader[contextsToSearch.size()]));
        return multiReader;
    }

    @Override
    public IndexSearcher getIndexSearcher() throws IOException {
        return new NexusIndexSearcher(this.getIndexReader());
    }

    @Override
    public IndexWriter getIndexWriter() throws IOException {
        return null;
    }

    @Override
    public List<IndexCreator> getIndexCreators() {
        HashSet<IndexCreator> creators = new HashSet<IndexCreator>();
        for (IndexingContext ctx : this.getMembers()) {
            creators.addAll(ctx.getIndexCreators());
        }
        return new ArrayList<IndexCreator>(creators);
    }

    @Override
    public Analyzer getAnalyzer() {
        return new NexusAnalyzer();
    }

    @Override
    public void commit() throws IOException {
    }

    @Override
    public void rollback() throws IOException {
    }

    @Override
    public void optimize() throws IOException {
    }

    @Override
    public void lock() {
        for (IndexingContext ctx : this.getMembers()) {
            ctx.lock();
        }
    }

    @Override
    public void unlock() {
        for (IndexingContext ctx : this.getMembers()) {
            ctx.unlock();
        }
    }

    @Override
    public void close(boolean deleteFiles) throws IOException {
    }

    @Override
    public void purge() throws IOException {
    }

    @Override
    public void merge(Directory directory) throws IOException {
    }

    @Override
    public void merge(Directory directory, DocumentFilter filter) throws IOException {
    }

    @Override
    public void replace(Directory directory) throws IOException {
    }

    @Override
    public Directory getIndexDirectory() {
        return this.directory;
    }

    @Override
    public File getIndexDirectoryFile() {
        return this.directoryFile;
    }

    @Override
    public GavCalculator getGavCalculator() {
        return this.gavCalculator;
    }

    @Override
    public void setAllGroups(Collection<String> groups) throws IOException {
    }

    @Override
    public Set<String> getAllGroups() throws IOException {
        HashSet<String> result = new HashSet<String>();
        for (IndexingContext ctx : this.getMembers()) {
            result.addAll(ctx.getAllGroups());
        }
        return result;
    }

    @Override
    public void setRootGroups(Collection<String> groups) throws IOException {
    }

    @Override
    public Set<String> getRootGroups() throws IOException {
        HashSet<String> result = new HashSet<String>();
        for (IndexingContext ctx : this.getMembers()) {
            result.addAll(ctx.getRootGroups());
        }
        return result;
    }

    @Override
    public void rebuildGroups() throws IOException {
    }
}

