/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.websvc.core.ServerType;
import org.netbeans.modules.websvc.core.WSStackUtils;
import org.netbeans.modules.websvc.wsstack.api.WSStack;
import org.netbeans.modules.websvc.wsstack.jaxrpc.JaxRpc;
import org.netbeans.modules.websvc.wsstack.jaxrpc.JaxRpcStackProvider;
import org.netbeans.modules.websvc.wsstack.jaxws.JaxWs;
import org.netbeans.modules.websvc.wsstack.jaxws.JaxWsStackProvider;

public class ProjectInfo {
    private Project project;
    private int projectType;
    public static final int JSE_PROJECT_TYPE = 0;
    public static final int WEB_PROJECT_TYPE = 1;
    public static final int EJB_PROJECT_TYPE = 2;
    public static final int CAR_PROJECT_TYPE = 3;
    private boolean jsr109Supported = false;
    private boolean jsr109oldSupported = false;
    private boolean wsgenSupported = false;
    private boolean wsimportSupported = false;
    private ServerType serverType;

    public ProjectInfo(Project project) {
        this.project = project;
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider != null) {
            J2eeModule j2eeModule;
            J2eeModule.Type moduleType;
            String serverInstanceId = j2eeModuleProvider.getServerInstanceID();
            if (serverInstanceId != null) {
                try {
                    J2eePlatform j2eePlatform = Deployment.getDefault().getServerInstance(serverInstanceId).getJ2eePlatform();
                    if (j2eePlatform != null) {
                        WSStack jaxRpcStack;
                        WSStack wsStack = JaxWsStackProvider.getJaxWsStack((J2eePlatform)j2eePlatform);
                        if (wsStack != null) {
                            this.jsr109Supported = wsStack.isFeatureSupported((WSStack.Feature)JaxWs.Feature.JSR109);
                            this.serverType = WSStackUtils.getServerType(project);
                            this.wsgenSupported = true;
                            this.wsimportSupported = true;
                        }
                        if ((jaxRpcStack = JaxRpcStackProvider.getJaxWsStack((J2eePlatform)j2eePlatform)) != null) {
                            this.jsr109oldSupported = jaxRpcStack.isFeatureSupported((WSStack.Feature)JaxRpc.Feature.JSR109);
                        }
                    }
                }
                catch (InstanceRemovedException ex) {
                    Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Failed to find J2eePlatform", ex);
                }
            }
            this.projectType = J2eeModule.Type.EJB.equals(moduleType = (j2eeModule = j2eeModuleProvider.getJ2eeModule()).getType()) ? 2 : (J2eeModule.Type.WAR.equals(moduleType) ? 1 : (J2eeModule.Type.CAR.equals(moduleType) ? 3 : 0));
        } else {
            this.projectType = 0;
        }
    }

    public int getProjectType() {
        return this.projectType;
    }

    public Project getProject() {
        return this.project;
    }

    public boolean isJsr109Supported() {
        return this.jsr109Supported;
    }

    public boolean isJsr109oldSupported() {
        return this.jsr109oldSupported;
    }

    public boolean isWsgenSupported() {
        return this.wsgenSupported;
    }

    public boolean isWsimportSupported() {
        return this.wsimportSupported;
    }

    public ServerType getServerType() {
        return this.serverType;
    }
}

