/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.gizmo.ui;

import java.awt.event.ActionEvent;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.modules.cnd.gizmo.GizmoServiceInfoAccessor;
import org.netbeans.modules.cnd.gizmo.support.GizmoServiceInfo;
import org.netbeans.modules.cnd.gizmo.ui.GizmoIndicatorTopComponentRegsitry;
import org.netbeans.modules.cnd.gizmo.ui.GizmoIndicatorsTopComponent;
import org.netbeans.modules.cnd.gizmo.ui.GizmoIndicatorsTopComponentActionsProvider;
import org.netbeans.modules.dlight.management.api.DLightSession;
import org.netbeans.modules.dlight.management.api.SessionStateListener;
import org.netbeans.modules.dlight.management.ui.spi.IndicatorComponentDelegator;
import org.netbeans.modules.dlight.spi.storage.ServiceInfoDataStorage;
import org.netbeans.modules.dlight.util.UIThread;

public final class GizmoIndicatorDelegator
implements IndicatorComponentDelegator,
GizmoIndicatorsTopComponentActionsProvider {
    public void activeSessionChanged(DLightSession oldSession, DLightSession newSession) {
        if (oldSession == newSession) {
            return;
        }
        if (oldSession != null) {
            oldSession.removeSessionStateListener((SessionStateListener)this);
        }
        if (newSession != null && newSession.getState() != DLightSession.SessionState.CLOSED) {
            newSession.addSessionStateListener((SessionStateListener)this);
        }
        if (newSession != null && newSession.getState() == DLightSession.SessionState.CLOSED) {
            return;
        }
    }

    private String getProjectFolder(DLightSession session) {
        if (session == null) {
            return null;
        }
        ServiceInfoDataStorage serviceInfoStorage = session.getServiceInfoDataStorage();
        return serviceInfoStorage.getValue("GizmoProjectFolder");
    }

    private String getProjectHost(DLightSession session) {
        if (session == null) {
            return null;
        }
        ServiceInfoDataStorage serviceInfoStorage = session.getServiceInfoDataStorage();
        return serviceInfoStorage.getValue("GizmoProjectHost");
    }

    private String getPlatform(DLightSession session) {
        if (session == null) {
            return null;
        }
        ServiceInfoDataStorage serviceInfoStorage = session.getServiceInfoDataStorage();
        return serviceInfoStorage.getValue("gizmo.platform");
    }

    private GizmoIndicatorsTopComponent getComponent(DLightSession newSession) {
        String projectFolder = this.getProjectFolder(newSession);
        String projectHost = this.getProjectHost(newSession);
        GizmoIndicatorsTopComponent topComponent = GizmoIndicatorsTopComponent.findInstance();
        topComponent.setActionsProvider(this);
        if (GizmoIndicatorTopComponentRegsitry.getRegistry().getOpened().isEmpty()) {
            return topComponent;
        }
        boolean isCurrentPlatformSupported = GizmoServiceInfo.isPlatformSupported(this.getPlatform(newSession));
        if (!isCurrentPlatformSupported && !GizmoServiceInfo.isPlatformSupported(this.getPlatform(topComponent.getSession()))) {
            return topComponent;
        }
        for (GizmoIndicatorsTopComponent tc : GizmoIndicatorTopComponentRegsitry.getRegistry().getOpened()) {
            DLightSession tcSession = tc.getSession();
            if (tcSession == null && newSession != null) {
                tc.setActionsProvider(this);
                return tc;
            }
            if (!isCurrentPlatformSupported && !GizmoServiceInfo.isPlatformSupported(this.getPlatform(tcSession))) {
                return tc;
            }
            String sessionPF = this.getProjectFolder(tcSession);
            String sessionPH = this.getProjectHost(tcSession);
            if (sessionPF == null || sessionPH == null || !sessionPF.equals(projectFolder) || !sessionPH.equals(projectHost)) continue;
            if (tcSession != null && (tcSession.getState() == DLightSession.SessionState.ANALYZE || tcSession.getState() == DLightSession.SessionState.CLOSED)) {
                return tc;
            }
            if (tcSession != null) continue;
            return tc;
        }
        GizmoIndicatorsTopComponent result = GizmoIndicatorsTopComponent.newInstance();
        result.setActionsProvider(this);
        return result;
    }

    public void sessionStateChanged(final DLightSession session, DLightSession.SessionState oldState, DLightSession.SessionState newState) {
        if (newState == DLightSession.SessionState.STARTING) {
            if (!this.needToHandle(session)) {
                session.removeSessionStateListener((SessionStateListener)this);
                return;
            }
            UIThread.invoke((Runnable)new Runnable(){

                @Override
                public void run() {
                    GizmoIndicatorsTopComponent indicators = GizmoIndicatorDelegator.this.getComponent(session);
                    indicators.setSession(session);
                    indicators.open();
                    if (GizmoServiceInfo.isPlatformSupported(GizmoIndicatorDelegator.this.getPlatform(session)) || !GizmoIndicatorTopComponentRegsitry.getRegistry().getOpened().contains((Object)indicators)) {
                        indicators.requestActive();
                    }
                }
            });
        }
    }

    public void sessionAdded(DLightSession newSession) {
    }

    public void sessionRemoved(DLightSession removedSession) {
    }

    @Override
    public Action[] getActions(GizmoIndicatorsTopComponent source) {
        GizmoIndicatorTopComponentRegsitry registry = GizmoIndicatorTopComponentRegsitry.getRegistry();
        Set<GizmoIndicatorsTopComponent> topComponents = registry.getOpened();
        if (topComponents != null) {
            topComponents.remove((Object)source);
            if (!topComponents.isEmpty()) {
                Action[] result = new Action[topComponents.size()];
                int i = 0;
                for (final GizmoIndicatorsTopComponent tc : topComponents) {
                    result[i] = new AbstractAction(tc.getDisplayName()){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            tc.requestActive();
                        }
                    };
                    ++i;
                }
                return result;
            }
        }
        return null;
    }

    private boolean needToHandle(DLightSession session) {
        ServiceInfoDataStorage serviceInfoStorage = session.getServiceInfoDataStorage();
        return serviceInfoStorage.getValue(GizmoServiceInfoAccessor.getDefault().getGIZMO_RUN()) != null;
    }
}

