/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.gizmo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.gizmo.api.GizmoOptionsProvider;
import org.netbeans.modules.cnd.gizmo.spi.GizmoOptions;
import org.netbeans.modules.cnd.gizmo.support.GizmoServiceInfo;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.DevelopmentHostConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.dlight.api.tool.DLightConfiguration;
import org.netbeans.modules.dlight.api.tool.DLightConfigurationOptions;
import org.netbeans.modules.dlight.api.tool.DLightConfigurationOptionsListener;
import org.netbeans.modules.dlight.api.tool.DLightTool;
import org.netbeans.modules.dlight.spi.collector.DataCollector;
import org.netbeans.modules.dlight.spi.indicator.IndicatorDataProvider;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;

public class GizmoConfigurationOptions
implements DLightConfigurationOptions {
    private static final boolean DISABLE_LL_TOOL_ON_UBUNTU = Boolean.parseBoolean(System.getProperty("DISABLE_LL_TOOL_ON_UBUNTU", "true"));
    private final List<DLightConfigurationOptionsListener> listeners = new ArrayList<DLightConfigurationOptionsListener>();
    private static final Logger log = DLightLogger.getLogger(GizmoConfigurationOptions.class);
    private String DLightCollectorString = "SunStudio";
    private List<String> DLightIndicatorDPStrings = Arrays.asList("SunStudio");
    private static final String SUNSTUDIO = "SunStudio";
    private static final String LL_MONITOR = "LLTool";
    private static final String DTRACE = "DTrace";
    private static final String PRSTAT_INDICATOR = "prstat";
    private static final String PROC_READER = "ProcReader";
    private static final String PROCFS_READER = "ProcFSReader";
    private Project currentProject;
    private boolean areCollectorsTurnedOn = false;
    private boolean profileOnRun = true;
    private GizmoOptions gizmoOptions = null;

    public void turnCollectorsState(boolean turnState) {
        this.areCollectorsTurnedOn = turnState;
    }

    public boolean profileOnRun() {
        return this.profileOnRun;
    }

    public Collection<String> getActiveToolNames() {
        if (this.gizmoOptions == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        Collection<String> allNames = this.gizmoOptions.getNames();
        for (String name : allNames) {
            result.add(name);
        }
        return result;
    }

    public void configure(Project project) {
        boolean isLinux;
        this.turnCollectorsState(true);
        this.currentProject = project;
        Configuration activeConfiguration = this.getActiveConfiguration();
        this.gizmoOptions = GizmoOptionsProvider.getOptions(activeConfiguration);
        this.gizmoOptions.init(activeConfiguration);
        this.profileOnRun = this.gizmoOptions.getProfileOnRunValue();
        if (!(activeConfiguration instanceof MakeConfiguration)) {
            return;
        }
        DevelopmentHostConfiguration developmentHost = ((MakeConfiguration)activeConfiguration).getDevelopmentHost();
        ExecutionEnvironment execEnv = developmentHost.getExecutionEnvironment();
        String platform = developmentHost.getBuildPlatformDisplayName();
        HostInfo hostInfo = null;
        try {
            hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)execEnv);
        }
        catch (Throwable ex) {
            // empty catch block
        }
        if (hostInfo == null) {
            return;
        }
        CompilerSetManager compilerSetManager = CompilerSetManager.get((ExecutionEnvironment)execEnv);
        List compilers = compilerSetManager.getCompilerSets();
        boolean hasSunStudio = false;
        for (CompilerSet cs : compilers) {
            if (!cs.getCompilerFlavor().isSunStudioCompiler()) continue;
            hasSunStudio = true;
            break;
        }
        DLightConfiguration dlightConfiguration = this.gizmoOptions.getDLightConfiguration();
        this.DLightCollectorString = dlightConfiguration.getCollectorProviders();
        this.DLightIndicatorDPStrings = dlightConfiguration.getIndicatorProviders();
        boolean isUnsupportedPlatform = !GizmoServiceInfo.isPlatformSupported(platform);
        boolean isSunStudioCollectorSelected = SUNSTUDIO.equals(this.DLightCollectorString);
        boolean bl = isLinux = hostInfo.getOSFamily() == HostInfo.OSFamily.LINUX;
        if (isLinux || isUnsupportedPlatform) {
            this.turnCollectorsState(isSunStudioCollectorSelected && hasSunStudio);
            this.DLightIndicatorDPStrings = DISABLE_LL_TOOL_ON_UBUNTU && hostInfo.getOS().getName().toLowerCase().contains("ubuntu") ? Arrays.asList(PROCFS_READER, PROC_READER) : Arrays.asList(PROCFS_READER, PROC_READER, LL_MONITOR);
        }
    }

    private Configuration getActiveConfiguration() {
        return ConfigurationSupport.getProjectActiveConfiguration((Project)this.currentProject);
    }

    public boolean areCollectorsTurnedOn() {
        return this.areCollectorsTurnedOn;
    }

    public List<DataCollector<?>> getCollectors(DLightTool tool) {
        List collectors = tool.getCollectors();
        ArrayList result = new ArrayList();
        for (DataCollector collector : collectors) {
            if (!collector.getName().equals(this.DLightCollectorString)) continue;
            result.add(collector);
        }
        return result;
    }

    public List<IndicatorDataProvider<?>> getIndicatorDataProviders(DLightTool tool) {
        List idps = tool.getIndicatorDataProviders();
        ArrayList result = new ArrayList();
        block0: for (IndicatorDataProvider idp : idps) {
            for (String idpStringName : this.DLightIndicatorDPStrings) {
                if (!idp.getName().equals(idpStringName)) continue;
                result.add(idp);
                continue block0;
            }
        }
        return result;
    }

    public boolean validateToolsRequiredUserInteraction() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(DLightConfigurationOptionsListener listener) {
        if (listener == null) {
            return;
        }
        GizmoConfigurationOptions gizmoConfigurationOptions = this;
        synchronized (gizmoConfigurationOptions) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(DLightConfigurationOptionsListener listener) {
        GizmoConfigurationOptions gizmoConfigurationOptions = this;
        synchronized (gizmoConfigurationOptions) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(String toolName, boolean isEnabled) {
        GizmoConfigurationOptions gizmoConfigurationOptions = this;
        synchronized (gizmoConfigurationOptions) {
            for (DLightConfigurationOptionsListener l : this.listeners) {
                l.dlightToolEnabling(toolName, isEnabled);
            }
        }
    }
}

