/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.ui;

import java.awt.EventQueue;
import java.util.Comparator;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.tasklist.impl.Accessor;
import org.netbeans.modules.tasklist.impl.TaskComparator;
import org.netbeans.modules.tasklist.impl.TaskList;
import org.netbeans.modules.tasklist.trampoline.TaskGroup;
import org.netbeans.modules.tasklist.ui.Settings;
import org.netbeans.spi.tasklist.Task;
import org.openide.util.NbBundle;

class TaskListModel
extends AbstractTableModel
implements TaskList.Listener {
    protected TaskList list;
    protected static final int COL_GROUP = 0;
    protected static final int COL_DESCRIPTION = 1;
    protected static final int COL_FILE = 2;
    protected static final int COL_LOCATION = 3;
    protected int sortingCol = -1;
    protected boolean ascending = true;

    public TaskListModel(TaskList taskList) {
        this.list = taskList;
        this.sortingCol = Settings.getDefault().getSortingColumn();
        this.ascending = Settings.getDefault().isAscendingSort();
        this.sortTaskList();
    }

    @Override
    public int getRowCount() {
        return null == this.list ? 0 : this.list.size();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public Class<?> getColumnClass(int column) {
        if (0 == column) {
            return TaskGroup.class;
        }
        return super.getColumnClass(column);
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "";
            }
            case 1: {
                return NbBundle.getMessage(TaskListModel.class, (String)"LBL_COL_Description");
            }
            case 2: {
                return NbBundle.getMessage(TaskListModel.class, (String)"LBL_COL_File");
            }
            case 3: {
                return NbBundle.getMessage(TaskListModel.class, (String)"LBL_COL_Location");
            }
        }
        return super.getColumnName(column);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int row, int col) {
        Task t = this.getTaskAtRow(row);
        if (null != t) {
            switch (col) {
                case 0: {
                    return Accessor.getGroup(t);
                }
                case 1: {
                    return Accessor.getDescription(t);
                }
                case 2: {
                    return Accessor.getFileNameExt(t);
                }
                case 3: {
                    return Accessor.getLocation(t);
                }
            }
        }
        return null;
    }

    protected Task getTaskAtRow(int row) {
        return this.list.getTask(row);
    }

    @Override
    public void tasksAdded(List<? extends Task> tasks) {
        if (tasks.isEmpty()) {
            return;
        }
        final int startRow = this.list.indexOf(tasks.get(0));
        final int endRow = this.list.indexOf(tasks.get(tasks.size() - 1));
        if (startRow > -1 && endRow > -1) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TaskListModel.this.fireTableRowsInserted(startRow, endRow);
                }
            });
        }
    }

    @Override
    public void tasksRemoved(List<? extends Task> tasks) {
        if (tasks.isEmpty()) {
            return;
        }
        final int startRow = this.list.indexOf(tasks.get(0));
        final int endRow = this.list.indexOf(tasks.get(tasks.size() - 1));
        if (startRow > -1 && endRow > -1) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TaskListModel.this.fireTableRowsDeleted(startRow, endRow);
                }
            });
        }
    }

    @Override
    public void cleared() {
        this.fireTableDataChanged();
    }

    public void toggleSort(int column) {
        if (column != this.sortingCol) {
            this.sortingCol = column;
            this.ascending = true;
        } else if (this.ascending) {
            this.ascending = false;
        } else {
            this.sortingCol = -1;
        }
        this.sortTaskList();
    }

    protected void sortTaskList() {
        Comparator<Task> comparator = null;
        switch (this.sortingCol) {
            case 1: {
                comparator = TaskComparator.getDescriptionComparator(this.ascending);
                break;
            }
            case 3: {
                comparator = TaskComparator.getLocationComparator(this.ascending);
                break;
            }
            case 2: {
                comparator = TaskComparator.getFileComparator(this.ascending);
                break;
            }
            default: {
                comparator = TaskComparator.getDefault();
            }
        }
        this.list.setComparator(comparator);
        Settings.getDefault().setSortingColumn(this.sortingCol);
        Settings.getDefault().setAscendingSort(this.ascending);
        this.fireTableDataChanged();
    }

    public int getSortingColumnn() {
        return this.sortingCol;
    }

    public boolean isAscendingSort() {
        return this.ascending;
    }

    public void setAscendingSort(boolean asc) {
        if (this.sortingCol >= 0) {
            this.ascending = asc;
            this.sortTaskList();
        }
    }

    void attach() {
        this.list.addListener(this);
    }

    void detach() {
        this.list.removeListener(this);
    }
}

