/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.filter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.modules.tasklist.filter.AppliedFilterCondition;
import org.netbeans.modules.tasklist.filter.FilterCondition;
import org.netbeans.modules.tasklist.filter.StringFilterCondition;
import org.netbeans.modules.tasklist.filter.TaskGroupCondition;
import org.netbeans.modules.tasklist.filter.TaskProperties;
import org.netbeans.modules.tasklist.filter.TaskProperty;
import org.netbeans.spi.tasklist.Task;
import org.openide.util.NbBundle;

class KeywordsFilter {
    private boolean allTrue = false;
    private List<AppliedFilterCondition> appliedConditions = null;
    private static final String NO_FILTER = NbBundle.getMessage(KeywordsFilter.class, (String)"no-filter");
    private static final TaskProperty[] PROPS = new TaskProperty[]{TaskProperties.PROP_DESCRIPTION, TaskProperties.PROP_GROUP, TaskProperties.PROP_FILE, TaskProperties.PROP_LOCATION};

    public KeywordsFilter() {
        this(true, new ArrayList<AppliedFilterCondition>());
    }

    public KeywordsFilter(boolean allTrue, List<AppliedFilterCondition> conditions) {
        this.allTrue = allTrue;
        this.appliedConditions = conditions;
    }

    protected KeywordsFilter(KeywordsFilter rhs) {
        this(rhs.allTrue, KeywordsFilter.cloneConditions(rhs.appliedConditions));
    }

    private static List<AppliedFilterCondition> cloneConditions(List<AppliedFilterCondition> conditions) {
        LinkedList<AppliedFilterCondition> l = new LinkedList<AppliedFilterCondition>();
        Iterator<AppliedFilterCondition> it = conditions.iterator();
        while (it.hasNext()) {
            l.add((AppliedFilterCondition)it.next().clone());
        }
        return l;
    }

    public Object clone() {
        return new KeywordsFilter(this);
    }

    public AppliedFilterCondition[] createConditions(TaskProperty property) {
        if (property.equals(TaskProperties.PROP_GROUP)) {
            return KeywordsFilter.applyConditions(property, TaskGroupCondition.createConditions());
        }
        if (property.equals(TaskProperties.PROP_DESCRIPTION)) {
            return KeywordsFilter.applyConditions(property, StringFilterCondition.createConditions());
        }
        if (property.equals(TaskProperties.PROP_FILE)) {
            return KeywordsFilter.applyConditions(property, StringFilterCondition.createConditions());
        }
        if (property.equals(TaskProperties.PROP_LOCATION)) {
            return KeywordsFilter.applyConditions(property, StringFilterCondition.createConditions());
        }
        throw new IllegalArgumentException("wrong property");
    }

    public TaskProperty[] getProperties() {
        return PROPS;
    }

    public void clear() {
        this.getConditions().clear();
    }

    public boolean accept(Task t) {
        if (!this.hasConstraints()) {
            return true;
        }
        Iterator<AppliedFilterCondition> it = this.appliedConditions.iterator();
        boolean b = true;
        while (it.hasNext()) {
            AppliedFilterCondition acond = it.next();
            b = acond.isTrue(t);
            if (b && !this.allTrue) {
                return true;
            }
            if (b || !this.allTrue) continue;
            return false;
        }
        return b;
    }

    public boolean matchAll() {
        return this.allTrue;
    }

    public boolean hasConstraints() {
        return this.appliedConditions != null && this.appliedConditions.size() > 0;
    }

    public void setMatchAll(boolean b) {
        if (this.allTrue != b) {
            this.allTrue = b;
        }
    }

    public final List getConditions() {
        return this.appliedConditions;
    }

    public final void setConditions(List<AppliedFilterCondition> conditions) {
        this.appliedConditions = conditions;
    }

    public String toString() {
        Iterator<AppliedFilterCondition> it = this.appliedConditions.iterator();
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName() + "[");
        sb.append(this.allTrue ? "ALL of the following conditions" : "ANY of the following conditions");
        sb.append(", ");
        while (it.hasNext()) {
            sb.append(it.next());
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    protected static AppliedFilterCondition[] applyConditions(TaskProperty property, FilterCondition[] conds) {
        if (conds == null) {
            return null;
        }
        AppliedFilterCondition[] applied = new AppliedFilterCondition[conds.length];
        for (int i = 0; i < conds.length; ++i) {
            applied[i] = new AppliedFilterCondition(property, conds[i]);
        }
        return applied;
    }

    static FilterCondition createCondition(TaskProperty property) {
        if (property.getID().equals(TaskProperties.PROP_GROUP.getID())) {
            return new TaskGroupCondition();
        }
        return new StringFilterCondition();
    }

    void load(Preferences prefs, String prefix) throws BackingStoreException {
        this.allTrue = prefs.getBoolean(prefix + "_allTrue", false);
        this.appliedConditions.clear();
        int count = prefs.getInt(prefix + "_count", 0);
        for (int i = 0; i < count; ++i) {
            AppliedFilterCondition cond = new AppliedFilterCondition();
            cond.load(prefs, prefix + "_condition_" + i);
            this.appliedConditions.add(cond);
        }
    }

    void save(Preferences prefs, String prefix) throws BackingStoreException {
        prefs.putBoolean(prefix + "_allTrue", this.allTrue);
        prefs.putInt(prefix + "_count", this.appliedConditions.size());
        for (int i = 0; i < this.appliedConditions.size(); ++i) {
            this.appliedConditions.get(i).save(prefs, prefix + "_condition_" + i);
        }
    }
}

