/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.netbeans.modules.css.visual.model.BorderModel;
import org.netbeans.modules.css.visual.model.PropertyWithUnitData;
import org.netbeans.modules.css.visual.model.Utils;
import org.openide.util.NbBundle;

public class BorderWidthField
extends JPanel {
    PropertyWithUnitData borderWidthData = new PropertyWithUnitData();
    BorderModel borderModel = new BorderModel();
    private JComboBox borderWidthCombo;
    private JComboBox borderWidthUnitCombo;

    public BorderWidthField() {
        this.initComponents();
        this.borderWidthCombo.setModel(this.borderModel.getWidthList());
        this.borderWidthUnitCombo.setModel(this.borderModel.getWidthUnitList());
        final JTextField borderWidthComboEditor = (JTextField)this.borderWidthCombo.getEditor().getEditorComponent();
        borderWidthComboEditor.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BorderWidthField.this.borderWidthUnitCombo.setEnabled(Utils.isInteger(borderWidthComboEditor.getText()));
                    }
                });
            }
        });
    }

    public void setWidthString(String widthStr) {
        if (widthStr != null && !widthStr.equals("")) {
            if (Utils.isInteger(widthStr)) {
                this.setWidthValue(widthStr);
            } else {
                String unit = this.getUnit(widthStr);
                this.setWidthUnit(unit);
                this.setWidthValue(widthStr.replaceAll(unit, "").trim());
            }
        } else {
            this.setWidthValue(null);
            this.setWidthUnit(null);
        }
    }

    public String getWidthString() {
        return this.borderWidthData.toString();
    }

    private String getUnit(String widthStr) {
        DefaultComboBoxModel unitList = this.borderModel.getWidthUnitList();
        for (int i = 0; i < unitList.getSize(); ++i) {
            String unit = (String)unitList.getElementAt(i);
            if (!widthStr.trim().endsWith(unit)) continue;
            return unit;
        }
        return "";
    }

    public void setWidthValue(String value) {
        if (value == null || value.equals("")) {
            this.borderWidthCombo.setSelectedIndex(0);
        } else {
            this.borderWidthCombo.setSelectedItem(value);
            this.borderWidthData.setValue(value);
        }
    }

    public void setWidthUnit(String value) {
        if (value == null || value.equals("")) {
            this.borderWidthUnitCombo.setSelectedIndex(this.borderModel.getWidthUnitList().getIndexOf("px"));
        } else {
            if (this.borderModel.getWidthUnitList().getIndexOf(value) != -1) {
                this.borderWidthUnitCombo.setSelectedIndex(this.borderModel.getWidthUnitList().getIndexOf(value));
            } else {
                this.borderWidthUnitCombo.setSelectedIndex(this.borderModel.getWidthUnitList().getIndexOf("px"));
            }
            this.borderWidthData.setUnit(value);
        }
    }

    private void initComponents() {
        this.borderWidthCombo = new JComboBox();
        this.borderWidthUnitCombo = new JComboBox();
        this.setLayout(new BorderLayout(3, 0));
        this.borderWidthCombo.setEditable(true);
        this.borderWidthCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                BorderWidthField.this.borderWidthComboItemStateChanged(evt);
            }
        });
        this.borderWidthCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BorderWidthField.this.borderWidthComboActionPerformed(evt);
            }
        });
        this.borderWidthCombo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                BorderWidthField.this.borderWidthComboFocusLost(evt);
            }
        });
        this.add((Component)this.borderWidthCombo, "Center");
        this.borderWidthCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BorderWidthField.class, (String)"BORDER_WIDTH_FIELD_ACCESS_NAME"));
        this.borderWidthCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BorderWidthField.class, (String)"BORDER_WIDTH_FIELD_ACCESS_DESC"));
        this.borderWidthUnitCombo.setEnabled(false);
        this.borderWidthUnitCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                BorderWidthField.this.borderWidthUnitComboItemStateChanged(evt);
            }
        });
        this.borderWidthUnitCombo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                BorderWidthField.this.borderWidthUnitComboFocusLost(evt);
            }
        });
        this.add((Component)this.borderWidthUnitCombo, "East");
        this.borderWidthUnitCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BorderWidthField.class, (String)"BORDER_WIDTH_UNIT_ACCESS_NAME"));
        this.borderWidthUnitCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BorderWidthField.class, (String)"BORDER_WIDTH_UNIT_ACCESS_DESC"));
    }

    private void borderWidthUnitComboFocusLost(FocusEvent evt) {
        this.setBorderWidth();
    }

    private void borderWidthUnitComboItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() != 2) {
            this.setBorderWidth();
        }
    }

    public void setAccessibleName(String comboName, String unitName) {
        this.borderWidthCombo.getAccessibleContext().setAccessibleName(comboName);
        this.borderWidthUnitCombo.getAccessibleContext().setAccessibleName(unitName);
    }

    public void setAccessibleDescription(String comboDesc, String unitDesc) {
        this.borderWidthCombo.getAccessibleContext().setAccessibleDescription(comboDesc);
        this.borderWidthUnitCombo.getAccessibleContext().setAccessibleDescription(unitDesc);
    }

    private void borderWidthComboItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() != 2) {
            this.setBorderWidth();
            this.borderWidthUnitCombo.setEnabled(Utils.isInteger(this.borderWidthCombo.getSelectedItem().toString()));
        }
    }

    private void borderWidthComboFocusLost(FocusEvent evt) {
        this.setBorderWidth();
    }

    private void borderWidthComboActionPerformed(ActionEvent evt) {
        this.setBorderWidth();
    }

    private void setBorderWidth() {
        String oldValue = this.borderWidthData.toString();
        this.borderWidthData.setUnit(this.borderWidthUnitCombo.getSelectedItem().toString());
        this.borderWidthData.setValue(this.borderWidthCombo.getSelectedItem().toString());
        this.firePropertyChange("border-width", oldValue, this.borderWidthData.toString());
    }
}

