/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.common.ActiveDocumentSupport;
import org.netbeans.modules.vmd.game.GameAccessController;
import org.netbeans.modules.vmd.game.model.Editable;
import org.netbeans.modules.vmd.game.model.EditorManagerListener;
import org.netbeans.modules.vmd.game.model.GlobalRepository;
import org.netbeans.spi.navigator.NavigatorPanel;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class GameBuilderNavigator
extends JPanel
implements NavigatorPanel,
EditorManagerListener {
    private static final boolean DEBUG = false;
    private GlobalRepository gameDesign;
    private ADSL listener;

    public GameBuilderNavigator() {
        this.setNavigator(null);
        this.listener = new ADSL();
    }

    public String getDisplayName() {
        return NbBundle.getMessage(GameBuilderNavigator.class, (String)"GameBuilderNavigator.DisplayName");
    }

    public String getDisplayHint() {
        return NbBundle.getMessage(GameBuilderNavigator.class, (String)"GameBuilderNavigator.DisplayHint");
    }

    public JComponent getComponent() {
        return this;
    }

    public void panelActivated(Lookup context) {
        ActiveDocumentSupport.getDefault().addActiveDocumentListener((ActiveDocumentSupport.Listener)this.listener);
        final JComponent[] navigator = new JComponent[]{null};
        final DesignDocument doc = ActiveDocumentSupport.getDefault().getActiveDocument();
        if (doc == null) {
            return;
        }
        doc.getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                GameAccessController controller = (GameAccessController)doc.getListenerManager().getAccessController(GameAccessController.class);
                if (controller == null) {
                    return;
                }
                GameBuilderNavigator.this.gameDesign = controller.getGameDesign();
                GameBuilderNavigator.this.gameDesign.getMainView().addEditorManagerListener(GameBuilderNavigator.this);
                Editable editable = GameBuilderNavigator.this.gameDesign.getMainView().getCurrentEditable();
                if (editable == null) {
                    return;
                }
                navigator[0] = editable.getNavigator();
            }
        });
        this.setNavigator(navigator[0]);
    }

    public void panelDeactivated() {
        ActiveDocumentSupport.getDefault().removeActiveDocumentListener((ActiveDocumentSupport.Listener)this.listener);
    }

    public Lookup getLookup() {
        return null;
    }

    private void setNavigator(JComponent navigator) {
        this.removeAll();
        if (navigator != null) {
            this.setLayout(new BorderLayout());
            this.add((Component)new JScrollPane(navigator), "Center");
        } else {
            this.setLayout(new GridBagLayout());
            this.add(new JLabel(NbBundle.getMessage(GameBuilderNavigator.class, (String)"GameBuilderNavigator.no_structure_lbl")));
        }
        this.validate();
        this.repaint();
    }

    @Override
    public void editing(Editable editable) {
        this.setNavigator(editable.getNavigator());
    }

    private class ADSL
    implements ActiveDocumentSupport.Listener {
        private ADSL() {
        }

        public void activeDocumentChanged(DesignDocument deactivatedDocument, final DesignDocument activatedDocument) {
            if (deactivatedDocument == activatedDocument) {
                return;
            }
            if (activatedDocument == null) {
                GameBuilderNavigator.this.setNavigator(null);
                return;
            }
            final JComponent[] navigator = new JComponent[]{null};
            activatedDocument.getTransactionManager().readAccess(new Runnable(){

                @Override
                public void run() {
                    GameAccessController controller = (GameAccessController)activatedDocument.getListenerManager().getAccessController(GameAccessController.class);
                    GameBuilderNavigator.this.gameDesign = controller.getGameDesign();
                    GameBuilderNavigator.this.gameDesign.getMainView().addEditorManagerListener(GameBuilderNavigator.this);
                    Editable editable = GameBuilderNavigator.this.gameDesign.getMainView().getCurrentEditable();
                    if (editable == null) {
                        return;
                    }
                    navigator[0] = editable.getNavigator();
                }
            });
            GameBuilderNavigator.this.setNavigator(navigator[0]);
        }

        public void activeComponentsChanged(Collection<DesignComponent> activeComponents) {
        }
    }
}

