/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.core.stack.storage.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.netbeans.modules.dlight.core.stack.api.CallStackEntry;
import org.netbeans.modules.dlight.core.stack.api.Function;
import org.netbeans.modules.dlight.core.stack.storage.impl.FunctionImpl;
import org.netbeans.modules.dlight.core.stack.storage.impl.SQLStackRequestsProvider;
import org.netbeans.modules.dlight.spi.SourceFileInfoProvider;
import org.netbeans.modules.dlight.spi.support.SQLRequest;
import org.netbeans.modules.dlight.spi.support.SQLRequestsProcessor;

class DBProxy {
    private final SQLRequestsProcessor requestsProcessor;
    private final SQLStackRequestsProvider requestsProvider;
    private final HashMap<Long, StackNode> stackNodesCache = new HashMap();
    private final HashMap<Long, CallStackEntry> callStackEntriesCache = new HashMap();
    private final HashMap<CharSequence, StackNode> stackEntryToStackNode = new HashMap();
    private final HashMap<CharSequence, Long> funcNameToFuncID = new HashMap();
    private final HashMap<CharSequence, Long> fileNameToFileID = new HashMap();
    private final HashMap<CharSequence, Long> moduleNameToModuleID = new HashMap();
    private final AtomicLong lastNodeID = new AtomicLong();
    private final AtomicLong lastFuncID = new AtomicLong();
    private final AtomicLong lastFileID = new AtomicLong();
    private final AtomicLong lastModuleID = new AtomicLong();

    DBProxy(SQLRequestsProcessor requestsProcessor, SQLStackRequestsProvider requestsProvider) {
        this.requestsProcessor = requestsProcessor;
        this.requestsProvider = requestsProvider;
    }

    void shutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StackNode getNodeID(CallStackEntry entry, long callerID, AtomicBoolean isNewNode) {
        StackNode node;
        boolean isnew = false;
        HashMap<CharSequence, StackNode> hashMap = this.stackEntryToStackNode;
        synchronized (hashMap) {
            node = this.stackEntryToStackNode.get(((Object)entry.getOriginalEntry()).toString() + callerID);
            if (node == null) {
                isnew = true;
                node = this.insertNode(entry, callerID);
            }
        }
        if (isNewNode != null) {
            isNewNode.set(isnew);
        }
        return node;
    }

    void updateNodeMetrics(long leafNodeID, long contextID, long timestamp, long duration) {
        long bucket = DBProxy.timeToBucket(timestamp);
        SQLRequest request = this.requestsProvider.updateNodeMetrics(leafNodeID, contextID, bucket, duration);
        this.requestsProcessor.queueRequest(request);
    }

    void updateFuncMetrics(long funcID, long contextID, long timestamp, long duration, boolean addInclusive, boolean addExclusive) {
        long bucket = DBProxy.timeToBucket(timestamp);
        SQLRequest request = this.requestsProvider.updateFunctionMetrics(funcID, contextID, bucket, duration, addInclusive, addExclusive);
        this.requestsProcessor.queueRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StackNode insertNode(CallStackEntry entry, long callerID) {
        Long funcID;
        HashMap<CharSequence, Long> hashMap = this.funcNameToFuncID;
        synchronized (hashMap) {
            funcID = this.funcNameToFuncID.get(entry.getFunctionName());
            if (funcID == null) {
                funcID = this.lastFuncID.incrementAndGet();
                this.funcNameToFuncID.put(entry.getFunctionName(), funcID);
                SQLRequest request = this.requestsProvider.addFunction(funcID, entry.getFunctionName());
                this.requestsProcessor.queueRequest(request);
            }
        }
        long offset = entry.getOffsetInFunction();
        Long nodeID = this.lastNodeID.incrementAndGet();
        StackNode node = new StackNode(nodeID, callerID, funcID, offset);
        this.stackNodesCache.put(node.nodeID, node);
        this.callStackEntriesCache.put(nodeID, entry);
        this.stackEntryToStackNode.put(((Object)entry.getOriginalEntry()).toString() + callerID, node);
        SQLRequest request = this.requestsProvider.addNode(nodeID, callerID, funcID, offset);
        this.requestsProcessor.queueRequest(request);
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSourceInfo(StackNode node, long contextID, SourceFileInfoProvider.SourceFileInfo sourceFileInfo) {
        Long fileID;
        if (sourceFileInfo == null) {
            return;
        }
        String path = sourceFileInfo.getFileName();
        int line = sourceFileInfo.getLine();
        int column = sourceFileInfo.getColumn();
        long offset = sourceFileInfo.getOffset();
        HashMap<CharSequence, Long> hashMap = this.fileNameToFileID;
        synchronized (hashMap) {
            fileID = this.fileNameToFileID.get(path);
            if (fileID == null) {
                fileID = this.lastFileID.incrementAndGet();
                this.fileNameToFileID.put(path, fileID);
                SQLRequest request = this.requestsProvider.addFile(fileID, path);
                this.requestsProcessor.queueRequest(request);
            }
        }
        SQLRequest request = this.requestsProvider.addSourceInfo(node.nodeID, contextID, fileID, line, column, offset);
        this.requestsProcessor.queueRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addModuleInfo(StackNode node, long contextID, CharSequence module, long offsetInModule) {
        Long moduleID;
        if (module == null) {
            return;
        }
        HashMap<CharSequence, Long> hashMap = this.moduleNameToModuleID;
        synchronized (hashMap) {
            moduleID = this.moduleNameToModuleID.get(module);
            if (moduleID == null) {
                moduleID = this.lastModuleID.incrementAndGet();
                this.moduleNameToModuleID.put(module, moduleID);
                SQLRequest request = this.requestsProvider.addModule(moduleID, module);
                this.requestsProcessor.queueRequest(request);
            }
        }
        SQLRequest request = this.requestsProvider.addModuleInfo(node.nodeID, contextID, moduleID, offsetInModule);
        this.requestsProcessor.queueRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFunctionNameByFuncID(long funcId) {
        HashMap<CharSequence, Long> hashMap = this.funcNameToFuncID;
        synchronized (hashMap) {
            Iterator<CharSequence> it = this.funcNameToFuncID.keySet().iterator();
            while (it.hasNext()) {
                String name = ((Object)it.next()).toString();
                if (this.funcNameToFuncID.get(name) != funcId) continue;
                return name;
            }
        }
        return null;
    }

    Function getLeafFunction(long stackId) {
        String moduleOffset;
        StackNode stackNode = this.stackNodesCache.get(stackId);
        long nodeID = stackNode.nodeID;
        long funcID = stackNode.funcID;
        long offset = stackNode.offset;
        String funcName = this.getFunctionNameByFuncID(funcID);
        CallStackEntry entry = this.callStackEntriesCache.get(stackId);
        StringBuilder qname = new StringBuilder();
        String module = ((Object)entry.getModulePath()).toString();
        long offsetInModule = entry.getOffsetInModule();
        SourceFileInfoProvider.SourceFileInfo sourceFileInfo = entry.getSourceFileInfo();
        if (sourceFileInfo == null) {
            sourceFileInfo = new SourceFileInfoProvider.SourceFileInfo(null, -1L);
        }
        String srcFile = sourceFileInfo.getFileName();
        long srcLine = sourceFileInfo.getLine();
        long srcColumn = sourceFileInfo.getColumn();
        String string = moduleOffset = offsetInModule < 0L ? null : "0x" + Long.toHexString(offsetInModule);
        if (module != null) {
            qname.append(module);
            if (moduleOffset != null) {
                qname.append('+').append(moduleOffset);
            }
            qname.append('`');
        }
        qname.append(funcName);
        if (offset > 0L) {
            qname.append("+0x").append(Long.toHexString(offset));
        }
        if (srcFile != null) {
            qname.append(':').append(srcFile);
            if (srcLine > 0L) {
                qname.append(':').append(srcLine);
                if (srcColumn > 0L) {
                    qname.append(':').append(srcColumn);
                }
            }
        }
        FunctionImpl func = new FunctionImpl(funcID, -1L, funcName, qname.toString(), module, moduleOffset, srcFile);
        return func;
    }

    static long timeToBucket(long timestamp) {
        return TimeUnit.NANOSECONDS.toSeconds(timestamp);
    }

    static class StackNode {
        final long nodeID;
        final long callerID;
        final long funcID;
        final long offset;

        public StackNode(long nodeID, long callerID, long funcID, long offset) {
            this.nodeID = nodeID;
            this.callerID = callerID;
            this.funcID = funcID;
            this.offset = offset;
        }
    }
}

