/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.core.stack.api.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.dlight.core.stack.api.CallStackEntry;
import org.netbeans.modules.dlight.core.stack.api.CallStackEntryParser;
import org.netbeans.modules.dlight.spi.SourceFileInfoProvider;

public class DefaultStackParserImpl
implements CallStackEntryParser {
    @Override
    public CallStackEntry parseEntry(final CharSequence entry) {
        SourceFileInfoProvider.SourceFileInfo srcFileInfo;
        int pos1 = DefaultStackParserImpl.searchRight(entry, '`', 0);
        final EntryWithOffset modulePart = pos1 < 0 ? null : EntryWithOffset.parse(entry.subSequence(0, pos1));
        int pos2 = DefaultStackParserImpl.searchRight(entry, ':', pos1 + 1);
        if (pos2 < 0) {
            srcFileInfo = null;
            pos2 = entry.length();
        } else {
            srcFileInfo = this.parseSourceFileInfo(entry.subSequence(pos2 + 1, entry.length()));
        }
        final EntryWithOffset functionPart = EntryWithOffset.parse(entry.subSequence(pos1 + 1, pos2));
        return new CallStackEntry(){

            @Override
            public CharSequence getModulePath() {
                return modulePart == null ? null : modulePart.entry;
            }

            @Override
            public long getOffsetInModule() {
                return modulePart == null ? -1L : modulePart.offset;
            }

            @Override
            public CharSequence getFunctionName() {
                return functionPart == null ? null : functionPart.entry;
            }

            @Override
            public long getOffsetInFunction() {
                return functionPart == null ? null : Long.valueOf(functionPart.offset);
            }

            @Override
            public SourceFileInfoProvider.SourceFileInfo getSourceFileInfo() {
                return srcFileInfo;
            }

            @Override
            public CharSequence getOriginalEntry() {
                return entry;
            }
        };
    }

    private static int searchRight(CharSequence entry, char c, int fromIndex) {
        for (int i = fromIndex; i < entry.length(); ++i) {
            if (entry.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    private SourceFileInfoProvider.SourceFileInfo parseSourceFileInfo(CharSequence entry) {
        int line = -1;
        int column = -1;
        int pos1 = DefaultStackParserImpl.searchRight(entry, ':', 0);
        if (pos1 < 0) {
            return new SourceFileInfoProvider.SourceFileInfo(entry, -1, -1);
        }
        int pos2 = DefaultStackParserImpl.searchRight(entry, ':', pos1 + 1);
        try {
            if (pos2 < 0) {
                line = Integer.parseInt(((Object)entry.subSequence(pos1 + 1, entry.length())).toString());
                column = -1;
            } else {
                line = Integer.parseInt(((Object)entry.subSequence(pos1 + 1, pos2)).toString());
                column = Integer.parseInt(((Object)entry.subSequence(pos2 + 1, entry.length())).toString());
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return new SourceFileInfoProvider.SourceFileInfo(entry.subSequence(0, pos1), line, column);
    }

    private static class EntryWithOffset {
        private static final Pattern pattern = Pattern.compile("^(.*)\\+([0-9]+)$");
        private static final Pattern hexPattern = Pattern.compile("^(.*)\\+0x([0-9a-fA-F]+)$");
        private final CharSequence entry;
        private final long offset;

        public EntryWithOffset(CharSequence entry, long offset) {
            this.entry = entry;
            this.offset = offset;
        }

        public String toString() {
            return this.entry + "+0x" + Long.toHexString(this.offset);
        }

        private static EntryWithOffset parse(CharSequence part) {
            long offset = -1L;
            CharSequence entry = part;
            try {
                Matcher m = pattern.matcher(part);
                if (m.matches()) {
                    entry = m.group(1);
                    offset = Long.parseLong(m.group(2));
                } else {
                    m = hexPattern.matcher(part);
                    if (m.matches()) {
                        entry = m.group(1);
                        offset = Long.parseLong(m.group(2), 16);
                    }
                }
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            return new EntryWithOffset(entry, offset);
        }
    }
}

