/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.model.services;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmExpressionBasedSpecializationParameter;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInstantiation;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmSpecializationParameter;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmTypeBasedSpecializationParameter;
import org.openide.util.Lookup;

public abstract class CsmInstantiationProvider {
    private static final CsmInstantiationProvider EMPTY = new Empty();
    private static CsmInstantiationProvider defaultProvider;

    protected CsmInstantiationProvider() {
    }

    public static CsmInstantiationProvider getDefault() {
        if (defaultProvider != null) {
            return defaultProvider;
        }
        defaultProvider = (CsmInstantiationProvider)Lookup.getDefault().lookup(CsmInstantiationProvider.class);
        return defaultProvider == null ? EMPTY : defaultProvider;
    }

    public abstract CsmObject instantiate(CsmTemplate var1, List<CsmSpecializationParameter> var2);

    public abstract CsmObject instantiate(CsmTemplate var1, CsmInstantiation var2);

    public abstract CsmObject instantiate(CsmTemplate var1, CsmType var2);

    public abstract CsmTypeBasedSpecializationParameter createTypeBasedSpecializationParameter(CsmType var1);

    public abstract CsmExpressionBasedSpecializationParameter createExpressionBasedSpecializationParameter(String var1, CsmFile var2, int var3, int var4);

    public abstract CharSequence getInstantiatedText(CsmType var1);

    public abstract CharSequence getTemplateSignature(CsmTemplate var1);

    public abstract Collection<CsmOffsetableDeclaration> getSpecializations(CsmDeclaration var1, CsmFile var2, int var3);

    public Collection<CsmOffsetableDeclaration> getSpecializations(CsmDeclaration templateDecl) {
        return this.getSpecializations(templateDecl, null, -1);
    }

    public abstract Collection<CsmOffsetableDeclaration> getBaseTemplate(CsmDeclaration var1);

    private static final class Empty
    extends CsmInstantiationProvider {
        Empty() {
        }

        @Override
        public CsmObject instantiate(CsmTemplate template, List<CsmSpecializationParameter> params) {
            return template;
        }

        @Override
        public CsmObject instantiate(CsmTemplate template, CsmInstantiation instantiation) {
            return template;
        }

        @Override
        public CsmObject instantiate(CsmTemplate template, CsmType type) {
            return template;
        }

        @Override
        public CsmTypeBasedSpecializationParameter createTypeBasedSpecializationParameter(CsmType type) {
            return null;
        }

        @Override
        public CsmExpressionBasedSpecializationParameter createExpressionBasedSpecializationParameter(String expression, CsmFile file, int start, int end) {
            return null;
        }

        @Override
        public CharSequence getInstantiatedText(CsmType type) {
            return type.getText();
        }

        @Override
        public CharSequence getTemplateSignature(CsmTemplate template) {
            return "";
        }

        @Override
        public Collection<CsmOffsetableDeclaration> getSpecializations(CsmDeclaration templateDecl, CsmFile contextFile, int contextOffset) {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmOffsetableDeclaration> getBaseTemplate(CsmDeclaration declaration) {
            return Collections.emptyList();
        }
    }
}

