/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.support;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Properties;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.websvc.api.support.LogUtils;
import org.netbeans.modules.websvc.rest.nodes.TestRestServicesAction;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.netbeans.modules.websvc.rest.support.JavaSourceHelper;
import org.netbeans.modules.websvc.rest.support.TestRestTargetPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.cookies.LineCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.text.Line;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class Utils {
    public static String stripPackageName(String string) {
        int n = string.indexOf("<");
        int n2 = 0;
        if (n > 0) {
            String string2 = string.substring(0, n);
            n2 = string2.lastIndexOf(".");
        } else {
            n2 = string.lastIndexOf(".");
        }
        if (n2 > 0) {
            return string.substring(n2 + 1);
        }
        return string;
    }

    public static Collection<String> sortKeys(Collection<String> collection) {
        TreeSet<String> treeSet = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                return string.compareTo(string2);
            }
        });
        treeSet.addAll(collection);
        return treeSet;
    }

    public static void showMethod(FileObject fileObject, String string) {
        try {
            LineCookie lineCookie;
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
            SaveCookie saveCookie = (SaveCookie)dataObject.getCookie(SaveCookie.class);
            if (saveCookie != null) {
                saveCookie.save();
            }
            if ((lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class)) != null) {
                final long[] lArray = JavaSourceHelper.getPosition(javaSource, string);
                final Line line = lineCookie.getLineSet().getOriginal((int)lArray[0]);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        line.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.NONE, (int)lArray[1]);
                    }
                });
            }
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
    }

    public static Method getValueOfMethod(Class clazz) {
        try {
            Method method = clazz.getDeclaredMethod("valueOf", String.class);
            if (method == null || !Modifier.isStatic(method.getModifiers())) {
                return null;
            }
            return method;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Constructor getConstructorWithStringParam(Class clazz) {
        try {
            return clazz.getConstructor(String.class);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Project[] getProjectsFromLookup(Lookup lookup) {
        HashSet<Project> hashSet = new HashSet<Project>();
        for (Project project : lookup.lookupAll(Project.class)) {
            hashSet.add(project);
        }
        for (Project project : lookup.lookupAll(DataObject.class)) {
            FileObject fileObject = project.getPrimaryFile();
            Project project2 = FileOwnerQuery.getOwner((FileObject)fileObject);
            if (project2 == null) continue;
            hashSet.add(project2);
        }
        Project[] projectArray = hashSet.toArray(new Project[hashSet.size()]);
        return projectArray;
    }

    public static FileObject findBuildXml(Project project) {
        return project.getProjectDirectory().getFileObject("build.xml");
    }

    public static void testRestWebService(Project project) {
        if (project == null) {
            return;
        }
        TestRestTargetPanel testRestTargetPanel = new TestRestTargetPanel(project);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)testRestTargetPanel, NbBundle.getMessage(Utils.class, (String)"TTL_SelectTarget"));
        testRestTargetPanel.setDescriptor(dialogDescriptor);
        if (!DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor).equals(NotifyDescriptor.OK_OPTION)) {
            return;
        }
        if (testRestTargetPanel.isRemote()) {
            Utils.generateRemoteTester(project, testRestTargetPanel.getProject());
        } else {
            Utils.generateLocalTester(project);
        }
    }

    private static void generateRemoteTester(Project project, Project project2) {
        RestSupport restSupport = (RestSupport)project2.getLookup().lookup(RestSupport.class);
        RestSupport restSupport2 = (RestSupport)project.getLookup().lookup(RestSupport.class);
        SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project2).getSourceGroups("doc_root");
        SourceGroup sourceGroup = sourceGroupArray[0];
        FileObject fileObject = sourceGroup.getRootFolder();
        try {
            FileObject fileObject2 = restSupport.generateTestClient(FileUtil.toFile((FileObject)fileObject), restSupport2.getBaseURL());
            restSupport2.deploy();
            restSupport.deploy();
            URL uRL = new URL(restSupport.getContextRootURL() + fileObject2.getNameExt());
            if (uRL != null) {
                HtmlBrowser.URLDisplayer.getDefault().showURL(uRL);
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(TestRestServicesAction.class.getName()).log(Level.WARNING, null, iOException);
        }
    }

    private static void generateLocalTester(Project project) {
        RestSupport restSupport;
        FileObject fileObject = Utils.findBuildXml(project);
        if (fileObject != null) {
            try {
                restSupport = Utils.setupTestRestBeans(project);
                ActionUtils.runTarget((FileObject)fileObject, (String[])new String[]{"test-restbeans"}, (Properties)restSupport);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        } else {
            restSupport = (RestSupport)project.getLookup().lookup(RestSupport.class);
            if (restSupport != null) {
                try {
                    URL uRL;
                    FileObject fileObject2 = restSupport.generateTestClient(restSupport.getLocalTargetTestRest(), restSupport.getBaseURL());
                    restSupport.deploy();
                    if (fileObject2 != null && (uRL = fileObject2.getURL()) != null) {
                        HtmlBrowser.URLDisplayer.getDefault().showURL(uRL);
                    }
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }
        restSupport = new Object[]{"JAX-RS", "TEST REST"};
        LogUtils.logWsAction((Object[])restSupport);
    }

    private static Properties setupTestRestBeans(Project project) throws IOException {
        Properties properties = new Properties();
        properties.setProperty("base.url.token", "___BASE_URL___");
        RestSupport restSupport = (RestSupport)project.getLookup().lookup(RestSupport.class);
        if (restSupport != null) {
            try {
                String string = restSupport.getApplicationPath();
                if (string != null) {
                    if (!string.startsWith("/")) {
                        string = "/" + string;
                    }
                    properties.setProperty("rest.application.path", string);
                }
                File file = restSupport.getLocalTargetTestRest();
                FileObject fileObject = restSupport.generateTestClient(file);
                properties.setProperty("restbeans.test.url", fileObject.getURL().toString());
                properties.setProperty("restbeans.test.file", FileUtil.toFile((FileObject)fileObject).getAbsolutePath());
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return properties;
    }
}

