/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.java.spi.RefactoringVisitor;
import org.netbeans.modules.refactoring.java.spi.ToPhaseException;
import org.openide.util.Exceptions;

class VarUsageVisitor
extends RefactoringVisitor {
    private final TypeElement superTypeElement;
    private final TypeElement subTypeElement;
    private boolean isReplCandidate = true;

    VarUsageVisitor(TypeElement subTypeElement, WorkingCopy workingCopy, TypeElement superTypeElem) {
        try {
            this.setWorkingCopy(workingCopy);
        }
        catch (ToPhaseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.superTypeElement = superTypeElem;
        this.subTypeElement = subTypeElement;
    }

    @Override
    public Tree visitMemberSelect(MemberSelectTree memSelectTree, Element refVarElem) {
        Element methodElement = this.asElement(memSelectTree);
        Element varElement = this.asElement(memSelectTree.getExpression());
        if (!((Object)refVarElem).equals(varElement)) {
            return (Tree)super.visitMemberSelect(memSelectTree, refVarElem);
        }
        boolean isAssgCmptble = this.isMemberAvailable(this.subTypeElement, methodElement, this.superTypeElement);
        if (!isAssgCmptble) {
            this.isReplCandidate = false;
        }
        return (Tree)super.visitMemberSelect(memSelectTree, refVarElem);
    }

    @Override
    public Tree visitAssignment(AssignmentTree assgnTree, Element refVarElem) {
        ExpressionTree exprnTree = assgnTree.getExpression();
        Element exprElement = this.asElement(exprnTree);
        if (!((Object)refVarElem).equals(exprElement)) {
            return (Tree)super.visitAssignment(assgnTree, refVarElem);
        }
        ExpressionTree varExprTree = assgnTree.getVariable();
        VariableElement varElement = (VariableElement)this.asElement(varExprTree);
        this.isReplCandidate = this.isReplacableAssgnmt(varElement) && this.isReplCandidate;
        return (Tree)super.visitAssignment(assgnTree, refVarElem);
    }

    @Override
    public Tree visitVariable(VariableTree varTree, Element refVarElem) {
        ExpressionTree initTree = varTree.getInitializer();
        if (null == initTree) {
            return (Tree)super.visitVariable(varTree, refVarElem);
        }
        Element exprElement = this.asElement(initTree);
        if (!((Object)refVarElem).equals(exprElement)) {
            return (Tree)super.visitVariable(varTree, refVarElem);
        }
        VariableElement varElement = (VariableElement)this.asElement(varTree);
        this.isReplCandidate = this.isReplacableAssgnmt(varElement) && this.isReplCandidate;
        return (Tree)super.visitVariable(varTree, refVarElem);
    }

    private boolean isMemberAvailable(TypeElement subTypeElement, Element methodElement, TypeElement superTypeElement) {
        ElementKind memberKind = methodElement.getKind();
        if (ElementKind.METHOD.equals((Object)memberKind)) {
            return this.isMethodAvailable(subTypeElement, (ExecutableElement)methodElement, superTypeElement);
        }
        return this.isHidingMember(subTypeElement, methodElement, superTypeElement);
    }

    private boolean isMethodAvailable(TypeElement subTypeElement, ExecutableElement execElem, TypeElement superTypeElement) {
        Elements elements = this.workingCopy.getElements();
        List<? extends Element> memberElements = elements.getAllMembers(superTypeElement);
        for (Element element : memberElements) {
            if (!ElementKind.METHOD.equals((Object)element.getKind())) continue;
            if (this.isStatic(execElem) && elements.hides(execElem, element)) {
                return true;
            }
            if (!execElem.equals(element) && !elements.overrides(execElem, (ExecutableElement)element, subTypeElement)) continue;
            return true;
        }
        return false;
    }

    private boolean isHidingMember(TypeElement subTypeElement, Element variableElement, TypeElement superTypeElement) {
        Elements elements = this.workingCopy.getElements();
        List<? extends Element> memberElements = elements.getAllMembers(superTypeElement);
        for (Element element : memberElements) {
            if (!((Object)variableElement).equals(element) && !elements.hides(variableElement, element)) continue;
            return true;
        }
        return false;
    }

    private boolean isReplacableAssgnmt(VariableElement varElement) {
        DeclaredType declType;
        TypeElement varType;
        return this.isDeclaredType(varElement.asType()) && this.isAssignable(this.superTypeElement, varType = (TypeElement)(declType = (DeclaredType)varElement.asType()).asElement());
    }

    boolean isReplaceCandidate() {
        return this.isReplCandidate;
    }

    private boolean isAssignable(TypeElement typeFrom, TypeElement typeTo) {
        Types types = this.workingCopy.getTypes();
        return types.isAssignable(typeFrom.asType(), typeTo.asType());
    }

    private Element asElement(Tree tree) {
        Trees treeUtil = this.workingCopy.getTrees();
        TreePath treePath = treeUtil.getPath(this.workingCopy.getCompilationUnit(), tree);
        Element element = treeUtil.getElement(treePath);
        return element;
    }

    private boolean isDeclaredType(TypeMirror type) {
        return TypeKind.DECLARED.equals((Object)type.getKind());
    }

    private boolean isStatic(Element element) {
        Set<Modifier> modifiers = element.getModifiers();
        return modifiers.contains((Object)Modifier.STATIC);
    }
}

