/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.api.ExtractSuperclassRefactoring;
import org.netbeans.modules.refactoring.java.api.MemberInfo;
import org.netbeans.modules.refactoring.java.plugins.ExtractInterfaceRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.JavaPluginUtils;
import org.netbeans.modules.refactoring.java.plugins.RetoucheCommit;
import org.netbeans.modules.refactoring.java.spi.DiffElement;
import org.netbeans.modules.refactoring.java.spi.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.PositionBounds;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;

public final class ExtractSuperclassRefactoringPlugin
extends JavaRefactoringPlugin {
    private final ExtractSuperclassRefactoring refactoring;
    private ElementHandle<TypeElement> classHandle;
    private String pkgName;

    ExtractSuperclassRefactoringPlugin(ExtractSuperclassRefactoring refactoring) {
        this.refactoring = refactoring;
    }

    @Override
    protected JavaSource getJavaSource(JavaRefactoringPlugin.Phase p) {
        return JavaSource.forFileObject((FileObject)this.refactoring.getSourceType().getFileObject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Problem preCheck(CompilationController javac) throws IOException {
        this.fireProgressListenerStart(1, 2);
        javac.toPhase(JavaSource.Phase.RESOLVED);
        try {
            TreePathHandle sourceType = this.refactoring.getSourceType();
            Problem result = ExtractSuperclassRefactoringPlugin.isElementAvail(sourceType, (CompilationInfo)javac);
            if (result != null) {
                Problem problem = result;
                return problem;
            }
            Element sourceElm = sourceType.resolveElement((CompilationInfo)javac);
            result = JavaPluginUtils.isSourceElement(sourceElm, (CompilationInfo)javac);
            if (result != null) {
                Problem problem = result;
                return problem;
            }
            if (sourceElm == null) {
                Problem problem = new Problem(true, NbBundle.getMessage(ExtractSuperclassRefactoringPlugin.class, (String)"ERR_ElementNotAvailable"));
                return problem;
            }
            if (sourceElm.getKind() != ElementKind.CLASS) {
                Problem problem = new Problem(true, NbBundle.getMessage(ExtractSuperclassRefactoringPlugin.class, (String)"ERR_ExtractSC_MustBeClass"));
                return problem;
            }
            this.classHandle = ElementHandle.create((Element)((TypeElement)sourceElm));
            PackageElement pkgElm = (PackageElement)javac.getElementUtilities().outermostTypeElement(sourceElm).getEnclosingElement();
            this.pkgName = pkgElm.getQualifiedName().toString();
            this.fireProgressListenerStep();
            Problem problem = null;
            return problem;
        }
        finally {
            this.fireProgressListenerStop();
        }
    }

    @Override
    public Problem fastCheckParameters() {
        FileObject[] children;
        Problem result = null;
        String newName = this.refactoring.getSuperClassName();
        if (!Utilities.isJavaIdentifier((String)newName)) {
            result = ExtractSuperclassRefactoringPlugin.createProblem(result, true, NbBundle.getMessage(ExtractSuperclassRefactoringPlugin.class, (String)"ERR_InvalidIdentifier", (Object)newName));
            return result;
        }
        FileObject primFile = this.refactoring.getSourceType().getFileObject();
        FileObject folder = primFile.getParent();
        for (FileObject child : children = folder.getChildren()) {
            if (child.isVirtual() || !child.getName().equals(newName) || !"java".equals(child.getExt())) continue;
            result = ExtractSuperclassRefactoringPlugin.createProblem(result, true, NbBundle.getMessage(ExtractSuperclassRefactoringPlugin.class, (String)"ERR_ClassClash", (Object)newName, (Object)this.pkgName));
            return result;
        }
        return null;
    }

    @Override
    public Problem checkParameters() {
        MemberInfo<ElementHandle<? extends Element>>[] members = this.refactoring.getMembers();
        if (members.length == 0) {
            return new Problem(true, NbBundle.getMessage(ExtractSuperclassRefactoringPlugin.class, (String)"ERR_ExtractSuperClass_MembersNotAvailable"));
        }
        return super.checkParameters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Problem checkParameters(CompilationController javac) throws IOException {
        javac.toPhase(JavaSource.Phase.RESOLVED);
        TypeElement sourceType = (TypeElement)this.refactoring.getSourceType().resolveElement((CompilationInfo)javac);
        assert (sourceType != null);
        HashSet<? extends Element> members = new HashSet<Element>(sourceType.getEnclosedElements());
        this.fireProgressListenerStart(2, this.refactoring.getMembers().length);
        try {
            for (MemberInfo<ElementHandle<? extends Element>> info : this.refactoring.getMembers()) {
                Problem p = null;
                switch (info.getGroup()) {
                    case FIELD: {
                        ElementHandle<? extends Element> vehandle = info.getElementHandle();
                        VariableElement field = (VariableElement)vehandle.resolve((CompilationInfo)javac);
                        p = this.checkFieldParameter(javac, field, members);
                        break;
                    }
                    case METHOD: {
                        ElementHandle<? extends Element> eehandle = info.getElementHandle();
                        ExecutableElement method = (ExecutableElement)eehandle.resolve((CompilationInfo)javac);
                        p = this.checkMethodParameter(javac, method, members);
                    }
                }
                if (p != null) {
                    Problem problem = p;
                    return problem;
                }
                this.fireProgressListenerStep();
            }
        }
        finally {
            this.fireProgressListenerStop();
        }
        return null;
    }

    private Problem checkFieldParameter(CompilationController javac, VariableElement elm, Set<? extends Element> members) throws IOException {
        if (elm == null) {
            return new Problem(true, NbBundle.getMessage(ExtractSuperclassRefactoringPlugin.class, (String)"ERR_ElementNotAvailable"));
        }
        if (javac.getElementUtilities().isSynthetic((Element)elm) || elm.getKind() != ElementKind.FIELD) {
            return new Problem(true, NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"ERR_ExtractSuperClass_UnknownMember", (Object)elm.toString()));
        }
        if (!members.contains(elm)) {
            return new Problem(true, NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"ERR_ExtractSuperClass_UnknownMember", (Object)elm.toString()));
        }
        return null;
    }

    private Problem checkMethodParameter(CompilationController javac, ExecutableElement elm, Set<? extends Element> members) throws IOException {
        if (elm == null) {
            return new Problem(true, NbBundle.getMessage(ExtractSuperclassRefactoringPlugin.class, (String)"ERR_ElementNotAvailable"));
        }
        if (javac.getElementUtilities().isSynthetic((Element)elm) || elm.getKind() != ElementKind.METHOD) {
            return new Problem(true, NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"ERR_ExtractSuperClass_UnknownMember", (Object)elm.toString()));
        }
        if (!members.contains(elm)) {
            return new Problem(true, NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"ERR_ExtractSuperClass_UnknownMember", (Object)elm.toString()));
        }
        return null;
    }

    public Problem prepare(RefactoringElementsBag bag) {
        FileObject primFile = this.refactoring.getSourceType().getFileObject();
        try {
            bag.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)new CreateSuperclassElement(this.refactoring, primFile.getParent(), this.classHandle));
            UpdateClassTask.create(bag, primFile, this.refactoring, this.classHandle);
        }
        catch (IOException ex) {
            throw (RuntimeException)new RuntimeException().initCause(ex);
        }
        return null;
    }

    private static List<TypeMirror> findUsedGenericTypes(CompilationInfo javac, TypeElement javaClass, ExtractSuperclassRefactoring refactoring) {
        List<TypeMirror> typeArgs = RetoucheUtils.resolveTypeParamsAsTypes(javaClass.getTypeParameters());
        if (typeArgs.isEmpty()) {
            return typeArgs;
        }
        Types typeUtils = javac.getTypes();
        Set<TypeMirror> used = Collections.newSetFromMap(new IdentityHashMap());
        TypeMirror superClass = javaClass.getSuperclass();
        RetoucheUtils.findUsedGenericTypes(typeUtils, typeArgs, used, superClass);
        MemberInfo<ElementHandle<? extends Element>>[] members = refactoring.getMembers();
        for (int i = 0; i < members.length && !typeArgs.isEmpty(); ++i) {
            Element elm;
            ElementHandle<? extends Element> handle;
            if (members[i].getGroup() == MemberInfo.Group.METHOD) {
                handle = members[i].getElementHandle();
                elm = (ExecutableElement)handle.resolve(javac);
                RetoucheUtils.findUsedGenericTypes(typeUtils, typeArgs, used, elm.getReturnType());
                Iterator<? extends VariableElement> paramIter = elm.getParameters().iterator();
                while (paramIter.hasNext() && !typeArgs.isEmpty()) {
                    VariableElement param = paramIter.next();
                    RetoucheUtils.findUsedGenericTypes(typeUtils, typeArgs, used, param.asType());
                }
                continue;
            }
            if (members[i].getGroup() == MemberInfo.Group.FIELD) {
                if (members[i].getModifiers().contains((Object)Modifier.STATIC)) continue;
                handle = members[i].getElementHandle();
                elm = (VariableElement)handle.resolve(javac);
                TypeMirror asType = elm.asType();
                RetoucheUtils.findUsedGenericTypes(typeUtils, typeArgs, used, asType);
                continue;
            }
            if (members[i].getGroup() != MemberInfo.Group.IMPLEMENTS) continue;
            handle = members[i].getElementHandle();
            TypeMirror implemetz = handle.resolve(javac);
            RetoucheUtils.findUsedGenericTypes(typeUtils, typeArgs, used, implemetz);
        }
        return RetoucheUtils.filterTypes(typeArgs, used);
    }

    private static final class UpdateClassTask
    implements CancellableTask<WorkingCopy> {
        private final ExtractSuperclassRefactoring refactoring;
        private final ElementHandle<TypeElement> sourceType;

        private UpdateClassTask(ExtractSuperclassRefactoring refactoring, ElementHandle<TypeElement> sourceType) {
            this.sourceType = sourceType;
            this.refactoring = refactoring;
        }

        public static void create(RefactoringElementsBag bag, FileObject fo, ExtractSuperclassRefactoring refactoring, ElementHandle<TypeElement> sourceType) throws IOException {
            JavaSource js = JavaSource.forFileObject((FileObject)fo);
            ModificationResult modification = js.runModificationTask((Task)new UpdateClassTask(refactoring, sourceType));
            List diffs = modification.getDifferences(fo);
            for (ModificationResult.Difference diff : diffs) {
                bag.add((AbstractRefactoring)refactoring, (RefactoringElementImplementation)DiffElement.create(diff, fo, modification));
            }
            bag.registerTransaction((Transaction)new RetoucheCommit(Collections.singletonList(modification)));
        }

        public void cancel() {
        }

        public void run(WorkingCopy wc) throws Exception {
            Tree superClassTree;
            wc.toPhase(JavaSource.Phase.RESOLVED);
            TypeElement clazz = (TypeElement)this.sourceType.resolve((CompilationInfo)wc);
            assert (clazz != null);
            ClassTree classTree = wc.getTrees().getTree(clazz);
            TreeMaker make = wc.getTreeMaker();
            List typeParams = ExtractSuperclassRefactoringPlugin.findUsedGenericTypes((CompilationInfo)wc, clazz, this.refactoring);
            if (typeParams.isEmpty()) {
                superClassTree = make.Identifier((CharSequence)this.refactoring.getSuperClassName());
            } else {
                ArrayList<ExpressionTree> typeParamTrees = new ArrayList<ExpressionTree>(typeParams.size());
                for (TypeMirror typeParam : typeParams) {
                    Tree t = make.Type(typeParam);
                    typeParamTrees.add((ExpressionTree)t);
                }
                superClassTree = make.ParameterizedType((Tree)make.Identifier((CharSequence)this.refactoring.getSuperClassName()), typeParamTrees);
            }
            HashSet<Tree> members2Remove = new HashSet<Tree>();
            HashSet<Tree> interfaces2Remove = new HashSet<Tree>();
            members2Remove.addAll(this.getMembers2Remove((CompilationInfo)wc, this.refactoring.getMembers()));
            interfaces2Remove.addAll(this.getImplements2Remove((CompilationInfo)wc, this.refactoring.getMembers(), clazz));
            ArrayList<Tree> members2Add = new ArrayList<Tree>();
            for (Tree tree : classTree.getMembers()) {
                if (members2Remove.contains(tree)) continue;
                members2Add.add(tree);
            }
            List<Tree> impls2Add = UpdateClassTask.resolveImplements(classTree.getImplementsClause(), interfaces2Remove);
            ClassTree classTree2 = make.Class(classTree.getModifiers(), (CharSequence)classTree.getSimpleName(), classTree.getTypeParameters(), superClassTree, impls2Add, members2Add);
            wc.rewrite((Tree)classTree, (Tree)classTree2);
        }

        private List<Tree> getMembers2Remove(CompilationInfo javac, MemberInfo[] members) {
            if (members == null || members.length == 0) {
                return Collections.emptyList();
            }
            ArrayList<Tree> result = new ArrayList<Tree>(members.length);
            for (MemberInfo member : members) {
                Tree t;
                Element elm;
                ElementHandle handle;
                if (member.getGroup() == MemberInfo.Group.FIELD) {
                    handle = (ElementHandle)member.getElementHandle();
                    elm = (VariableElement)handle.resolve(javac);
                    assert (elm != null);
                    t = javac.getTrees().getTree(elm);
                    assert (t != null);
                    result.add(t);
                    continue;
                }
                if (member.getGroup() != MemberInfo.Group.METHOD || member.isMakeAbstract()) continue;
                handle = (ElementHandle)member.getElementHandle();
                elm = (ExecutableElement)handle.resolve(javac);
                assert (elm != null);
                t = javac.getTrees().getTree((ExecutableElement)elm);
                assert (t != null);
                result.add(t);
            }
            return result;
        }

        private List<Tree> getImplements2Remove(CompilationInfo javac, MemberInfo[] members, TypeElement clazz) {
            if (members == null || members.length == 0) {
                return Collections.emptyList();
            }
            ArrayList<TypeMirror> memberTypes = new ArrayList<TypeMirror>(members.length);
            for (MemberInfo member : members) {
                if (member.getGroup() != MemberInfo.Group.IMPLEMENTS) continue;
                TypeMirrorHandle typeMirrorHandle = (TypeMirrorHandle)member.getElementHandle();
                TypeMirror tm = typeMirrorHandle.resolve(javac);
                memberTypes.add(tm);
            }
            ClassTree classTree = javac.getTrees().getTree(clazz);
            ArrayList<Tree> result = new ArrayList<Tree>();
            Types types = javac.getTypes();
            block1: for (Tree tree : classTree.getImplementsClause()) {
                TreePath path = javac.getTrees().getPath(javac.getCompilationUnit(), tree);
                TypeMirror existingTM = javac.getTrees().getTypeMirror(path);
                for (TypeMirror tm : memberTypes) {
                    if (!types.isSameType(tm, existingTM)) continue;
                    result.add(tree);
                    continue block1;
                }
            }
            return result;
        }

        private static List<Tree> resolveImplements(List<? extends Tree> allImpls, Set<Tree> impls2Remove) {
            ArrayList<Tree> ret;
            if (allImpls == null) {
                ret = new ArrayList<Tree>(1);
            } else {
                ret = new ArrayList(allImpls.size() + 1);
                ret.addAll(allImpls);
            }
            if (impls2Remove != null && !impls2Remove.isEmpty()) {
                ret.removeAll(impls2Remove);
            }
            return ret;
        }
    }

    private static final class CreateSuperclassElement
    extends SimpleRefactoringElementImplementation
    implements CancellableTask<WorkingCopy> {
        private final URL folderURL;
        private URL superClassURL;
        private final String superClassName;
        private final ExtractSuperclassRefactoring refactoring;
        private final ElementHandle<TypeElement> sourceType;

        private CreateSuperclassElement(ExtractSuperclassRefactoring refactoring, FileObject folder, ElementHandle<TypeElement> sourceType) {
            this.refactoring = refactoring;
            this.folderURL = URLMapper.findURL((FileObject)folder, (int)0);
            this.superClassName = refactoring.getSuperClassName();
            this.sourceType = sourceType;
        }

        public void performChange() {
            try {
                FileObject folderFO = URLMapper.findFileObject((URL)this.folderURL);
                if (folderFO == null) {
                    return;
                }
                FileObject tempFO = FileUtil.getConfigFile((String)"Templates/Classes/Class.java");
                DataFolder folder = (DataFolder)DataObject.find((FileObject)folderFO);
                DataObject template = DataObject.find((FileObject)tempFO);
                DataObject newSuperClassDO = template.createFromTemplate(folder, this.superClassName);
                this.superClassURL = URLMapper.findURL((FileObject)newSuperClassDO.getPrimaryFile(), (int)0);
                this.refactoring.getContext().add((Object)newSuperClassDO.getPrimaryFile());
                JavaSource js = JavaSource.forFileObject((FileObject)newSuperClassDO.getPrimaryFile());
                js.runModificationTask((Task)this).commit();
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public void undoChange() {
            FileObject ifcFO = null;
            if (this.superClassURL != null) {
                ifcFO = URLMapper.findFileObject((URL)this.superClassURL);
            }
            if (ifcFO != null) {
                try {
                    ifcFO.delete();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }

        public String getText() {
            return NbBundle.getMessage(ExtractInterfaceRefactoringPlugin.class, (String)"TXT_ExtractSC_CreateSC", (Object)this.superClassName);
        }

        public String getDisplayText() {
            return this.getText();
        }

        public FileObject getParentFile() {
            return URLMapper.findFileObject((URL)this.folderURL);
        }

        public PositionBounds getPosition() {
            return null;
        }

        public Lookup getLookup() {
            FileObject fo = this.superClassURL == null ? null : URLMapper.findFileObject((URL)this.superClassURL);
            return fo != null ? Lookups.singleton((Object)fo) : Lookup.EMPTY;
        }

        public void cancel() {
        }

        public void run(WorkingCopy wc) throws Exception {
            wc.toPhase(JavaSource.Phase.RESOLVED);
            ClassTree classTree = CreateSuperclassElement.findClass((CompilationInfo)wc, this.superClassName);
            boolean makeAbstract = false;
            TreeMaker make = wc.getTreeMaker();
            GeneratorUtilities genUtils = GeneratorUtilities.get((WorkingCopy)wc);
            List typeParams = ExtractSuperclassRefactoringPlugin.findUsedGenericTypes((CompilationInfo)wc, (TypeElement)this.sourceType.resolve((CompilationInfo)wc), this.refactoring);
            ArrayList<TypeParameterTree> newTypeParams = new ArrayList<TypeParameterTree>(typeParams.size());
            TypeElement sourceTypeElm = (TypeElement)this.sourceType.resolve((CompilationInfo)wc);
            for (TypeParameterElement typeParameterElement : sourceTypeElm.getTypeParameters()) {
                TypeMirror origParam = typeParameterElement.asType();
                for (TypeMirror newParam : typeParams) {
                    Tree t;
                    if (!wc.getTypes().isSameType(origParam, newParam) || (t = wc.getTrees().getTree(typeParameterElement)).getKind() != Tree.Kind.TYPE_PARAMETER) continue;
                    TypeParameterTree typeParamTree = (TypeParameterTree)t;
                    if (!typeParamTree.getBounds().isEmpty()) {
                        typeParamTree = (TypeParameterTree)genUtils.importFQNs(t);
                    }
                    newTypeParams.add(typeParamTree);
                }
            }
            ArrayList<Tree> members = new ArrayList<Tree>();
            ArrayList<Tree> arrayList = new ArrayList<Tree>();
            CreateSuperclassElement.addConstructors(wc, sourceTypeElm, members);
            for (MemberInfo<ElementHandle<? extends Element>> member : this.refactoring.getMembers()) {
                Element elm;
                TypeMirrorHandle handle;
                if (member.getGroup() == MemberInfo.Group.FIELD) {
                    handle = member.getElementHandle();
                    elm = (VariableElement)handle.resolve((CompilationInfo)wc);
                    VariableTree tree = (VariableTree)wc.getTrees().getTree(elm);
                    VariableTree copy = (VariableTree)genUtils.importComments((Tree)tree, wc.getTrees().getPath(elm).getCompilationUnit());
                    copy = (VariableTree)genUtils.importFQNs((Tree)copy);
                    members.add(copy);
                    continue;
                }
                if (member.getGroup() == MemberInfo.Group.METHOD) {
                    handle = member.getElementHandle();
                    elm = (ExecutableElement)handle.resolve((CompilationInfo)wc);
                    MethodTree methodTree = wc.getTrees().getTree((ExecutableElement)elm);
                    if (member.isMakeAbstract() && !elm.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                        methodTree = make.Method(RetoucheUtils.makeAbstract(make, methodTree.getModifiers()), (CharSequence)methodTree.getName(), methodTree.getReturnType(), methodTree.getTypeParameters(), methodTree.getParameters(), methodTree.getThrows(), (BlockTree)null, null);
                        methodTree = (MethodTree)genUtils.importFQNs((Tree)methodTree);
                        RetoucheUtils.copyJavadoc(elm, methodTree, wc);
                    } else {
                        methodTree = (MethodTree)genUtils.importComments((Tree)methodTree, wc.getTrees().getPath(elm).getCompilationUnit());
                        methodTree = (MethodTree)genUtils.importFQNs((Tree)methodTree);
                    }
                    makeAbstract |= methodTree.getModifiers().getFlags().contains((Object)Modifier.ABSTRACT);
                    members.add(methodTree);
                    continue;
                }
                if (member.getGroup() != MemberInfo.Group.IMPLEMENTS) continue;
                handle = (TypeMirrorHandle)member.getElementHandle();
                TypeMirror implMirror = handle.resolve((CompilationInfo)wc);
                arrayList.add(make.Type(implMirror));
                makeAbstract |= true;
            }
            Tree superClass = CreateSuperclassElement.makeSuperclass(make, sourceTypeElm);
            ModifiersTree classModifiersTree = (makeAbstract |= ((DeclaredType)sourceTypeElm.getSuperclass()).asElement().getModifiers().contains((Object)Modifier.ABSTRACT)) ? RetoucheUtils.makeAbstract(make, classTree.getModifiers()) : classTree.getModifiers();
            classModifiersTree = (ModifiersTree)genUtils.importFQNs((Tree)classModifiersTree);
            ClassTree newClassTree = make.Class(classModifiersTree, (CharSequence)classTree.getSimpleName(), newTypeParams, superClass, arrayList, Collections.emptyList());
            newClassTree = GeneratorUtilities.get((WorkingCopy)wc).insertClassMembers(newClassTree, members);
            wc.rewrite((Tree)classTree, (Tree)newClassTree);
        }

        private static ClassTree findClass(CompilationInfo javac, String name) {
            for (Tree tree : javac.getCompilationUnit().getTypeDecls()) {
                if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind()) || javac.getTreeUtilities().isInterface((ClassTree)tree) || javac.getTreeUtilities().isAnnotation((ClassTree)tree) || javac.getTreeUtilities().isEnum((ClassTree)tree) || !name.contentEquals(((ClassTree)tree).getSimpleName())) continue;
                return (ClassTree)tree;
            }
            throw new IllegalStateException("wrong template, cannot find the class in " + javac.getFileObject());
        }

        private static Tree makeSuperclass(TreeMaker make, TypeElement clazz) {
            DeclaredType supType = (DeclaredType)clazz.getSuperclass();
            TypeElement supEl = (TypeElement)supType.asElement();
            return supEl.getSuperclass().getKind() == TypeKind.NONE ? null : make.Type((TypeMirror)supType);
        }

        private static void addConstructors(WorkingCopy javac, TypeElement origClass, List<Tree> members) {
            TreeMaker make = javac.getTreeMaker();
            GeneratorUtilities genUtils = GeneratorUtilities.get((WorkingCopy)javac);
            HashSet<Element> added = new HashSet<Element>();
            for (ExecutableElement constr : ElementFilter.constructorsIn(origClass.getEnclosedElements())) {
                StatementTree stmt;
                Iterator<? extends StatementTree> i$;
                TreePath path;
                MethodTree mc;
                if (javac.getElementUtilities().isSynthetic((Element)constr) || (mc = (MethodTree)((path = javac.getTrees().getPath(constr)) != null ? path.getLeaf() : null)) == null || !(i$ = mc.getBody().getStatements().iterator()).hasNext() || (stmt = i$.next()).getKind() != Tree.Kind.EXPRESSION_STATEMENT) continue;
                ExpressionStatementTree estmt = (ExpressionStatementTree)stmt;
                boolean isSyntheticSuper = javac.getTreeUtilities().isSynthetic(javac.getTrees().getPath(path.getCompilationUnit(), estmt));
                ExpressionTree expr = estmt.getExpression();
                TreePath expath = javac.getTrees().getPath(path.getCompilationUnit(), expr);
                Element el = javac.getTrees().getElement(expath);
                if (el == null || el.getKind() != ElementKind.CONSTRUCTOR || !added.add(el)) continue;
                ExecutableElement superclassConstr = (ExecutableElement)el;
                MethodInvocationTree invk = (MethodInvocationTree)expr;
                BlockTree block = isSyntheticSuper ? make.Block(Collections.emptyList(), false) : make.Block(Collections.singletonList(make.ExpressionStatement((ExpressionTree)make.MethodInvocation(Collections.emptyList(), invk.getMethodSelect(), CreateSuperclassElement.params2Arguments(make, superclassConstr.getParameters())))), false);
                MethodTree newConstr = make.Method(superclassConstr, block);
                newConstr = CreateSuperclassElement.removeRuntimeExceptions(javac, superclassConstr, make, newConstr);
                newConstr = (MethodTree)genUtils.importFQNs((Tree)newConstr);
                members.add(newConstr);
            }
        }

        private static MethodTree removeRuntimeExceptions(WorkingCopy javac, ExecutableElement superclassConstr, TreeMaker make, MethodTree newConstr) {
            int i = 0;
            TypeMirror rte = javac.getElements().getTypeElement("java.lang.RuntimeException").asType();
            ArrayList<Integer> rtes = new ArrayList<Integer>();
            for (TypeMirror typeMirror : superclassConstr.getThrownTypes()) {
                if (javac.getTypes().isSubtype(typeMirror, rte)) {
                    rtes.add(i);
                }
                ++i;
            }
            for (int j = rtes.size() - 1; j >= 0; --j) {
                newConstr = make.removeMethodThrows(newConstr, ((Integer)rtes.get(j)).intValue());
            }
            return newConstr;
        }

        private static List<? extends ExpressionTree> params2Arguments(TreeMaker make, List<? extends VariableElement> params) {
            if (params.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<IdentifierTree> args = new ArrayList<IdentifierTree>(params.size());
            for (VariableElement variableElement : params) {
                args.add(make.Identifier((CharSequence)variableElement.getSimpleName()));
            }
            return args;
        }
    }
}

