/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.cdc.platform.nokias80;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.netbeans.modules.j2me.cdc.platform.CDCDevice;
import org.netbeans.modules.j2me.cdc.platform.CDCPlatform;
import org.netbeans.modules.j2me.cdc.platform.spi.CDCPlatformDetector;
import org.netbeans.modules.j2me.cdc.platform.spi.CDCPlatformUtil;
import org.netbeans.modules.j2me.cdc.platform.spi.StreamReader;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class NokiaPlatformDetector
extends CDCPlatformDetector {
    private static String[] NOKIA_JAVADOC_FOLDERS = new String[]{"PersonalProfileDoc/CDC1.0", "PersonalProfileDoc/FOUNDATIONPROFILE", "PersonalProfileDoc/JDBC", "PersonalProfileDoc/PERSONALPROFILE"};

    public String getPlatformName() {
        return "Nokia S80 CDC";
    }

    public String getPlatformType() {
        return "nokiaS80";
    }

    public boolean accept(FileObject dir) {
        FileObject tool = CDCPlatformUtil.findTool((String)"epoc32/release/wins/udeb", (String)"epoc", Collections.singleton(dir));
        FileObject tool2 = CDCPlatformUtil.findTool((String)"bin", (String)"emulator", Collections.singleton(dir));
        return tool != null && tool2 != null;
    }

    public CDCPlatform detectPlatform(FileObject dir) throws IOException {
        String line;
        assert (dir != null);
        FileObject java = CDCPlatformUtil.findTool((String)"bin", (String)"emulator", Collections.singleton(dir));
        if (java == null) {
            throw new IOException("emulator.exe can not be found in desired location!");
        }
        File javaFile = FileUtil.toFile((FileObject)java);
        if (javaFile == null) {
            throw new IOException("emulator.exe can not be found in desired location!");
        }
        String javapath = javaFile.getAbsolutePath();
        FileObject bin = dir.getFileObject("bin");
        ArrayList<FileObject> jdocs = new ArrayList<FileObject>();
        File base = FileUtil.toFile((FileObject)dir);
        if (base != null) {
            for (int i = 0; i < NOKIA_JAVADOC_FOLDERS.length; ++i) {
                File f = new File(base, NOKIA_JAVADOC_FOLDERS[i]);
                if (!f.isDirectory() || !f.canRead()) continue;
                jdocs.add(FileUtil.toFileObject((File)f));
            }
        }
        File path = FileUtil.toFile((FileObject)bin);
        StringBuffer sb = new StringBuffer();
        ArrayList<String> env = new ArrayList<String>();
        String absPath = FileUtil.toFile((FileObject)dir).getAbsolutePath();
        env.add("SDKDRIVE=" + String.valueOf(absPath.charAt(0)));
        env.add("EPOCROOT=" + absPath.substring(2) + "\\");
        env.add("Path=" + absPath + "\\epoc32\\gcc\\bin;" + absPath + "\\epoc32\\tools;" + absPath + "\\epoc32\\include;" + System.getProperty("java.library.path"));
        try {
            String[] command = new String[]{javapath, "-version"};
            Process process = Runtime.getRuntime().exec(command, env != null ? env.toArray(new String[0]) : null, path);
            StreamReader ior = new StreamReader(process.getInputStream(), sb);
            StringBuffer err = new StringBuffer();
            StreamReader irr = new StreamReader(process.getErrorStream(), err);
            ior.join();
            irr.join();
            process.waitFor();
            process.getOutputStream().close();
            int exitValue = process.exitValue();
            System.out.println(err);
            if (exitValue != 0) {
                throw new IOException();
            }
        }
        catch (InterruptedException ex) {
            IOException e = new IOException();
            ErrorManager.getDefault().annotate((Throwable)e, (Throwable)ex);
            throw e;
        }
        String name = sb.toString();
        int i = name.indexOf(10);
        if (i != -1) {
            name = name.substring(0, i);
        }
        sb = new StringBuffer();
        try {
            String[] command = new String[]{javapath, "-Xquery"};
            Process process = Runtime.getRuntime().exec(command, env != null ? env.toArray(new String[0]) : null, path);
            StreamReader ior = new StreamReader(process.getInputStream(), sb);
            StringBuffer err = new StringBuffer();
            StreamReader irr = new StreamReader(process.getErrorStream(), err);
            ior.join();
            irr.join();
            process.waitFor();
            process.getOutputStream().close();
            int exitValue = process.exitValue();
            System.out.println(err);
            if (exitValue != 0) {
                throw new IOException();
            }
        }
        catch (InterruptedException ex) {
            IOException e = new IOException();
            ErrorManager.getDefault().annotate((Throwable)e, (Throwable)ex);
            throw e;
        }
        BufferedReader br = new BufferedReader(new StringReader(sb.toString()));
        String devices = null;
        StringBuffer newCp = new StringBuffer();
        String width = null;
        String height = null;
        String bitDepth = null;
        String isColor = null;
        while ((line = br.readLine()) != null) {
            if (line.startsWith("device.list")) {
                devices = line.substring(line.indexOf(58) + 1).trim();
                continue;
            }
            if (line.startsWith(devices + ".bootclasspath")) {
                String bcp = line.substring(line.indexOf(58) + 1).trim();
                StringTokenizer st = new StringTokenizer(bcp, ",");
                while (st.hasMoreTokens()) {
                    newCp.append(st.nextToken().trim());
                    if (!st.hasMoreTokens()) continue;
                    newCp.append(';');
                }
                continue;
            }
            if (line.startsWith(devices + ".screen.width")) {
                width = line.substring(line.indexOf(58) + 1).trim();
                continue;
            }
            if (line.startsWith(devices + ".screen.height")) {
                height = line.substring(line.indexOf(58) + 1).trim();
                continue;
            }
            if (line.startsWith(devices + ".screen.isColor")) {
                isColor = line.substring(line.indexOf(58) + 1).trim();
                continue;
            }
            if (!line.startsWith(devices + ".screen.bitDepth")) continue;
            bitDepth = line.substring(line.indexOf(58) + 1).trim();
        }
        HashMap<String, Object> modes = new HashMap<String, Object>();
        modes.put(CDCPlatform.PROP_EXEC_MAIN, null);
        CDCDevice.CDCProfile profile = new CDCDevice.CDCProfile("PP-1.0", "PP-1.0", "1.0", modes, newCp.toString(), null, true);
        CDCDevice.Screen screen = new CDCDevice.Screen(width, height, bitDepth, isColor, "false", "true");
        CDCDevice device = new CDCDevice(name, name, new CDCDevice.CDCProfile[]{profile}, new CDCDevice.Screen[]{screen});
        return new CDCPlatform(this.getPlatformName() + " " + name, this.getPlatformName() + " " + name, this.getPlatformType(), "1.4", Collections.singletonList(dir.getURL()), Collections.EMPTY_LIST, jdocs, new CDCDevice[]{device}, true);
    }

    public int getVersion() {
        return 1;
    }
}

