/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.nodes.OthersRootNode;
import org.netbeans.modules.maven.spi.nodes.AbstractMavenNodeList;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;

public class OtherRootNodeFactory
implements NodeFactory {
    private static final String KEY_OTHER = "otherRoots";
    private static final String KEY_OTHER_TEST = "otherTestRoots";
    private static final String MAIN = "src/main";
    private static final String TEST = "src/test";

    public NodeList createNodes(Project project) {
        NbMavenProjectImpl prj = (NbMavenProjectImpl)project.getLookup().lookup(NbMavenProjectImpl.class);
        return new NList(prj);
    }

    private static class NList
    extends AbstractMavenNodeList<String>
    implements PropertyChangeListener,
    FileChangeListener {
        private NbMavenProjectImpl project;
        private final FileChangeListener fcl = FileUtil.weakFileChangeListener((FileChangeListener)this, null);

        NList(NbMavenProjectImpl prj) {
            this.project = prj;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("MavenProject".equals(evt.getPropertyName())) {
                this.fireChange();
            }
            if ("RESOURCES".equals(evt.getPropertyName()) && (OtherRootNodeFactory.MAIN.equals(evt.getNewValue()) || OtherRootNodeFactory.TEST.equals(evt.getNewValue()))) {
                this.fireChange();
                this.checkFileObject((String)evt.getNewValue());
            }
        }

        public List<String> keys() {
            ArrayList<String> list = new ArrayList<String>();
            if (this.project.getOtherRoots(false).length > 0) {
                list.add(OtherRootNodeFactory.KEY_OTHER);
            }
            if (this.project.getOtherRoots(true).length > 0) {
                list.add(OtherRootNodeFactory.KEY_OTHER_TEST);
            }
            return list;
        }

        public Node node(String key) {
            if (OtherRootNodeFactory.KEY_OTHER.equals(key)) {
                File[] fls = this.project.getOtherRoots(false);
                if (fls.length > 0 && fls[0].getParentFile() != null) {
                    FileObject fo = FileUtil.toFileObject((File)fls[0].getParentFile());
                    return new OthersRootNode(this.project, false, fo);
                }
                return null;
            }
            if (OtherRootNodeFactory.KEY_OTHER_TEST.equals(key)) {
                File[] fls = this.project.getOtherRoots(true);
                if (fls.length > 0 && fls[0].getParentFile() != null) {
                    FileObject fo = FileUtil.toFileObject((File)fls[0].getParentFile());
                    return new OthersRootNode(this.project, true, fo);
                }
                return null;
            }
            assert (false) : "Wrong key for Dependencies NodeFactory: " + key;
            return null;
        }

        @Override
        public void addNotify() {
            NbMavenProject watch = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
            watch.addPropertyChangeListener(this);
            watch.addWatchedPath(OtherRootNodeFactory.MAIN);
            watch.addWatchedPath(OtherRootNodeFactory.TEST);
            this.checkFileObject(OtherRootNodeFactory.MAIN);
            this.checkFileObject(OtherRootNodeFactory.TEST);
        }

        @Override
        public void removeNotify() {
            NbMavenProject watch = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
            watch.removePropertyChangeListener(this);
            watch.removeWatchedPath(OtherRootNodeFactory.MAIN);
            watch.removeWatchedPath(OtherRootNodeFactory.TEST);
            FileObject fo = this.project.getProjectDirectory().getFileObject(OtherRootNodeFactory.MAIN);
            if (fo != null) {
                fo.removeFileChangeListener(this.fcl);
            }
            if ((fo = this.project.getProjectDirectory().getFileObject(OtherRootNodeFactory.TEST)) != null) {
                fo.removeFileChangeListener(this.fcl);
            }
        }

        private void checkFileObject(String path) {
            FileObject fo = this.project.getProjectDirectory().getFileObject(path);
            if (fo != null) {
                fo.removeFileChangeListener(this.fcl);
                fo.addFileChangeListener(this.fcl);
            }
        }

        public void fileFolderCreated(FileEvent arg0) {
            this.fireChange();
        }

        public void fileDataCreated(FileEvent arg0) {
        }

        public void fileChanged(FileEvent arg0) {
        }

        public void fileDeleted(FileEvent arg0) {
            this.fireChange();
            arg0.getFile().removeFileChangeListener((FileChangeListener)this);
        }

        public void fileRenamed(FileRenameEvent arg0) {
            this.fireChange();
        }

        public void fileAttributeChanged(FileAttributeEvent arg0) {
        }
    }
}

