/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.newproject;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.maven.artifact.Artifact;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.maven.api.ModelUtils;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.archetype.Archetype;
import org.netbeans.modules.maven.api.archetype.ProjectInfo;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.execute.BeanRunConfig;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.Dependency;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.newproject.BasicEEWizardIterator;
import org.netbeans.modules.maven.newproject.MavenWizardIterator;
import org.netbeans.modules.maven.options.MavenCommandSettings;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ArchetypeWizardUtils {
    public static final String ADDITIONAL_PROPS = "additionalProps";
    private static final String USER_DIR_PROP = "user.dir";
    static final Archetype[] WEB_APP_ARCHS;
    static final Archetype[] EJB_ARCHS;
    static final Archetype[] EAR_ARCHS;
    static final Archetype EA_ARCH;
    static final String[] EE_LEVELS;
    private static final String loggerName = "org.netbeans.ui.metrics.maven";
    private static final String loggerKey = "USG_PROJECT_CREATE_MAVEN";

    private ArchetypeWizardUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runArchetype(File directory, ProjectInfo vi, Archetype arch, @NullAllowed Map<String, String> additional) throws IOException {
        Properties props = new Properties();
        props.setProperty("artifactId", vi.artifactId);
        props.setProperty("version", vi.version);
        props.setProperty("groupId", vi.groupId);
        String pack = vi.packageName;
        if (pack != null && pack.trim().length() > 0) {
            props.setProperty("package", pack);
        }
        props.setProperty("archetypeArtifactId", arch.getArtifactId());
        props.setProperty("archetypeGroupId", arch.getGroupId());
        props.setProperty("archetypeVersion", arch.getVersion());
        props.setProperty("basedir", directory.getAbsolutePath());
        if (additional != null) {
            for (String key : additional.keySet()) {
                props.setProperty(key, additional.get(key));
            }
        }
        BeanRunConfig config = new BeanRunConfig();
        config.setActivatedProfiles(Collections.<String>emptyList());
        config.setExecutionDirectory(directory);
        config.setExecutionName(NbBundle.getMessage(ArchetypeWizardUtils.class, (String)"RUN_Project_Creation"));
        config.setGoals(Collections.singletonList(MavenCommandSettings.getDefault().getCommand("createArchetypeNG")));
        String repo = arch.getRepository();
        props.setProperty("archetypeRepository", repo != null ? repo : "http://repo1.maven.org/maven2/");
        config.setInteractive(false);
        props.setProperty("archetype.interactive", "false");
        config.setProperties(props);
        if (arch.getVersion().contains("SNAPSHOT")) {
            config.setUpdateSnapshots(true);
        }
        config.setTaskDisplayName(NbBundle.getMessage(ArchetypeWizardUtils.class, (String)"RUN_Maven"));
        String oldUserdir = System.getProperty(USER_DIR_PROP);
        System.setProperty(USER_DIR_PROP, directory.getAbsolutePath());
        try {
            ExecutorTask task = RunUtils.executeMaven(config);
            task.result();
        }
        finally {
            if (oldUserdir == null) {
                System.getProperties().remove(USER_DIR_PROP);
            } else {
                System.setProperty(USER_DIR_PROP, oldUserdir);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<String, String> getAdditionalProperties(Artifact art) {
        HashMap<String, String> map;
        block21: {
            map = new HashMap<String, String>();
            File fil = art.getFile();
            JarFile jf = null;
            try {
                jf = new JarFile(fil);
                JarEntry entry = jf.getJarEntry("META-INF/maven/archetype-metadata.xml");
                if (entry == null) {
                    entry = jf.getJarEntry("META-INF/maven/archetype.xml");
                }
                if (entry == null) break block21;
                InputStream in = jf.getInputStream(entry);
                try {
                    Document doc = XMLUtil.parse((InputSource)new InputSource(in), (boolean)false, (boolean)false, (ErrorHandler)XMLUtil.defaultErrorHandler(), null);
                    NodeList nl = doc.getElementsByTagName("requiredProperty");
                    for (int i = 0; i < nl.getLength(); ++i) {
                        Element rP = (Element)nl.item(i);
                        Element dV = XMLUtil.findElement((Element)rP, (String)"defaultValue", null);
                        map.put(rP.getAttribute("key"), dV != null ? XMLUtil.findText((Node)dV) : null);
                    }
                }
                finally {
                    in.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(ArchetypeWizardUtils.class.getName()).log(Level.INFO, ex.getMessage(), ex);
            }
            catch (SAXException ex) {
                Logger.getLogger(ArchetypeWizardUtils.class.getName()).log(Level.INFO, ex.getMessage(), ex);
            }
            finally {
                if (jf != null) {
                    try {
                        jf.close();
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Set<FileObject> instantiate(ProgressHandle handle, WizardDescriptor wiz) throws IOException {
        ProjectInfo vi = new ProjectInfo((String)wiz.getProperty("groupId"), (String)wiz.getProperty("artifactId"), (String)wiz.getProperty("version"), (String)wiz.getProperty("package"));
        Archetype arch = (Archetype)wiz.getProperty("archetype");
        ArchetypeWizardUtils.logUsage(arch.getGroupId(), arch.getArtifactId(), arch.getVersion());
        Map additional = (Map)wiz.getProperty(ADDITIONAL_PROPS);
        try {
            ProjectInfo ear_vi = (ProjectInfo)wiz.getProperty("ear_versionInfo");
            if (ear_vi != null) {
                ProjectInfo web_vi = (ProjectInfo)wiz.getProperty("web_versionInfo");
                ProjectInfo ejb_vi = (ProjectInfo)wiz.getProperty("ejb_versionInfo");
                handle.start(8 + (web_vi != null ? 3 : 0) + (ejb_vi != null ? 3 : 0));
                File rootFile = FileUtil.normalizeFile((File)((File)wiz.getProperty("projdir")));
                ArchetypeWizardUtils.createFromArchetype(handle, rootFile, vi, arch, additional, 0, true);
                File earFile = FileUtil.normalizeFile((File)((File)wiz.getProperty("ear_projdir")));
                ArchetypeWizardUtils.createFromArchetype(handle, earFile, ear_vi, (Archetype)wiz.getProperty("ear_archetype"), null, 4, false);
                int progressCounter = 6;
                if (web_vi != null) {
                    ArchetypeWizardUtils.createFromArchetype(handle, FileUtil.normalizeFile((File)((File)wiz.getProperty("web_projdir"))), web_vi, (Archetype)wiz.getProperty("web_archetype"), null, progressCounter, false);
                    progressCounter += 3;
                }
                if (ejb_vi != null) {
                    ArchetypeWizardUtils.createFromArchetype(handle, FileUtil.normalizeFile((File)((File)wiz.getProperty("ejb_projdir"))), ejb_vi, (Archetype)wiz.getProperty("ejb_archetype"), null, progressCounter, false);
                    progressCounter += 3;
                }
                ArchetypeWizardUtils.addEARDeps((File)wiz.getProperty("ear_projdir"), ejb_vi, web_vi, progressCounter);
                Set<FileObject> projects = ArchetypeWizardUtils.openProjects(rootFile, earFile);
                handle.progress(++progressCounter);
                Set<FileObject> set = projects;
                return set;
            }
            handle.start(4);
            File projFile = FileUtil.normalizeFile((File)((File)wiz.getProperty("projdir")));
            ArchetypeWizardUtils.createFromArchetype(handle, projFile, vi, arch, additional, 0, true);
            Set<FileObject> projects = ArchetypeWizardUtils.openProjects(projFile, null);
            handle.progress(4);
            Templates.setDefinesMainProject((WizardDescriptor)wiz, (projects.size() > 1 ? 1 : 0) != 0);
            Set<FileObject> set = projects;
            return set;
        }
        finally {
            handle.finish();
        }
    }

    public static void logUsage(String groupId, String artifactId, String version) {
        LogRecord logRecord = new LogRecord(Level.INFO, loggerKey);
        logRecord.setLoggerName(loggerName);
        logRecord.setParameters(new Object[]{groupId + ":" + artifactId + ":" + version});
        Logger.getLogger(loggerName).log(logRecord);
    }

    public static void createFromArchetype(ProgressHandle handle, File projDir, ProjectInfo vi, Archetype arch, @NullAllowed Map<String, String> additional, int progressCounter, boolean updateLastUsedProjectDir) throws IOException {
        handle.progress(++progressCounter);
        File parent = projDir.getParentFile();
        if (updateLastUsedProjectDir && parent != null && parent.exists()) {
            ProjectChooser.setProjectsFolder((File)parent);
        }
        parent.mkdirs();
        handle.progress(NbBundle.getMessage(MavenWizardIterator.class, (String)"PRG_Processing_Archetype"), ++progressCounter);
        ArchetypeWizardUtils.runArchetype(parent, vi, arch, additional);
        handle.progress(++progressCounter);
    }

    public static Set<FileObject> openProjects(File dirF, File mainProjectDir) throws IOException {
        ArrayList<FileObject> resultList = new ArrayList<FileObject>();
        FileObject fDir = FileUtil.toFileObject((File)dirF);
        if (fDir != null) {
            FileObject mainFO = mainProjectDir != null ? FileUtil.toFileObject((File)mainProjectDir) : null;
            resultList.add(fDir);
            ArchetypeWizardUtils.processProjectFolder(fDir);
            Enumeration e = fDir.getFolders(true);
            while (e.hasMoreElements()) {
                FileObject subfolder = (FileObject)e.nextElement();
                if (!ProjectManager.getDefault().isProject(subfolder)) continue;
                if (subfolder.equals(mainFO)) {
                    resultList.add(0, subfolder);
                } else {
                    resultList.add(subfolder);
                }
                ArchetypeWizardUtils.processProjectFolder(subfolder);
            }
        }
        return new LinkedHashSet<FileObject>(resultList);
    }

    private static void processProjectFolder(FileObject fo) {
        try {
            Project prj = ProjectManager.getDefault().findProject(fo);
            if (prj == null) {
                return;
            }
            NbMavenProject watch = (NbMavenProject)prj.getLookup().lookup(NbMavenProject.class);
            if (watch != null) {
                watch.downloadDependencyAndJavadocSource(false);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static void addEARDeps(File earDir, ProjectInfo ejbVi, ProjectInfo webVi, int progressCounter) {
        FileObject earDirFO = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)earDir));
        if (earDirFO == null) {
            return;
        }
        ArrayList<AddDependencyOperation> operations = new ArrayList<AddDependencyOperation>();
        if (ejbVi != null) {
            operations.add(new AddDependencyOperation(ejbVi, "ejb"));
        }
        if (webVi != null) {
            operations.add(new AddDependencyOperation(webVi, "war"));
        }
        Utilities.performPOMModelOperations((FileObject)earDirFO.getFileObject("pom.xml"), operations);
        ++progressCounter;
    }

    static {
        EE_LEVELS = new String[]{NbBundle.getMessage(BasicEEWizardIterator.class, (String)"LBL_JEE6"), NbBundle.getMessage(BasicEEWizardIterator.class, (String)"LBL_JEE5"), NbBundle.getMessage(BasicEEWizardIterator.class, (String)"LBL_J2EE14")};
        WEB_APP_ARCHS = new Archetype[3];
        Archetype arch = new Archetype();
        arch.setGroupId("org.codehaus.mojo.archetypes");
        arch.setVersion("1.4");
        arch.setArtifactId("webapp-javaee6");
        ArchetypeWizardUtils.WEB_APP_ARCHS[0] = arch;
        arch = new Archetype();
        arch.setGroupId("org.codehaus.mojo.archetypes");
        arch.setVersion("1.2");
        arch.setArtifactId("webapp-jee5");
        ArchetypeWizardUtils.WEB_APP_ARCHS[1] = arch;
        arch = new Archetype();
        arch.setGroupId("org.codehaus.mojo.archetypes");
        arch.setVersion("1.2");
        arch.setArtifactId("webapp-j2ee14");
        ArchetypeWizardUtils.WEB_APP_ARCHS[2] = arch;
        EJB_ARCHS = new Archetype[3];
        arch = new Archetype();
        arch.setGroupId("org.codehaus.mojo.archetypes");
        arch.setVersion("1.4");
        arch.setArtifactId("ejb-javaee6");
        ArchetypeWizardUtils.EJB_ARCHS[0] = arch;
        arch = new Archetype();
        arch.setGroupId("org.codehaus.mojo.archetypes");
        arch.setVersion("1.2");
        arch.setArtifactId("ejb-jee5");
        ArchetypeWizardUtils.EJB_ARCHS[1] = arch;
        arch = new Archetype();
        arch.setGroupId("org.codehaus.mojo.archetypes");
        arch.setVersion("1.2");
        arch.setArtifactId("ejb-j2ee14");
        ArchetypeWizardUtils.EJB_ARCHS[2] = arch;
        EAR_ARCHS = new Archetype[3];
        arch = new Archetype();
        arch.setGroupId("org.codehaus.mojo.archetypes");
        arch.setVersion("1.4");
        arch.setArtifactId("ear-javaee6");
        ArchetypeWizardUtils.EAR_ARCHS[0] = arch;
        arch = new Archetype();
        arch.setGroupId("org.codehaus.mojo.archetypes");
        arch.setVersion("1.3");
        arch.setArtifactId("ear-jee5");
        ArchetypeWizardUtils.EAR_ARCHS[1] = arch;
        arch = new Archetype();
        arch.setGroupId("org.codehaus.mojo.archetypes");
        arch.setVersion("1.3");
        arch.setArtifactId("ear-j2ee14");
        ArchetypeWizardUtils.EAR_ARCHS[2] = arch;
        EA_ARCH = new Archetype();
        EA_ARCH.setGroupId("org.codehaus.mojo.archetypes");
        EA_ARCH.setVersion("1.1");
        EA_ARCH.setArtifactId("pom-root");
    }

    public static class AddDependencyOperation
    implements ModelOperation<POMModel> {
        private final String group;
        private final String artifact;
        private final String version;
        private final String type;

        public AddDependencyOperation(ProjectInfo info, String type) {
            this.group = info.groupId;
            this.artifact = info.artifactId;
            this.version = info.version;
            this.type = type;
        }

        public void performOperation(POMModel model) {
            Dependency dep = ModelUtils.checkModelDependency(model, this.group, this.artifact, true);
            dep.setVersion(this.version);
            dep.setType(this.type);
        }
    }
}

