/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.grammar;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.netbeans.modules.maven.grammar.AbstractSchemaBasedGrammar;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.indexer.api.RepositoryQueries;
import org.netbeans.modules.xml.api.model.GrammarEnvironment;
import org.netbeans.modules.xml.api.model.GrammarResult;
import org.netbeans.modules.xml.api.model.HintContext;

public class MavenSettingsGrammar
extends AbstractSchemaBasedGrammar {
    public static final String[] UPDATE_POLICIES = new String[]{"always", "daily", "never", "interval:10", "interval:60"};
    public static final String[] CHECKSUM_POLICIES = new String[]{"fail", "warn"};
    public static final String[] LAYOUTS = new String[]{"default", "legacy"};

    public MavenSettingsGrammar(GrammarEnvironment env) {
        super(env);
    }

    @Override
    protected InputStream getSchemaStream() {
        return this.getClass().getResourceAsStream("/org/netbeans/modules/maven/grammar/settings-1.0.0.xsd");
    }

    @Override
    protected List<GrammarResult> getDynamicCompletion(String path, HintContext hintCtx, Element lowestParent) {
        if ("/settings/proxies".equals(path)) {
            // empty if block
        }
        return Collections.emptyList();
    }

    @Override
    protected Enumeration<GrammarResult> getDynamicValueCompletion(String path, HintContext virtualTextCtx, Element el) {
        if (path.endsWith("releases/updatePolicy") || path.endsWith("snapshots/updatePolicy")) {
            return super.createTextValueList(UPDATE_POLICIES, virtualTextCtx);
        }
        if (path.endsWith("releases/checksumPolicy") || path.endsWith("snapshots/checksumPolicy")) {
            return super.createTextValueList(CHECKSUM_POLICIES, virtualTextCtx);
        }
        if (path.endsWith("repository/layout") || path.endsWith("pluginRepository/layout")) {
            return super.createTextValueList(LAYOUTS, virtualTextCtx);
        }
        if (path.endsWith("repositories/repository/url") || path.endsWith("pluginRepositories/pluginRepository/url")) {
            List<String> repoIds = this.getRepoUrls();
            return super.createTextValueList(repoIds.toArray(new String[0]), virtualTextCtx);
        }
        if (path.endsWith("pluginGroups/pluginGroup")) {
            Set elems = RepositoryQueries.filterPluginGroupIds((String)virtualTextCtx.getCurrentPrefix(), (RepositoryInfo[])new RepositoryInfo[0]);
            Iterator it = elems.iterator();
            ArrayList<AbstractSchemaBasedGrammar.MyTextElement> texts = new ArrayList<AbstractSchemaBasedGrammar.MyTextElement>();
            while (it.hasNext()) {
                String elem = (String)it.next();
                texts.add(new AbstractSchemaBasedGrammar.MyTextElement(elem, virtualTextCtx.getCurrentPrefix()));
            }
            return Collections.enumeration(texts);
        }
        return null;
    }

    private List<String> getRepoUrls() {
        ArrayList<String> repos = new ArrayList<String>();
        List ris = RepositoryPreferences.getInstance().getRepositoryInfos();
        for (RepositoryInfo ri : ris) {
            if (ri.getRepositoryUrl() == null) continue;
            repos.add(ri.getRepositoryUrl());
        }
        return repos;
    }
}

