/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils.filters;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.filters.FileAndFileObjectFilter;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class MacOSXExecutableFileFilter
extends FileAndFileObjectFilter {
    private static MacOSXExecutableFileFilter instance = null;

    public static MacOSXExecutableFileFilter getInstance() {
        if (instance == null) {
            instance = new MacOSXExecutableFileFilter();
        }
        return instance;
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(MacOSXExecutableFileFilter.class, (String)"FILECHOOSER_MACHOEXECUTABLE_FILEFILTER");
    }

    @Override
    protected boolean mimeAccept(File f) {
        return this.checkHeader(f);
    }

    @Override
    protected boolean mimeAccept(FileObject f) {
        return this.checkHeader(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkHeader(Object f) {
        CndUtils.assertTrue(f instanceof File || f instanceof FileObject);
        byte[] bytes = new byte[18];
        int offset = 0;
        InputStream is = null;
        try {
            int n;
            is = f instanceof File ? new FileInputStream((File)f) : ((FileObject)f).getInputStream();
            for (int left = 18; left > 0; left -= n) {
                n = is.read(bytes, offset, left);
                if (n <= 0) {
                    boolean bl = false;
                    return bl;
                }
                offset += n;
            }
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        if (bytes[0] == 74 && bytes[1] == 111 && bytes[2] == 121 && bytes[3] == 33 && bytes[4] == 112 && bytes[5] == 101 && bytes[6] == 102 && bytes[7] == 102) {
            return true;
        }
        if (bytes[0] == -50 && bytes[1] == -6 && bytes[2] == -19 && bytes[3] == -2 && bytes[12] == 2) {
            return true;
        }
        if (bytes[0] == -49 && bytes[1] == -6 && bytes[2] == -19 && bytes[3] == -2) {
            return true;
        }
        if (bytes[0] == -2 && bytes[1] == -19 && bytes[2] == -6 && bytes[3] == -50) {
            return true;
        }
        return bytes[0] == -54 && bytes[1] == -2 && bytes[2] == -70 && bytes[3] == -66;
    }

    @Override
    protected String[] getSuffixes() {
        return new String[0];
    }
}

