/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.MissingResourceException;
import java.util.concurrent.Future;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.MacroExpanderFactory;
import org.netbeans.modules.nativeexecution.support.InstalledFileLocatorProvider;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.openide.modules.InstalledFileLocator;

public class HelperLibraryUtility {
    private final HashMap<ExecutionEnvironment, List<String>> cache = new HashMap();
    private final String pattern;
    private final String codeNameBase;

    public HelperLibraryUtility(String searchPattern) {
        this("org.netbeans.modules.dlight.nativeexecution", searchPattern);
    }

    public HelperLibraryUtility(String codeNameBase, String searchPattern) {
        this.codeNameBase = codeNameBase;
        this.pattern = searchPattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<String> getPaths(ExecutionEnvironment env) throws IOException {
        if (!ConnectionManager.getInstance().isConnectedTo(env)) {
            throw new IllegalStateException(((Object)env).toString() + " is not connected");
        }
        List<String> result = null;
        HashMap<ExecutionEnvironment, List<String>> hashMap = this.cache;
        synchronized (hashMap) {
            result = this.cache.get(env);
            if (result == null) {
                try {
                    HostInfo hinfo = HostInfoUtils.getHostInfo(env);
                    List<String> localFile = this.getLocalFileLocationFor(env);
                    if (env.isLocal()) {
                        result = localFile;
                    } else {
                        result = new ArrayList<String>();
                        for (String lf : localFile) {
                            Logger.assertNonUiThread("Potentially long method " + this.getClass().getName() + ".getPath() is invoked in AWT thread");
                            File file = new File(lf);
                            String fileName = file.getName();
                            String fileFolder = file.getParentFile().getName();
                            String remoteFile = hinfo.getTempDir() + '/' + fileFolder + '/' + fileName;
                            Future<CommonTasksSupport.UploadStatus> uploadTask = CommonTasksSupport.uploadFile(lf, env, remoteFile, 493, true);
                            if (!uploadTask.get().isOK()) {
                                throw new IOException("Unable to upload " + fileName + " to " + env.getDisplayName());
                            }
                            result.add(remoteFile);
                        }
                    }
                    this.cache.put(env, result);
                }
                catch (IOException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new IOException(ex);
                }
            }
        }
        return result;
    }

    public final String getLDPaths(ExecutionEnvironment env) throws IOException {
        List<String> paths = this.getPaths(env);
        StringBuilder buf = new StringBuilder();
        for (String p : paths) {
            int i;
            if (buf.length() > 0) {
                buf.append(':');
            }
            String parent = (i = (p = p.replace('\\', '/')).lastIndexOf(47)) >= 0 ? p.substring(0, i) : p;
            buf.append(parent);
        }
        return buf.toString();
    }

    public final String getLibraryName(ExecutionEnvironment env) throws IOException {
        List<String> paths = this.getPaths(env);
        String name = null;
        for (String p : paths) {
            File file = new File(p);
            if (name == null) {
                name = file.getName();
                continue;
            }
            assert (name.equals(file.getName()));
        }
        return name;
    }

    private List<String> getLocalFileLocationFor(ExecutionEnvironment env) throws ParseException, MissingResourceException {
        InstalledFileLocator fl = InstalledFileLocatorProvider.getDefault();
        MacroExpanderFactory.MacroExpander expander = MacroExpanderFactory.getExpander(env);
        String aPattern = this.pattern.replace("${_isa}", "${_my_isa}");
        String path = expander.expandPredefinedMacros(aPattern);
        int indexOf = path.indexOf("${_my_isa}");
        ArrayList<String> paths = new ArrayList<String>();
        if (indexOf > 0) {
            paths.add(path.replace("${_my_isa}", ""));
            paths.add(path.replace("${_my_isa}", "_64"));
        } else {
            paths.add(path);
        }
        ArrayList<String> res = new ArrayList<String>();
        for (String p : paths) {
            File file = fl.locate(p, this.codeNameBase, false);
            if (file == null || !file.exists()) {
                throw new MissingResourceException(p, null, null);
            }
            res.add(file.getAbsolutePath());
        }
        return res;
    }
}

