/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbverification.fixes;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.j2ee.ejbverification.EJBProblemFinder;
import org.netbeans.modules.j2ee.ejbverification.JavaUtils;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;
import org.openide.text.PositionRef;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ExposeBusinessMethod
implements Fix {
    private FileObject fileObject;
    private ElementHandle<TypeElement> targetClassHandle;
    private ElementHandle<ExecutableElement> methodHandle;
    private boolean local;

    public ExposeBusinessMethod(FileObject fileObject, ElementHandle<TypeElement> targetClassHandle, ElementHandle<ExecutableElement> methodHandle, boolean local) {
        this.fileObject = fileObject;
        this.targetClassHandle = targetClassHandle;
        this.methodHandle = methodHandle;
        this.local = local;
    }

    public ChangeInfo implement() {
        CancellableTask<WorkingCopy> task = new CancellableTask<WorkingCopy>(){

            public void cancel() {
            }

            public void run(WorkingCopy workingCopy) throws Exception {
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                TypeElement targetClass = (TypeElement)ExposeBusinessMethod.this.targetClassHandle.resolve((CompilationInfo)workingCopy);
                ExecutableElement originalMethod = (ExecutableElement)ExposeBusinessMethod.this.methodHandle.resolve((CompilationInfo)workingCopy);
                if (targetClass == null || originalMethod == null) {
                    return;
                }
                ClassTree clazzTree = workingCopy.getTrees().getTree(targetClass);
                TreeMaker make = workingCopy.getTreeMaker();
                MethodTree newMethod = make.Method(originalMethod, null);
                GeneratorUtilities generator = GeneratorUtilities.get((WorkingCopy)workingCopy);
                ClassTree newClass = generator.insertClassMember(clazzTree, (Tree)newMethod);
                workingCopy.rewrite((Tree)clazzTree, (Tree)newClass);
            }
        };
        ClasspathInfo cpInfo = ClasspathInfo.create((FileObject)this.fileObject);
        FileObject targetFileObject = SourceUtils.getFile(this.targetClassHandle, (ClasspathInfo)cpInfo);
        JavaSource javaSource = JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[]{this.fileObject, targetFileObject});
        try {
            return this.commitAndComputeChangeInfo(targetFileObject, javaSource.runModificationTask((Task)task));
        }
        catch (IOException e) {
            EJBProblemFinder.LOG.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    private ChangeInfo commitAndComputeChangeInfo(FileObject target, ModificationResult diff) throws IOException {
        CloneableEditorSupport docToSave;
        ChangeInfo result;
        block6: {
            List differences = diff.getDifferences(target);
            result = null;
            docToSave = null;
            try {
                if (differences == null) break block6;
                for (ModificationResult.Difference d : differences) {
                    if (d.getNewText() == null) continue;
                    final PositionRef start = d.getStartPosition();
                    StyledDocument doc = start.getCloneableEditorSupport().getDocument();
                    if (doc == null) {
                        doc = start.getCloneableEditorSupport().openDocument();
                    }
                    docToSave = start.getCloneableEditorSupport();
                    final Position[] pos = new Position[1];
                    final StyledDocument fdoc = doc;
                    doc.render(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                pos[0] = NbDocument.createPosition((Document)fdoc, (int)start.getOffset(), (Position.Bias)Position.Bias.Backward);
                            }
                            catch (BadLocationException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    });
                    if (pos[0] != null) {
                        result = new ChangeInfo(target, pos[0], pos[0]);
                    }
                    break;
                }
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
        diff.commit();
        if (docToSave != null) {
            docToSave.saveDocument();
        }
        return result;
    }

    public int hashCode() {
        return 1;
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public String getText() {
        String className = JavaUtils.getShortClassName(this.targetClassHandle.getQualifiedName());
        return NbBundle.getMessage(ExposeBusinessMethod.class, (String)(this.local ? "LBL_ExposeBusinessMethodLocal" : "LBL_ExposeBusinessMethodRemote"), (Object)className);
    }
}

