/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.hints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.hints.Hinter;
import org.netbeans.modules.apisupport.project.api.LayerHandle;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.spi.editor.errorstripe.UpToDateStatus;
import org.netbeans.spi.editor.errorstripe.UpToDateStatusProvider;
import org.netbeans.spi.editor.errorstripe.UpToDateStatusProviderFactory;
import org.netbeans.spi.editor.hints.HintsController;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;
import org.openide.util.NbCollections;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.DefaultHandler;

public class LayerHints
implements UpToDateStatusProviderFactory {
    private static final RequestProcessor RP = new RequestProcessor(LayerHints.class);
    private static final Logger LOG = Logger.getLogger(LayerHints.class.getName());

    public UpToDateStatusProvider createUpToDateStatusProvider(Document doc) {
        DataObject xml;
        Object sdp = doc.getProperty("stream");
        if (sdp instanceof DataObject) {
            xml = (DataObject)sdp;
        } else if (sdp instanceof FileObject) {
            try {
                xml = DataObject.find((FileObject)((FileObject)sdp));
            }
            catch (DataObjectNotFoundException x) {
                LOG.log(Level.INFO, null, x);
                return null;
            }
        } else {
            return null;
        }
        if (xml.getPrimaryFile().getNameExt().equals("generated-layer.xml")) {
            return null;
        }
        LayerHandle handle = (LayerHandle)xml.getLookup().lookup(LayerHandle.class);
        if (handle == null) {
            return null;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)xml.getPrimaryFile());
        if (project == null || project.getLookup().lookup(NbModuleProvider.class) == null) {
            return null;
        }
        return new Prov(doc, xml, handle);
    }

    private static class Prov
    extends UpToDateStatusProvider
    implements Runnable {
        private final Document doc;
        private final DataObject xml;
        private final LayerHandle handle;
        private boolean processed;
        private final RequestProcessor.Task task;
        private final FileChangeListener listener = new FileChangeAdapter(){

            public void fileChanged(FileEvent fe) {
                Prov.this.change();
            }
        };
        private final PropertyChangeListener pcl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("modified".equals(evt.getPropertyName())) {
                    Prov.this.change();
                }
            }
        };

        private void change() {
            this.processed = false;
            this.task.schedule(0);
            this.firePropertyChange("upToDate", null, null);
        }

        Prov(Document doc, DataObject xml, LayerHandle handle) {
            this.doc = doc;
            this.xml = xml;
            this.handle = handle;
            xml.getPrimaryFile().addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this.listener, (Object)xml.getPrimaryFile()));
            xml.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.pcl, (Object)xml));
            this.task = RP.post((Runnable)this);
        }

        public UpToDateStatus getUpToDate() {
            if (this.processed) {
                return UpToDateStatus.UP_TO_DATE_OK;
            }
            return this.processed ? UpToDateStatus.UP_TO_DATE_OK : UpToDateStatus.UP_TO_DATE_PROCESSING;
        }

        private void cancelAll() {
            HintsController.setErrors((Document)this.doc, (String)LayerHints.class.getName(), Collections.emptyList());
            this.processed = true;
            this.firePropertyChange("upToDate", null, null);
        }

        @Override
        public void run() {
            URL layerURL;
            if (this.xml.isModified()) {
                this.cancelAll();
                return;
            }
            FileSystem fs = this.handle.layer(false);
            if (fs == null) {
                this.cancelAll();
                return;
            }
            try {
                layerURL = this.handle.getLayerFile().getURL();
            }
            catch (FileStateInvalidException x) {
                LOG.log(Level.INFO, null, x);
                this.cancelAll();
                return;
            }
            String expectedLayers = "[" + layerURL + "]";
            ArrayList errors = new ArrayList();
            FutureTask<Map<String, Integer>> linesFuture = new FutureTask<Map<String, Integer>>(new Callable<Map<String, Integer>>(){

                @Override
                public Map<String, Integer> call() throws Exception {
                    final HashMap<String, Integer> lines = new HashMap<String, Integer>();
                    InputSource in = new InputSource(layerURL.toExternalForm());
                    LOG.log(Level.FINE, "parsing {0}", layerURL);
                    SAXParserFactory factory = SAXParserFactory.newInstance();
                    SAXParser parser = factory.newSAXParser();
                    class Handler
                    extends DefaultHandler2 {
                        private Locator locator;
                        private String path;

                        Handler() {
                        }

                        @Override
                        public void setDocumentLocator(Locator l) {
                            this.locator = l;
                        }

                        @Override
                        public void startElement(String uri, String localname, String qname, Attributes attr) throws SAXException {
                            if (!qname.matches("file|folder")) {
                                return;
                            }
                            String n = attr.getValue("name");
                            this.path = this.path == null ? n : this.path + '/' + n;
                            lines.put(this.path, this.locator.getLineNumber());
                        }

                        @Override
                        public void endElement(String uri, String localname, String qname) throws SAXException {
                            if (!qname.matches("file|folder")) {
                                return;
                            }
                            int slash = this.path.lastIndexOf(47);
                            this.path = slash == -1 ? null : this.path.substring(0, slash);
                        }
                    }
                    Handler handler = new Handler();
                    parser.getXMLReader().setProperty("http://xml.org/sax/properties/lexical-handler", handler);
                    parser.parse(in, (DefaultHandler)handler);
                    return lines;
                }
            });
            for (FileObject file : NbCollections.iterable((Enumeration)fs.getRoot().getChildren(true))) {
                if (!expectedLayers.equals(Arrays.toString((URL[])file.getAttribute("layers")))) {
                    LOG.log(Level.FINE, "skipping {0}", file);
                    continue;
                }
                for (Hinter hinter : Lookup.getDefault().lookupAll(Hinter.class)) {
                    try {
                        hinter.process(new Hinter.Context(this.doc, this.handle, file, linesFuture, errors));
                    }
                    catch (Exception x) {
                        LOG.log(Level.WARNING, null, x);
                    }
                }
            }
            HintsController.setErrors((Document)this.doc, (String)LayerHints.class.getName(), errors);
            this.processed = true;
            this.firePropertyChange("upToDate", null, null);
        }
    }
}

