/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.cplusplus;

import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CndTokenUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.cnd.api.lexer.TokenItem;
import org.netbeans.editor.BaseDocument;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.cnd.editor.cplusplus.BracketCompletion;
import org.netbeans.modules.cnd.editor.indent.CppIndentTask;
import org.netbeans.modules.editor.indent.api.Indent;
import org.netbeans.spi.editor.typinghooks.TypedBreakInterceptor;

public class CppTBIFactory
implements TypedBreakInterceptor.Factory {
    public TypedBreakInterceptor createTypedBreakInterceptor(MimePath mimePath) {
        return new TypedBreakInterceptorImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object doWork(BaseDocument doc, int dotPos, Caret caret, TypedBreakInterceptor.MutableContext context) {
        block25: {
            if (BracketCompletion.posWithinString(doc, dotPos)) {
                try {
                    if (dotPos >= 1 && DocumentUtilities.getText((Document)doc).charAt(dotPos - 1) != '\\' || dotPos >= 2 && DocumentUtilities.getText((Document)doc).charAt(dotPos - 2) == '\\') {
                        if (context != null) {
                            context.setText("\"\n\"", 1, 3, new int[0]);
                            return true;
                        }
                        doc.insertString(dotPos, "\"\"", null);
                        caret.setDot(++dotPos);
                        return 1;
                    }
                }
                catch (BadLocationException ex) {}
            } else {
                try {
                    if (!BracketCompletion.isAddRightBrace(doc, dotPos)) break block25;
                    int end = BracketCompletion.getRowOrBlockEnd(doc, dotPos);
                    String insString = "}";
                    TokenItem firstNonWhiteBwd = CndTokenUtilities.getFirstNonWhiteBwd((Document)doc, (int)end);
                    if (firstNonWhiteBwd == null || firstNonWhiteBwd.id() != CppTokenId.LBRACE) {
                        return false;
                    }
                    int lBracePos = firstNonWhiteBwd.offset();
                    int lastSepOffset = CndTokenUtilities.getLastCommandSeparator((Document)doc, (int)(lBracePos - 1));
                    if (lastSepOffset == -1 && lBracePos > 0) {
                        lastSepOffset = 0;
                    }
                    if (lastSepOffset != -1 && lastSepOffset < dotPos) {
                        TokenSequence cppTokenSequence = CndLexerUtilities.getCppTokenSequence((Document)doc, (int)lBracePos, (boolean)false, (boolean)false);
                        block13: while (cppTokenSequence.movePrevious() && cppTokenSequence.offset() >= lastSepOffset) {
                            TokenId id = cppTokenSequence.token().id();
                            if (!(id instanceof CppTokenId)) continue;
                            switch ((CppTokenId)id) {
                                case RPAREN: 
                                case RBRACKET: {
                                    break block13;
                                }
                                case CLASS: 
                                case UNION: 
                                case STRUCT: 
                                case ENUM: {
                                    insString = "};";
                                    break block13;
                                }
                                default: {
                                    continue block13;
                                }
                            }
                        }
                    }
                    if (context != null) {
                        context.setText("\n\n" + insString, 0, 1, new int[]{2, 2 + insString.length(), 1, 2});
                    } else {
                        doc.insertString(end, "\n" + insString, null);
                        Indent indent = Indent.get((Document)doc);
                        indent.lock();
                        try {
                            indent.reindent(end + 1);
                        }
                        finally {
                            indent.unlock();
                        }
                        caret.setDot(dotPos);
                    }
                    return true;
                }
                catch (BadLocationException ex) {
                    // empty catch block
                }
            }
        }
        if (context != null) {
            try {
                if (new CppIndentTask(context).doxyGen()) {
                    return true;
                }
            }
            catch (BadLocationException ex) {
                // empty catch block
            }
        }
        return false;
    }

    private static class TypedBreakInterceptorImpl
    implements TypedBreakInterceptor {
        static final boolean DEBUG = false;
        private boolean postShift = false;

        public boolean beforeInsert(TypedBreakInterceptor.Context context) throws BadLocationException {
            return false;
        }

        public void insert(TypedBreakInterceptor.MutableContext context) throws BadLocationException {
            BaseDocument doc = (BaseDocument)context.getDocument();
            int dotPos = context.getCaretOffset();
            Caret caret = context.getComponent().getCaret();
            this.postShift = false;
            Object doWork = CppTBIFactory.doWork(doc, dotPos, caret, context);
            if (doWork instanceof Integer) {
                this.postShift = true;
            }
        }

        public void afterInsert(TypedBreakInterceptor.Context context) throws BadLocationException {
            if (this.postShift) {
                Caret caret = context.getComponent().getCaret();
                caret.setDot(context.getCaretOffset() + 1);
            }
        }

        public void cancelled(TypedBreakInterceptor.Context context) {
        }
    }
}

