/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.libs.common;

public class PathUtilities {
    private PathUtilities() {
    }

    public static String getDirName(String path) {
        int sep;
        if (path.length() > 0 && (path.charAt(path.length() - 1) == '\\' || path.charAt(path.length() - 1) == '/')) {
            path = path.substring(0, path.length() - 1);
        }
        if ((sep = path.lastIndexOf(47)) == -1) {
            sep = path.lastIndexOf(92);
        }
        if (sep != -1) {
            return path.substring(0, sep);
        }
        return null;
    }

    public static String getBaseName(String path) {
        int sep;
        if (path.length() > 0 && (path.charAt(path.length() - 1) == '\\' || path.charAt(path.length() - 1) == '/')) {
            path = path.substring(0, path.length() - 1);
        }
        if ((sep = path.lastIndexOf(47)) == -1) {
            sep = path.lastIndexOf(92);
        }
        if (sep != -1) {
            return path.substring(sep + 1);
        }
        return path;
    }

    public static String normalizeUnixPath(String absPath) {
        String norm = PathUtilities.normalize(absPath);
        if (norm.startsWith("/../")) {
            int pos = norm.lastIndexOf("/../");
            norm = norm.endsWith("/") ? norm.substring(pos + 3, norm.length() - 1) : norm.substring(pos + 3);
        } else if (norm.endsWith("/")) {
            norm = norm.substring(0, norm.length() - 1);
        }
        return norm;
    }

    private static String normalize(String ps) {
        int ns = PathUtilities.needsNormalization(ps);
        if (ns < 0) {
            return ps;
        }
        char[] path = ps.toCharArray();
        int[] segs = new int[ns];
        PathUtilities.split(path, segs);
        PathUtilities.removeDots(path, segs);
        PathUtilities.maybeAddLeadingDot(path, segs);
        String s = new String(path, 0, PathUtilities.join(path, segs));
        if (s.equals(ps)) {
            return ps;
        }
        return s;
    }

    private static int join(char[] path, int[] segs) {
        int ns = segs.length;
        int end = path.length - 1;
        int p = 0;
        if (path[p] == '\u0000') {
            path[p++] = 47;
        }
        for (int i = 0; i < ns; ++i) {
            int q = segs[i];
            if (q == -1) continue;
            if (p == q) {
                while (p <= end && path[p] != '\u0000') {
                    ++p;
                }
                if (p > end) continue;
                path[p++] = 47;
                continue;
            }
            if (p < q) {
                while (q <= end && path[q] != '\u0000') {
                    path[p++] = path[q++];
                }
                if (q > end) continue;
                path[p++] = 47;
                continue;
            }
            throw new InternalError();
        }
        return p;
    }

    private static void maybeAddLeadingDot(char[] path, int[] segs) {
        int p;
        int f;
        if (path[0] == '\u0000') {
            return;
        }
        int ns = segs.length;
        for (f = 0; f < ns && segs[f] < 0; ++f) {
        }
        if (f >= ns || f == 0) {
            return;
        }
        for (p = segs[f]; p < path.length && path[p] != ':' && path[p] != '\u0000'; ++p) {
        }
        if (p >= path.length || path[p] == '\u0000') {
            return;
        }
        path[0] = 46;
        path[1] = '\u0000';
        segs[0] = 0;
    }

    private static void removeDots(char[] path, int[] segs) {
        int ns = segs.length;
        int end = path.length - 1;
        for (int i = 0; i < ns; ++i) {
            int q;
            int j;
            int dots = 0;
            do {
                int p;
                if (path[p = segs[i]] != '.') continue;
                if (p == end) {
                    dots = 1;
                    break;
                }
                if (path[p + 1] == '\u0000') {
                    dots = 1;
                    break;
                }
                if (path[p + 1] != '.' || p + 1 != end && path[p + 2] != '\u0000') continue;
                dots = 2;
                break;
            } while (++i < ns);
            if (i > ns || dots == 0) break;
            if (dots == 1) {
                segs[i] = -1;
                continue;
            }
            for (j = i - 1; j >= 0 && segs[j] == -1; --j) {
            }
            if (j < 0 || path[q = segs[j]] == '.' && path[q + 1] == '.' && path[q + 2] == '\u0000') continue;
            segs[i] = -1;
            segs[j] = -1;
        }
    }

    private static void split(char[] path, int[] segs) {
        int p;
        int end = path.length - 1;
        int i = 0;
        for (p = 0; p <= end && path[p] == '/'; ++p) {
            path[p] = '\u0000';
        }
        block1: while (p <= end) {
            segs[i++] = p++;
            while (p <= end) {
                if (path[p++] != '/') continue;
                path[p - 1] = '\u0000';
                while (p <= end && path[p] == '/') {
                    path[p++] = '\u0000';
                }
                continue block1;
            }
        }
        if (i != segs.length) {
            throw new InternalError();
        }
    }

    private static int needsNormalization(String path) {
        int p;
        boolean normal = true;
        int ns = 0;
        int end = path.length() - 1;
        for (p = 0; p <= end && path.charAt(p) == '/'; ++p) {
        }
        if (p > 1) {
            normal = false;
        }
        block1: while (p <= end) {
            if (path.charAt(p) == '.' && (p == end || path.charAt(p + 1) == '/' || path.charAt(p + 1) == '.' && (p + 1 == end || path.charAt(p + 2) == '/'))) {
                normal = false;
            }
            ++ns;
            while (p <= end) {
                if (path.charAt(p++) != '/') continue;
                while (p <= end && path.charAt(p) == '/') {
                    normal = false;
                    ++p;
                }
                continue block1;
            }
        }
        return normal ? -1 : ns;
    }
}

