/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.updateprovider;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.autoupdate.services.AutoupdateSettings;
import org.netbeans.modules.autoupdate.updateprovider.DownloadListener;
import org.netbeans.modules.autoupdate.updateprovider.NetworkAccess;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class AutoupdateCatalogCache {
    private File cacheDir;
    private static AutoupdateCatalogCache INSTANCE;
    private static final Logger err;

    public static synchronized AutoupdateCatalogCache getDefault() {
        if (INSTANCE == null) {
            INSTANCE = new AutoupdateCatalogCache();
            INSTANCE.initCacheDirectory();
        }
        return INSTANCE;
    }

    private synchronized File getCatalogCache() {
        assert (this.cacheDir != null && this.cacheDir.exists());
        return this.cacheDir;
    }

    private void initCacheDirectory() {
        assert (this.cacheDir == null) : "Do initCacheDirectory only once!";
        String userDir = System.getProperty("netbeans.user");
        if (userDir != null) {
            this.cacheDir = new File(new File(new File(userDir, "var"), "cache"), "catalogcache");
        } else {
            File dir = FileUtil.toFile((FileObject)FileUtil.getConfigRoot());
            assert (dir != null) : "Provide netbeans.user so we know where to store catalogcache!";
            this.cacheDir = new File(dir, "catalogcache");
        }
        this.cacheDir.mkdirs();
        this.getLicenseDir().mkdirs();
        err.log(Level.FINE, "getCacheDirectory: {0}", this.cacheDir.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL writeCatalogToCache(String codeName, URL original) throws IOException {
        File cache;
        URL url;
        block8: {
            url = null;
            File dir = this.getCatalogCache();
            assert (dir != null && dir.exists()) : "Cache directory must exist.";
            cache = new File(dir, codeName);
            this.copy(original, cache, false);
            try {
                url = cache.toURI().toURL();
            }
            catch (MalformedURLException ex) {
                if ($assertionsDisabled) break block8;
                throw new AssertionError((Object)ex);
            }
        }
        String string = this.getLock(cache);
        synchronized (string) {
            assert (cache.exists()) : "Cache " + cache + " exists.";
            err.log(Level.FINER, "Cache file {0} was wrote from original URL {1}", new Object[]{cache, original});
            if (cache.exists() && cache.length() == 0L) {
                err.log(Level.INFO, "Written cache size is zero bytes");
            }
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getCatalogURL(String codeName) {
        File dir = this.getCatalogCache();
        assert (dir != null && dir.exists()) : "Cache directory must exist.";
        File cache = new File(dir, codeName);
        String string = this.getLock(cache);
        synchronized (string) {
            if (cache != null && cache.exists()) {
                URL url;
                block8: {
                    if (cache.length() == 0L) {
                        err.log(Level.INFO, "Cache file {0} exists and of zero size", cache);
                        return null;
                    }
                    url = null;
                    try {
                        url = cache.toURI().toURL();
                    }
                    catch (MalformedURLException ex) {
                        if ($assertionsDisabled) break block8;
                        throw new AssertionError((Object)ex);
                    }
                }
                return url;
            }
            return null;
        }
    }

    private File getLicenseDir() {
        return new File(this.getCatalogCache(), "licenses");
    }

    private File getLicenseFile(String name) {
        return new File(this.getLicenseDir(), name);
    }

    public String getLicense(String name) {
        return this.getLicense(name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLicense(String name, URL url) {
        File file = this.getLicenseFile(name);
        String string = name.intern();
        synchronized (string) {
            if (!file.exists()) {
                if (url == null) {
                    return null;
                }
                try {
                    this.copy(url, file, true);
                }
                catch (IOException e) {
                    err.log(Level.INFO, "Can`t store license from " + url + " to " + file, e);
                    try {
                        if (file.exists()) {
                            file.delete();
                        }
                        file.createNewFile();
                        file.deleteOnExit();
                    }
                    catch (IOException ex) {
                        err.log(Level.INFO, "Can`t create empty license file", ex);
                    }
                }
            }
            return this.readLicenseFile(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeLicense(String name, String content) {
        File file = this.getLicenseFile(name);
        String string = name.intern();
        synchronized (string) {
            if (file.exists() || content == null) {
                return;
            }
            this.writeToFile(content, file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readLicenseFile(String name) {
        File file = this.getLicenseFile(name);
        FileInputStream fr = null;
        String string = name.intern();
        synchronized (string) {
            try {
                fr = new FileInputStream(file);
                byte[] buffer = new byte[8192];
                int n = 0;
                StringBuilder sb = new StringBuilder();
                while ((n = fr.read(buffer)) != -1) {
                    sb.append(new String(buffer, 0, n, "utf-8"));
                }
                String string2 = sb.toString();
                return string2;
            }
            catch (IOException e) {
                err.log(Level.INFO, "Can`t read license from file " + file, e);
                String string3 = null;
                return string3;
            }
            finally {
                if (fr != null) {
                    try {
                        fr.close();
                    }
                    catch (IOException e3) {
                        err.log(Level.INFO, "Can`t read close input stream for " + file, e3);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(String content, File file) {
        FileOutputStream fw = null;
        try {
            fw = new FileOutputStream(file);
            fw.write(content.getBytes("utf-8"));
        }
        catch (IOException e) {
            err.log(Level.INFO, "Can`t write to " + file, e);
        }
        finally {
            if (fw != null) {
                try {
                    fw.flush();
                    fw.close();
                }
                catch (IOException e) {
                    err.log(Level.INFO, "Can`t output stream for " + file, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(URL sourceUrl, File cache, boolean allowZeroSize) throws IOException {
        err.log(Level.FINE, "Processing URL: {0}", sourceUrl);
        String prefix = "";
        while (prefix.length() < 3) {
            prefix = prefix + cache.getName();
        }
        File temp = File.createTempFile(prefix, null, cache.getParentFile());
        temp.deleteOnExit();
        DownloadListener nwl = new DownloadListener(sourceUrl, temp, allowZeroSize);
        NetworkAccess.Task task = NetworkAccess.createNetworkAcessTask(sourceUrl, AutoupdateSettings.getOpenConnectionTimeout(), nwl);
        task.waitFinished();
        nwl.notifyException();
        String string = this.getLock(cache);
        synchronized (string) {
            this.updateCachedFile(cache, temp);
        }
    }

    public String getLock(File cache) {
        return cache.getAbsolutePath().intern();
    }

    public String getLock(URL cache) throws IOException {
        try {
            return this.getLock(new File(cache.toURI()));
        }
        catch (URISyntaxException ex) {
            throw new IOException(ex);
        }
    }

    private void updateCachedFile(File cache, File temp) {
        if (cache.exists() && !cache.delete()) {
            block8: {
                err.log(Level.INFO, "Cannot delete cache {0}", cache);
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException ie) {
                    if ($assertionsDisabled) break block8;
                    throw new AssertionError((Object)ie);
                }
            }
            cache.delete();
        }
        if (temp.length() == 0L) {
            err.log(Level.INFO, "Temp cache size is zero bytes");
        }
        if (!temp.renameTo(cache)) {
            err.log(Level.INFO, "Cannot rename temp {0} to cache {1}", new Object[]{temp, cache});
            err.log(Level.INFO, "Trying to copy {0} to cache {1}", new Object[]{temp, cache});
            try {
                FileOutputStream os = new FileOutputStream(cache);
                FileInputStream is = new FileInputStream(temp);
                FileUtil.copy((InputStream)is, (OutputStream)os);
                os.close();
                is.close();
                temp.delete();
            }
            catch (IOException ex) {
                err.log(Level.INFO, "Cannot even copy: {0}", ex.getMessage());
                err.log(Level.FINE, null, ex);
            }
        }
        if (cache.exists() && cache.length() == 0L) {
            err.log(Level.INFO, "Final cache size is zero bytes");
        }
    }

    static {
        err = Logger.getLogger(AutoupdateCatalogCache.class.getName());
    }
}

