/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.palette.items;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.web.jsf.api.palette.PaletteItem;
import org.netbeans.modules.web.jsf.palette.JSFPaletteUtilities;
import org.netbeans.modules.web.jsf.palette.items.JsfLibrariesSupport;
import org.netbeans.modules.web.jsf.palette.items.MetaDataCustomizer;
import org.netbeans.modules.web.jsfapi.api.DefaultLibraryInfo;
import org.netbeans.modules.web.jsfapi.spi.InputTextTagValueProvider;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.ActiveEditorDrop;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class MetaData
implements ActiveEditorDrop,
PaletteItem {
    private HashMap<String, String> properties = new HashMap();
    private JsfLibrariesSupport jsfLibrariesSupport;

    public boolean handleTransfer(JTextComponent targetComponent) {
        this.properties.clear();
        this.jsfLibrariesSupport = JsfLibrariesSupport.get(targetComponent);
        this.findProperties(targetComponent);
        MetaDataCustomizer customizer = new MetaDataCustomizer(this, targetComponent);
        boolean accept = customizer.showDialog();
        if (accept) {
            try {
                String body = this.createBody(targetComponent);
                JSFPaletteUtilities.insert(body, targetComponent);
                this.jsfLibrariesSupport.importLibraries(DefaultLibraryInfo.JSF_CORE);
            }
            catch (BadLocationException ble) {
                Exceptions.printStackTrace((Throwable)ble);
                accept = false;
            }
        }
        return accept;
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(MetaData.class, (String)"NAME_jsp-JsfMetadata");
    }

    @Override
    public void insert(JTextComponent component) {
        this.handleTransfer(component);
    }

    private String createBody(JTextComponent targetComponent) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('<').append(this.jsfLibrariesSupport.getLibraryPrefix(DefaultLibraryInfo.JSF_CORE)).append(":metadata>\n");
        Set<Map.Entry<String, String>> set = this.properties.entrySet();
        for (Map.Entry<String, String> entry : set) {
            stringBuffer.append("   <").append(this.jsfLibrariesSupport.getLibraryPrefix(DefaultLibraryInfo.JSF_CORE)).append(":viewParam name=\"").append(entry.getKey()).append("\" value=\"").append(entry.getValue()).append("\"/>\n");
        }
        stringBuffer.append("</").append(this.jsfLibrariesSupport.getLibraryPrefix(DefaultLibraryInfo.JSF_CORE)).append(":metadata>\n");
        return stringBuffer.toString();
    }

    public HashMap<String, String> getProperties() {
        return this.properties;
    }

    public String addProperty(String name, String value) {
        return this.properties.put(name, value);
    }

    public String removeProperty(String key) {
        return this.properties.remove(key);
    }

    private void findProperties(JTextComponent target) {
        BaseDocument doc = (BaseDocument)target.getDocument();
        DataObject dobj = NbEditorUtilities.getDataObject((Document)doc);
        if (dobj != null) {
            FileObject fobj = NbEditorUtilities.getDataObject((Document)doc).getPrimaryFile();
            this.properties.putAll(InputTextTagValueProvider.Query.getInputTextValuesMap((FileObject)fobj));
        }
    }
}

