/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.api.editor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.api.facesmodel.Application;
import org.netbeans.modules.web.jsf.api.facesmodel.ResourceBundle;
import org.netbeans.modules.web.jsf.api.metamodel.JsfModel;
import org.netbeans.modules.web.jsf.api.metamodel.JsfModelFactory;

public class JSFResourceBundlesProvider {
    private static final Logger LOGGER = Logger.getLogger(JSFResourceBundlesProvider.class.getName());

    public static List<org.netbeans.modules.web.el.spi.ResourceBundle> getResourceBundles(WebModule webModule) {
        MetadataModel<JsfModel> model = JsfModelFactory.getModel(webModule);
        if (model == null) {
            return Collections.emptyList();
        }
        try {
            return (List)model.runReadAction((MetadataModelAction)new MetadataModelAction<JsfModel, List<org.netbeans.modules.web.el.spi.ResourceBundle>>(){

                public List<org.netbeans.modules.web.el.spi.ResourceBundle> run(JsfModel metadata) throws Exception {
                    List<Application> applications = metadata.getElements(Application.class);
                    ArrayList<org.netbeans.modules.web.el.spi.ResourceBundle> result = new ArrayList<org.netbeans.modules.web.el.spi.ResourceBundle>();
                    for (Application application : applications) {
                        for (ResourceBundle bundle : application.getResourceBundles()) {
                            result.add(new org.netbeans.modules.web.el.spi.ResourceBundle(bundle.getBaseName(), bundle.getVar()));
                        }
                    }
                    return result;
                }
            });
        }
        catch (MetadataModelException ex) {
            LOGGER.log(Level.INFO, "Failed to read resource bundles for " + webModule, ex);
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, "Failed to read resource bundles for " + webModule, ex);
        }
        catch (IllegalStateException ise) {
            LOGGER.log(Level.INFO, "Failed to read resource bundles for " + webModule, ise);
        }
        return Collections.emptyList();
    }
}

