/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.swingapp.templates;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.swingapp.templates.AppProjectGenerator;
import org.netbeans.modules.swingapp.templates.ConfigureProjectPanel;
import org.netbeans.modules.swingapp.templates.ConfigureProjectVisualPanel;
import org.netbeans.modules.swingapp.templates.DisclaimerPanel;
import org.netbeans.spi.java.project.support.ui.SharableLibrariesUtils;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class NewAppWizardIterator
implements WizardDescriptor.InstantiatingIterator,
ChangeListener {
    private WizardDescriptor wizard;
    private int panelIndex;
    private WizardDescriptor.Panel[] panels;
    private String[] steps;
    private WizardDescriptor.InstantiatingIterator appShellIterator;
    private EventListenerList listenerList;
    private static final String WIZARD_PANEL_CONTENT_DATA = "WizardPanel_contentData";
    private static final String WIZARD_PANEL_CONTENT_SELECTED_INDEX = "WizardPanel_contentSelectedIndex";

    void setAppShellIterator(WizardDescriptor.InstantiatingIterator iterator) {
        if (this.appShellIterator != null) {
            this.appShellIterator.removeChangeListener((ChangeListener)this);
            this.appShellIterator.uninitialize(this.wizard);
        }
        this.appShellIterator = iterator;
        if (this.appShellIterator != null) {
            this.appShellIterator.initialize(this.wizard);
            this.appShellIterator.addChangeListener((ChangeListener)this);
        }
        if (this.panelIndex >= this.panels.length) {
            this.panelIndex = this.panels.length - 1;
        }
        this.initSteps();
        this.updateSteps();
        this.fireStateChanged();
    }

    WizardDescriptor.InstantiatingIterator getAppShellIterator() {
        return this.appShellIterator;
    }

    private void updateSteps() {
        JComponent comp = (JComponent)this.current().getComponent();
        comp.putClientProperty(WIZARD_PANEL_CONTENT_DATA, this.steps);
        comp.putClientProperty(WIZARD_PANEL_CONTENT_SELECTED_INDEX, this.panelIndex);
    }

    private void initSteps() {
        Object data;
        String[] thisSteps = new String[]{NbBundle.getMessage(DisclaimerPanel.class, (String)"DisclaimerPanel.name"), NbBundle.getMessage(ConfigureProjectVisualPanel.class, (String)"ConfigureProjectVisualPanel.name")};
        if (this.appShellIterator != null && (data = ((JComponent)this.appShellIterator.current().getComponent()).getClientProperty(WIZARD_PANEL_CONTENT_DATA)) instanceof String[]) {
            String[] appShellSteps;
            for (String s : appShellSteps = (String[])data) {
                if (s != thisSteps[0]) continue;
                this.steps = appShellSteps;
                return;
            }
            this.steps = new String[thisSteps.length + appShellSteps.length];
            System.arraycopy(thisSteps, 0, this.steps, 0, thisSteps.length);
            System.arraycopy(appShellSteps, 0, this.steps, thisSteps.length, appShellSteps.length);
            return;
        }
        this.steps = thisSteps;
    }

    public void initialize(WizardDescriptor wiz) {
        this.wizard = wiz;
        this.panelIndex = 0;
        this.panels = new WizardDescriptor.Panel[]{new DisclaimerPanel(), new ConfigureProjectPanel(this)};
        this.initSteps();
        this.updateSteps();
    }

    public String name() {
        return this.current().getComponent().getName();
    }

    public WizardDescriptor.Panel current() {
        return this.panelIndex < this.panels.length ? this.panels[this.panelIndex] : this.appShellIterator.current();
    }

    public boolean hasNext() {
        if (this.panelIndex + 1 < this.panels.length) {
            return true;
        }
        if (this.appShellIterator != null) {
            return this.panelIndex + 1 == this.panels.length ? true : this.appShellIterator.hasNext();
        }
        return false;
    }

    public boolean hasPrevious() {
        return this.panelIndex > 0;
    }

    public void nextPanel() {
        ++this.panelIndex;
        if (this.panelIndex > this.panels.length) {
            this.appShellIterator.nextPanel();
        }
        this.updateSteps();
    }

    public void previousPanel() {
        --this.panelIndex;
        if (this.panelIndex >= this.panels.length) {
            this.appShellIterator.previousPanel();
        }
        this.updateSteps();
    }

    public void addChangeListener(ChangeListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(ChangeListener.class, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        if (this.listenerList != null) {
            this.listenerList.remove(ChangeListener.class, listener);
        }
    }

    void fireStateChanged() {
        if (this.listenerList == null) {
            return;
        }
        ChangeEvent e = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (e == null) {
                e = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(e);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.fireStateChanged();
    }

    public Set instantiate() throws IOException {
        String librariesLocation;
        File tempProjectDirectory = (File)this.wizard.getProperty("projdir");
        if (tempProjectDirectory == null) {
            return null;
        }
        final File projectDirectory = FileUtil.normalizeFile((File)tempProjectDirectory);
        FileObject template = (FileObject)this.wizard.getProperty("appshell");
        String[] templateNames = NewAppWizardIterator.getTemplateNames(template);
        String projectName = projectDirectory.getName();
        String appClassName = (String)this.wizard.getProperty("appname");
        String[] substNames = NewAppWizardIterator.getSubstituteNames(projectName, appClassName);
        FileObject projectFolderFO = AppProjectGenerator.createProjectFromTemplate(template, projectDirectory, templateNames, substNames);
        this.generatePrivateProperties(projectDirectory);
        ProjectChooser.setProjectsFolder((File)projectDirectory.getParentFile());
        FileObject appFO = AppProjectGenerator.getGeneratedFile(projectFolderFO, "src/applicationpackage/ShellApp.java", templateNames, substNames);
        final FileObject mainFormFO = AppProjectGenerator.getGeneratedFile(projectFolderFO, "src/applicationpackage/ShellView.java", templateNames, substNames);
        this.wizard.putProperty("mainForm", (Object)mainFormFO);
        LinkedHashSet<FileObject> resultSet = new LinkedHashSet<FileObject>();
        Set subResults = null;
        if (this.appShellIterator != null) {
            subResults = this.appShellIterator.instantiate();
        } else {
            Logger logger = Logger.getLogger("org.netbeans.ui.metrics.swingapp");
            LogRecord rec = new LogRecord(Level.INFO, "USG_PROJECT_CREATE_JDA");
            rec.setLoggerName(logger.getName());
            rec.setParameters(new Object[]{"JDA_APP_TYPE_BASIC"});
            logger.log(rec);
        }
        resultSet.add(projectFolderFO);
        if (appFO != null) {
            resultSet.add(appFO);
        }
        if (subResults != null) {
            resultSet.addAll(subResults);
        }
        NewAppWizardIterator.collectForms(projectFolderFO.getFileObject("src"), resultSet);
        if (mainFormFO != null) {
            resultSet.remove(mainFormFO);
            resultSet.add(mainFormFO);
        }
        SharableLibrariesUtils.setLastProjectSharable(((librariesLocation = (String)this.wizard.getProperty("sharedLibraries")) != null ? 1 : 0) != 0);
        if (librariesLocation != null) {
            if (!librariesLocation.endsWith(File.separator)) {
                librariesLocation = librariesLocation + File.separatorChar;
            }
            librariesLocation = librariesLocation + "nblibraries.properties";
            Project prj = FileOwnerQuery.getOwner((FileObject)mainFormFO);
            if (prj == null) {
                final String finalLibrariesLocation = librariesLocation;
                OpenProjects.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        for (Project p : OpenProjects.getDefault().getOpenProjects()) {
                            File dir = FileUtil.toFile((FileObject)p.getProjectDirectory());
                            if (!projectDirectory.equals(dir)) continue;
                            NewAppWizardIterator.enableShareableLibraries(finalLibrariesLocation, FileOwnerQuery.getOwner((FileObject)mainFormFO));
                            break;
                        }
                        OpenProjects.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
                    }
                });
            } else {
                NewAppWizardIterator.enableShareableLibraries(librariesLocation, prj);
            }
        }
        return resultSet;
    }

    private static void enableShareableLibraries(String librariesLocation, Project project) {
        try {
            FileObject projectDirectory = project.getProjectDirectory();
            Method method = project.getClass().getMethod("getAntProjectHelper", new Class[0]);
            AntProjectHelper antHelper = (AntProjectHelper)method.invoke((Object)project, new Object[0]);
            method = project.getClass().getMethod("getReferenceHelper", new Class[0]);
            ReferenceHelper refHelper = (ReferenceHelper)method.invoke((Object)project, new Object[0]);
            antHelper.setLibrariesLocation(librariesLocation);
            NewAppWizardIterator.copyRequiredLibraries(antHelper, refHelper, projectDirectory);
            ProjectManager.getDefault().saveProject(project);
        }
        catch (NoSuchMethodException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (SecurityException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static void copyRequiredLibraries(AntProjectHelper h, ReferenceHelper rh, FileObject projectFolder) throws IOException {
        FileObject fob = projectFolder.getFileObject("src");
        if (fob == null) {
            throw new IOException("No src dir");
        }
        ClassPath execCP = ClassPath.getClassPath((FileObject)fob, (String)"classpath/execute");
        if (execCP == null) {
            throw new IOException("No exec CP for " + fob);
        }
        FileObject[] roots = execCP.getRoots();
        List<FileObject> classpath = Arrays.asList(roots);
        LinkedList<String> libs = new LinkedList<String>();
        for (Library library : LibraryManager.getDefault().getLibraries()) {
            List urls = library.getContent("classpath");
            if (urls.size() <= 0) continue;
            boolean contained = true;
            for (URL url : urls) {
                if (classpath.contains(URLMapper.findFileObject((URL)url))) continue;
                contained = false;
                break;
            }
            if (!contained) continue;
            libs.add(library.getName());
        }
        libs.add("CopyLibs");
        for (String libName : libs) {
            if (rh.getProjectLibraryManager().getLibrary(libName) != null) continue;
            rh.copyLibrary(LibraryManager.getDefault().getLibrary(libName));
        }
    }

    private static void collectForms(FileObject folder, Set<FileObject> set) {
        if (folder == null || !folder.isFolder()) {
            return;
        }
        for (FileObject file : folder.getChildren()) {
            if (file.isFolder()) {
                NewAppWizardIterator.collectForms(file, set);
            }
            if (!file.getExt().equalsIgnoreCase("java") || !file.existsExt("form")) continue;
            try {
                file.setAttribute("justCreatedByNewWizard", (Object)Boolean.TRUE);
                set.add(file);
            }
            catch (IOException ex) {
                Logger.getLogger(NewAppWizardIterator.class.getName()).log(Level.WARNING, null, ex);
            }
        }
    }

    public void uninitialize(WizardDescriptor wiz) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generatePrivateProperties(File projectLocation) throws IOException {
        FileObject prjLoc = FileUtil.toFileObject((File)projectLocation);
        String[] nameElements = "nbproject/private/private.properties".split("/");
        FileObject fo = prjLoc;
        for (int i = 0; i < nameElements.length - 1; ++i) {
            FileObject tmp = fo.getFileObject(nameElements[i]);
            if (tmp == null) {
                tmp = fo.createFolder(nameElements[i]);
            }
            fo = tmp;
        }
        fo = fo.createData(nameElements[nameElements.length - 1]);
        Properties p = new Properties();
        p.put("compile.on.save", "true");
        FileOutputStream out = new FileOutputStream(FileUtil.toFile((FileObject)fo));
        try {
            p.store(out, null);
        }
        finally {
            ((OutputStream)out).close();
        }
    }

    private static String[] getTemplateNames(FileObject template) {
        return new String[]{template.getName(), "applicationpackage", "ShellApp", "ShellView", "ShellAboutBox", "UTF-\\u0038"};
    }

    private static String[] getSubstituteNames(String projectName, String appClassName) {
        String appSuffix;
        int i = appClassName.lastIndexOf(46);
        String packageName = appClassName.substring(0, i);
        if (!(appClassName = appClassName.substring(i + 1)).endsWith(appSuffix = "Application") && !appClassName.endsWith(appSuffix = "App")) {
            appSuffix = null;
        }
        String appPrefix = appSuffix != null ? appClassName.substring(0, appClassName.length() - appSuffix.length()) : appClassName;
        return new String[]{projectName, packageName, appClassName, appPrefix + "View", appPrefix + "AboutBox", FileEncodingQuery.getDefaultEncoding().name()};
    }
}

