/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.facelets;

import com.sun.faces.config.DocumentInfo;
import com.sun.faces.spi.ConfigurationResourceProvider;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.web.jsf.editor.JsfSupportImpl;
import org.netbeans.modules.web.jsf.editor.facelets.AbstractFaceletsLibrary;
import org.netbeans.modules.web.jsf.editor.facelets.CompositeComponentLibrary;
import org.netbeans.modules.web.jsf.editor.facelets.DefaultFaceletLibraries;
import org.netbeans.modules.web.jsf.editor.facelets.PureCompositeComponentLibrary;
import org.netbeans.modules.web.jsf.editor.facelets.WebFaceletTaglibResourceProvider;
import org.netbeans.modules.web.jsf.editor.facelets.mojarra.ConfigManager;
import org.netbeans.modules.web.jsf.editor.facelets.mojarra.FaceletsTaglibConfigProcessor;
import org.netbeans.modules.web.jsf.editor.index.IndexedFile;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class FaceletsLibrarySupport {
    private JsfSupportImpl jsfSupport;
    private Map<String, AbstractFaceletsLibrary> faceletsLibraries;
    private long libraries_hash;
    private static final Logger LOGGER = Logger.getLogger(FaceletsLibrarySupport.class.getSimpleName());
    private FileChangeListener DDLISTENER = new FileChangeAdapter(){

        public void fileChanged(FileEvent fileEvent) {
            FaceletsLibrarySupport.this.invalidateLibrariesCache();
        }
    };
    private static final String DD_FILE_NAME = "web.xml";

    public FaceletsLibrarySupport(JsfSupportImpl jsfSupportImpl) {
        FileObject fileObject;
        this.jsfSupport = jsfSupportImpl;
        FileObject fileObject2 = this.jsfSupport.getWebModule().getDeploymentDescriptor();
        if (fileObject2 != null) {
            fileObject2.addFileChangeListener(this.DDLISTENER);
        }
        if ((fileObject = this.jsfSupport.getWebModule().getWebInf()) != null) {
            fileObject.addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

                public void fileDataCreated(FileEvent fileEvent) {
                    FileObject fileObject = fileEvent.getFile();
                    if (fileObject.getNameExt().equalsIgnoreCase(FaceletsLibrarySupport.DD_FILE_NAME)) {
                        fileObject.addFileChangeListener(FaceletsLibrarySupport.this.DDLISTENER);
                    }
                }

                public void fileDeleted(FileEvent fileEvent) {
                    FileObject fileObject = fileEvent.getFile();
                    if (fileObject.getNameExt().equalsIgnoreCase(FaceletsLibrarySupport.DD_FILE_NAME)) {
                        fileObject.removeFileChangeListener(FaceletsLibrarySupport.this.DDLISTENER);
                    }
                }
            });
        }
    }

    public JsfSupportImpl getJsfSupport() {
        return this.jsfSupport;
    }

    private synchronized void invalidateLibrariesCache() {
        this.faceletsLibraries = null;
    }

    public synchronized Map<String, AbstractFaceletsLibrary> getLibraries() {
        this.checkLibraryDescriptorsUpToDate();
        if (this.faceletsLibraries == null) {
            this.faceletsLibraries = this.findLibraries();
            if (this.faceletsLibraries == null) {
                return Collections.emptyMap();
            }
            this.updateCompositeLibraries(this.faceletsLibraries);
        }
        return this.faceletsLibraries;
    }

    private void checkLibraryDescriptorsUpToDate() {
        long l = 7L;
        for (IndexedFile object : this.getJsfSupport().getIndex().getAllFaceletsLibraryDescriptors()) {
            long l2 = object.getTimestamp();
            l = 79L * l + l2;
        }
        for (String string : this.getJsfSupport().getIndex().getAllCompositeLibraryNames()) {
            l = 79L * l + (long)string.hashCode();
        }
        if (l != this.libraries_hash) {
            LOGGER.info("Invalidating facelets libraries due to a library descriptor change.");
            this.invalidateLibrariesCache();
            this.libraries_hash = l;
        }
    }

    private void updateCompositeLibraries(Map<String, AbstractFaceletsLibrary> map) {
        CompositeComponentLibrary compositeComponentLibrary;
        ArrayList<String> arrayList = new ArrayList<String>(this.jsfSupport.getIndex().getAllCompositeLibraryNames());
        HashMap<String, CompositeComponentLibrary> hashMap = new HashMap<String, CompositeComponentLibrary>();
        for (AbstractFaceletsLibrary object : map.values()) {
            if (!(object instanceof CompositeComponentLibrary)) continue;
            compositeComponentLibrary = (CompositeComponentLibrary)object;
            hashMap.put(compositeComponentLibrary.getDefaultNamespace(), compositeComponentLibrary);
            String string = compositeComponentLibrary.getLibraryName();
            arrayList.remove(string);
        }
        map.putAll(hashMap);
        for (String string : arrayList) {
            compositeComponentLibrary = new PureCompositeComponentLibrary(this, string);
            map.put(compositeComponentLibrary.getDefaultNamespace(), compositeComponentLibrary);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, AbstractFaceletsLibrary> findLibraries() {
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(FaceletsLibrarySupport.class, (String)"MSG_ParsingFaceletsLibraries"));
        progressHandle.start();
        progressHandle.switchToIndeterminate();
        try {
            Map<String, AbstractFaceletsLibrary> map = this._findLibraries();
            return map;
        }
        finally {
            progressHandle.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, AbstractFaceletsLibrary> _findLibraries() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        LOGGER.log(Level.FINE, "Scanning facelets libraries, current classloader class={0}, the used URLClassLoader will also contain following roots:", classLoader.getClass().getName());
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (FileObject fileObject : this.getJsfSupport().getClassPath().getRoots()) {
            try {
                String fileStateInvalidException = fileObject.getFileSystem().getDisplayName();
                if (!fileStateInvalidException.endsWith("jsf-impl.jar") && !fileStateInvalidException.endsWith("jsf-api.jar")) {
                    arrayList.add(URLMapper.findURL((FileObject)fileObject, (int)0));
                    LOGGER.log(Level.FINE, "+++{0}", fileObject);
                    continue;
                }
                LOGGER.log(Level.FINE, "---{0}", fileObject);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                Exceptions.printStackTrace((Throwable)fileStateInvalidException);
            }
        }
        URLClassLoader uRLClassLoader = new URLClassLoader(arrayList.toArray(new URL[0]), classLoader){

            @Override
            public URL findResource(String string) {
                return string.startsWith("META-INF/services") ? null : super.findResource(string);
            }

            @Override
            public Enumeration<URL> findResources(String string) throws IOException {
                if (string.startsWith("META-INF/services")) {
                    return Collections.enumeration(Collections.emptyList());
                }
                return super.findResources(string);
            }
        };
        ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(uRLClassLoader);
            Map<String, AbstractFaceletsLibrary> map = this.parseLibraries();
            return map;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader2);
        }
    }

    private Map<String, AbstractFaceletsLibrary> parseLibraries() {
        Object object;
        ArrayList<ConfigurationResourceProvider> arrayList = new ArrayList<ConfigurationResourceProvider>();
        arrayList.add(new WebFaceletTaglibResourceProvider(this.getJsfSupport().getWebModule()));
        final ArrayList<URI> arrayList2 = new ArrayList<URI>();
        for (IndexedFile object22 : this.getJsfSupport().getIndex().getAllFaceletsLibraryDescriptors()) {
            try {
                arrayList2.add(URLMapper.findURL((FileObject)object22.getFile(), (int)1).toURI());
            }
            catch (URISyntaxException documentInfoArray) {
                LOGGER.log(Level.INFO, null, documentInfoArray);
            }
        }
        arrayList.add(new ConfigurationResourceProvider(){

            public Collection<URI> getResources(ServletContext servletContext) {
                return arrayList2;
            }
        });
        Collection<FileObject> collection = DefaultFaceletLibraries.getInstance().getLibrariesDescriptorsFiles();
        final ArrayList<URI> arrayList3 = new ArrayList<URI>();
        DocumentInfo[] documentInfoArray = collection.iterator();
        while (documentInfoArray.hasNext()) {
            object = (FileObject)documentInfoArray.next();
            try {
                arrayList3.add(object.getURL().toURI());
            }
            catch (FileStateInvalidException uRISyntaxException) {
                LOGGER.log(Level.INFO, null, uRISyntaxException);
            }
            catch (URISyntaxException uRISyntaxException) {
                LOGGER.log(Level.INFO, null, uRISyntaxException);
            }
        }
        arrayList.add(new ConfigurationResourceProvider(){

            public Collection<URI> getResources(ServletContext servletContext) {
                return arrayList3;
            }
        });
        documentInfoArray = ConfigManager.getConfigDocuments(null, arrayList, null, true);
        if (documentInfoArray == null) {
            return null;
        }
        object = new FaceletsTaglibConfigProcessor(this);
        ((FaceletsTaglibConfigProcessor)((Object)object)).process(null, documentInfoArray);
        HashMap<String, AbstractFaceletsLibrary> fileStateInvalidException = new HashMap<String, AbstractFaceletsLibrary>();
        for (AbstractFaceletsLibrary abstractFaceletsLibrary : ((FaceletsTaglibConfigProcessor)((Object)object)).compiler.libraries) {
            fileStateInvalidException.put(abstractFaceletsLibrary.getNamespace(), abstractFaceletsLibrary);
        }
        return fileStateInvalidException;
    }

    public static class Compiler {
        private Collection<AbstractFaceletsLibrary> libraries = new HashSet<AbstractFaceletsLibrary>();

        public void addTagLibrary(AbstractFaceletsLibrary abstractFaceletsLibrary) {
            this.libraries.add(abstractFaceletsLibrary);
        }
    }
}

