/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.completion;

import java.net.URL;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.ext.html.parser.spi.DefaultHelpItem;
import org.netbeans.editor.ext.html.parser.spi.HelpItem;
import org.netbeans.editor.ext.html.parser.spi.HelpResolver;
import org.netbeans.modules.html.editor.api.completion.HtmlCompletionItem;
import org.netbeans.modules.web.jsf.editor.completion.JsfDocumentation;
import org.netbeans.modules.web.jsf.editor.facelets.AbstractFaceletsLibrary;
import org.netbeans.modules.web.jsfapi.api.Attribute;
import org.netbeans.modules.web.jsfapi.api.Library;
import org.netbeans.modules.web.jsfapi.api.Tag;
import org.netbeans.modules.web.jsfapi.spi.LibraryUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.NbBundle;

public class JsfCompletionItem {
    private static final int JSF_DEFAULT_SORT_PRIORITY = 5;

    public static JsfTag createTag(int substitutionOffset, AbstractFaceletsLibrary.NamedComponent component, String declaredPrefix, boolean autoimport) {
        return new JsfTag(substitutionOffset, component, declaredPrefix, autoimport);
    }

    public static JsfTagAttribute createAttribute(String name, int substitutionOffset, AbstractFaceletsLibrary library, Tag tag, Attribute attr) {
        return new JsfTagAttribute(name, substitutionOffset, library, tag, attr);
    }

    private static String getLibraryHelpHeader(AbstractFaceletsLibrary library) {
        StringBuilder sb = new StringBuilder();
        sb.append("<div><b>Library:</b> ");
        sb.append(library.getNamespace());
        if (library.getDisplayName() != null) {
            sb.append(" (");
            sb.append(library.getDisplayName());
            sb.append(")</div>");
        }
        return sb.toString();
    }

    public static class JsfTagAttribute
    extends HtmlCompletionItem.Attribute {
        private AbstractFaceletsLibrary library;
        private Tag tag;
        private Attribute attr;

        public JsfTagAttribute(String value, int offset, AbstractFaceletsLibrary library, Tag tag, Attribute attr) {
            super(value, offset, attr.isRequired(), null);
            this.library = library;
            this.tag = tag;
            this.attr = attr;
        }

        private String getHelpContent() {
            StringBuilder sb = new StringBuilder();
            sb.append(JsfCompletionItem.getLibraryHelpHeader(this.library));
            sb.append("<div><b>Tag:</b> ");
            sb.append(this.tag.getName());
            sb.append("</div>");
            sb.append("<h1>");
            sb.append(this.attr.getName());
            sb.append("</h1>");
            if (this.attr.isRequired()) {
                sb.append("<p>");
                sb.append(NbBundle.getMessage(JsfCompletionItem.class, (String)"MSG_RequiredAttribute"));
                sb.append("</p>");
            }
            sb.append("<p>");
            if (this.attr.getDescription() != null) {
                sb.append(this.attr.getDescription());
            } else {
                sb.append(NbBundle.getMessage(JsfCompletionItem.class, (String)"MSG_NoAttributeDescription"));
            }
            sb.append("</p>");
            return sb.toString();
        }

        public boolean hasHelp() {
            return this.attr.getDescription() != null;
        }

        public HelpItem getHelpItem() {
            return new DefaultHelpItem(null, (HelpResolver)JsfDocumentation.getDefault(), null, this.getHelpContent());
        }
    }

    public static class JsfTag
    extends HtmlCompletionItem.Tag {
        private static final String BOLD_OPEN_TAG = "<b>";
        private static final String BOLD_END_TAG = "</b>";
        private AbstractFaceletsLibrary.NamedComponent component;
        private boolean autoimport;

        public JsfTag(int substitutionOffset, AbstractFaceletsLibrary.NamedComponent component, String declaredPrefix, boolean autoimport) {
            super(JsfTag.generateItemText(component, declaredPrefix), substitutionOffset, null, true);
            this.component = component;
            this.autoimport = autoimport;
        }

        private static String generateItemText(AbstractFaceletsLibrary.NamedComponent component, String declaredPrefix) {
            String libraryPrefix = component.getLibrary().getDefaultPrefix();
            return (declaredPrefix != null ? declaredPrefix : libraryPrefix) + ":" + component.getName();
        }

        protected String getRightHtmlText() {
            return this.component.getLibrary().getDisplayName();
        }

        public void defaultAction(JTextComponent component) {
            super.defaultAction(component);
            if (this.autoimport) {
                this.autoimportLibrary(component);
            }
        }

        private void autoimportLibrary(JTextComponent component) {
            BaseDocument doc = (BaseDocument)component.getDocument();
            AbstractFaceletsLibrary lib = this.component.getLibrary();
            LibraryUtils.importLibrary((Document)doc, (Library)lib, null);
        }

        protected String getLeftHtmlText() {
            StringBuilder buff = new StringBuilder();
            buff.append(BOLD_OPEN_TAG);
            buff.append(super.getLeftHtmlText());
            buff.append(BOLD_END_TAG);
            return buff.toString();
        }

        public int getSortPriority() {
            return 5;
        }

        private String getHelpContent() {
            Tag tag;
            FileObject fo;
            URL url;
            StringBuilder sb = new StringBuilder();
            sb.append(JsfCompletionItem.getLibraryHelpHeader(this.component.getLibrary()));
            sb.append("<h1>");
            sb.append(this.component.getName());
            sb.append("</h1>");
            if (Boolean.getBoolean("show-facelets-libraries-locations") && (url = this.component.getLibrary().getLibraryDescriptorSource()) != null && (fo = URLMapper.findFileObject((URL)url)) != null) {
                sb.append("<div style=\"font-size: smaller; color: gray;\">");
                sb.append("Source: ");
                sb.append(FileUtil.getFileDisplayName((FileObject)fo));
                sb.append("</div>");
            }
            if ((tag = this.component.getTag()) != null) {
                String descr = tag.getDescription();
                if (descr == null) {
                    sb.append(NbBundle.getBundle(((Object)((Object)this)).getClass()).getString("MSG_NO_TLD_ITEM_DESCR"));
                } else {
                    sb.append(descr);
                }
            } else {
                sb.append("<table border=\"1\">");
                for (String[] descr : this.component.getDescription()) {
                    sb.append("<tr>");
                    sb.append("<td>");
                    sb.append("<div style=\"font-weight: bold\">");
                    sb.append(descr[0]);
                    sb.append("</div>");
                    sb.append("</td>");
                    sb.append("<td>");
                    sb.append(descr[1]);
                    sb.append("</td>");
                    sb.append("</tr>");
                }
                sb.append("</table>");
            }
            return sb.toString();
        }

        public boolean hasHelp() {
            return true;
        }

        public HelpItem getHelpItem() {
            return new DefaultHelpItem(null, (HelpResolver)JsfDocumentation.getDefault(), null, this.getHelpContent());
        }
    }
}

