/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.beans.api.model.ModelUnit;
import org.netbeans.modules.web.beans.api.model.WebBeansModel;
import org.netbeans.modules.web.beans.api.model.WebBeansModelFactory;
import org.netbeans.modules.web.beans.api.model.support.WebBeansModelSupport;
import org.netbeans.modules.web.jsf.editor.JsfHtmlExtension;
import org.netbeans.modules.web.jsf.editor.facelets.AbstractFaceletsLibrary;
import org.netbeans.modules.web.jsf.editor.facelets.FaceletsLibrarySupport;
import org.netbeans.modules.web.jsf.editor.index.JsfIndex;
import org.netbeans.modules.web.jsfapi.api.JsfSupport;
import org.netbeans.modules.web.jsfapi.api.Library;
import org.netbeans.modules.web.jsfapi.spi.JsfSupportProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class JsfSupportImpl
implements JsfSupport {
    private FaceletsLibrarySupport faceletsLibrarySupport;
    private Project project;
    private WebModule wm;
    private ClassPath classpath;
    private JsfIndex index;
    private MetadataModel<WebBeansModel> webBeansModel;
    private Lookup lookup;

    public static JsfSupportImpl findFor(Source source) {
        return JsfSupportImpl.getOwnImplementation(JsfSupportProvider.get((Source)source));
    }

    public static JsfSupportImpl findFor(FileObject file) {
        return JsfSupportImpl.getOwnImplementation(JsfSupportProvider.get((FileObject)file));
    }

    private static JsfSupportImpl getOwnImplementation(JsfSupport instance) {
        if (instance instanceof JsfSupportImpl) {
            return (JsfSupportImpl)instance;
        }
        return null;
    }

    static JsfSupportImpl findForProject(Project project) {
        WebModule wm = WebModule.getWebModule((FileObject)project.getProjectDirectory());
        if (wm == null) {
            return null;
        }
        ClassPath classPath = ClassPath.getClassPath((FileObject)wm.getDocumentBase(), (String)"classpath/compile");
        if (classPath == null) {
            return null;
        }
        return new JsfSupportImpl(project, wm, classPath);
    }

    private JsfSupportImpl(Project project, WebModule wm, ClassPath classPath) {
        this.project = project;
        this.wm = wm;
        this.classpath = classPath;
        this.faceletsLibrarySupport = new FaceletsLibrarySupport(this);
        this.classpath.addPropertyChangeListener(new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JsfSupportImpl jsfSupportImpl = JsfSupportImpl.this;
                synchronized (jsfSupportImpl) {
                    JsfSupportImpl.this.index = null;
                }
            }
        });
        JsfHtmlExtension.activate();
        ModelUnit modelUnit = WebBeansModelSupport.getModelUnit((WebModule)wm);
        this.webBeansModel = WebBeansModelFactory.getMetaModel((ModelUnit)modelUnit);
        InstanceContent ic = new InstanceContent();
        ic.add(this.webBeansModel);
        this.lookup = new AbstractLookup((AbstractLookup.Content)ic);
    }

    public Project getProject() {
        return this.project;
    }

    public ClassPath getClassPath() {
        return this.classpath;
    }

    public WebModule getWebModule() {
        return this.wm;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public Library getLibrary(String namespace) {
        return this.faceletsLibrarySupport.getLibraries().get(namespace);
    }

    public Map<String, AbstractFaceletsLibrary> getLibraries() {
        return this.faceletsLibrarySupport.getLibraries();
    }

    public synchronized JsfIndex getIndex() {
        if (this.index == null) {
            this.index = JsfIndex.create(this.wm);
        }
        return this.index;
    }

    public FaceletsLibrarySupport getFaceletsLibrarySupport() {
        return this.faceletsLibrarySupport;
    }

    public synchronized MetadataModel<WebBeansModel> getWebBeansModel() {
        return this.webBeansModel;
    }

    public String toString() {
        return String.format("JsfSupportImpl[%s]", this.wm.getDocumentBase().toString());
    }
}

