/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbjar.project.ui;

import java.awt.Image;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.netbeans.api.project.Project;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.openide.actions.FileSystemAction;
import org.openide.actions.FindAction;
import org.openide.actions.PasteAction;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.ChangeableDataFilter;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public class ServerResourceNode
extends FilterNode {
    private static final Logger LOGGER = Logger.getLogger(ServerResourceNode.class.getName());
    private static final boolean LOG = LOGGER.isLoggable(Level.FINE);
    private static final String SETUP_DIR = "setup";
    private static final DataFilter VISIBILITY_QUERY_FILTER = new VisibilityQueryDataFilter();
    private Project project;
    private FileChangeListener projectDirectoryListener = new ProjectDirectoryListener();

    public ServerResourceNode(Project project) throws DataObjectNotFoundException, FileStateInvalidException {
        this(ServerResourceNode.getSetupDataFolder(project), project);
    }

    private ServerResourceNode(DataFolder folderDo, Project project) throws DataObjectNotFoundException, FileStateInvalidException {
        super(ServerResourceNode.getDataFolderNode(folderDo, project), ServerResourceNode.getDataFolderNodeChildren(folderDo), Lookups.singleton((Object)DataFolder.find((FileObject)project.getProjectDirectory())));
        if (LOG) {
            LOGGER.log(Level.FINE, "Adding file listener to " + project.getProjectDirectory());
        }
        project.getProjectDirectory().addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this.projectDirectoryListener, (Object)project.getProjectDirectory()));
        this.project = project;
    }

    public Image getIcon(int type) {
        return ServerResourceNode.badgeIcon(super.getIcon(type));
    }

    public Image getOpenedIcon(int type) {
        return ServerResourceNode.badgeIcon(super.getOpenedIcon(type));
    }

    private static Image badgeIcon(Image icon) {
        return ImageUtilities.mergeImages((Image)icon, (Image)ImageUtilities.loadImage((String)"org/netbeans/modules/j2ee/ejbjar/project/ui/resourcesBadge.gif", (boolean)true), (int)7, (int)7);
    }

    public String getDisplayName() {
        return NbBundle.getMessage(ServerResourceNode.class, (String)"LBL_Node_ResourceNode");
    }

    public boolean canCopy() {
        return false;
    }

    public boolean canCut() {
        return false;
    }

    public boolean canRename() {
        return false;
    }

    public boolean canDestroy() {
        return false;
    }

    public Action[] getActions(boolean context) {
        return new Action[]{CommonProjectActions.newFileAction(), null, SystemAction.get(FileSystemAction.class), null, SystemAction.get(FindAction.class), null, SystemAction.get(PasteAction.class)};
    }

    private void refresh() {
        if (LOG) {
            LOGGER.log(Level.FINE, "Refreshing");
        }
        DataFolder folderDo = ServerResourceNode.getSetupDataFolder(this.project);
        if (LOG) {
            LOGGER.log(Level.FINE, "The DataFolder is: " + folderDo);
        }
        final Node original = ServerResourceNode.getDataFolderNode(folderDo, this.project);
        final Children children = ServerResourceNode.getDataFolderNodeChildren(folderDo);
        if (LOG) {
            LOGGER.log(Level.FINE, "New children count: " + children.getNodes(true).length);
        }
        FilterNode.Children.MUTEX.postWriteRequest(new Runnable(){

            @Override
            public void run() {
                ServerResourceNode.this.changeOriginal(original, false);
                ServerResourceNode.this.setChildren(children);
            }
        });
    }

    private static DataFolder getSetupDataFolder(Project project) {
        FileObject folderFo = project.getProjectDirectory().getFileObject(SETUP_DIR);
        DataFolder folderDo = null;
        if (folderFo != null && folderFo.isFolder()) {
            try {
                folderDo = DataFolder.findFolder((FileObject)folderFo);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return folderDo;
    }

    private static Node getDataFolderNode(DataFolder folderDo, Project project) {
        return folderDo != null ? folderDo.getNodeDelegate() : new PlaceHolderNode(Lookups.singleton((Object)project));
    }

    private static Children getDataFolderNodeChildren(DataFolder folderDo) {
        return folderDo != null ? folderDo.createNodeChildren(VISIBILITY_QUERY_FILTER) : FilterNode.Children.LEAF;
    }

    private static final class PlaceHolderNode
    extends AbstractNode {
        public PlaceHolderNode(Lookup lookup) {
            super(FilterNode.Children.LEAF, lookup);
        }

        public Image getIcon(int type) {
            Image image = null;
            Node imageDelegate = PlaceHolderNode.getImageDelegate();
            if (imageDelegate != null) {
                image = imageDelegate.getIcon(type);
            }
            if (image == null) {
                image = super.getIcon(type);
            }
            return image;
        }

        public Image getOpenedIcon(int type) {
            Image image = null;
            Node imageDelegate = PlaceHolderNode.getImageDelegate();
            if (imageDelegate != null) {
                image = imageDelegate.getOpenedIcon(type);
            }
            if (image == null) {
                image = super.getOpenedIcon(type);
            }
            return image;
        }

        private static Node getImageDelegate() {
            FileObject imageFo = FileUtil.getConfigRoot();
            if (imageFo != null) {
                try {
                    DataObject imageDo = DataObject.find((FileObject)imageFo);
                    return imageDo.getNodeDelegate();
                }
                catch (DataObjectNotFoundException donfe) {
                    Logger.getLogger("global").log(Level.INFO, null, donfe);
                }
            }
            return null;
        }
    }

    private static final class VisibilityQueryDataFilter
    implements ChangeListener,
    ChangeableDataFilter {
        private EventListenerList ell = new EventListenerList();

        public VisibilityQueryDataFilter() {
            VisibilityQuery.getDefault().addChangeListener((ChangeListener)this);
        }

        public boolean acceptDataObject(DataObject obj) {
            FileObject fo = obj.getPrimaryFile();
            return VisibilityQuery.getDefault().isVisible(fo);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Object[] listeners = this.ell.getListenerList();
            ChangeEvent event = null;
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != ChangeListener.class) continue;
                if (event == null) {
                    event = new ChangeEvent(this);
                }
                ((ChangeListener)listeners[i + 1]).stateChanged(event);
            }
        }

        public void addChangeListener(ChangeListener listener) {
            this.ell.add(ChangeListener.class, listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.ell.remove(ChangeListener.class, listener);
        }
    }

    private final class ProjectDirectoryListener
    extends FileChangeAdapter {
        private ProjectDirectoryListener() {
        }

        public void fileDeleted(FileEvent fe) {
            if (this.isWatchedFile(this.getFileName(fe))) {
                ServerResourceNode.this.refresh();
            }
        }

        public void fileFolderCreated(FileEvent fe) {
            if (this.isWatchedFile(this.getFileName(fe))) {
                ServerResourceNode.this.refresh();
            }
        }

        public void fileRenamed(FileRenameEvent fe) {
            if (this.isWatchedFile(this.getFileName((FileEvent)fe)) || this.isWatchedFile(this.getOldFileName(fe))) {
                ServerResourceNode.this.refresh();
            }
        }

        private boolean isWatchedFile(String fileName) {
            return fileName.equals(ServerResourceNode.SETUP_DIR);
        }

        private String getFileName(FileEvent fe) {
            return fe.getFile().getNameExt();
        }

        private String getOldFileName(FileRenameEvent fe) {
            String result = fe.getName();
            if (fe.getExt() != "") {
                result = result + "." + fe.getExt();
            }
            return result;
        }
    }
}

