/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.api.completion;

import groovy.lang.MetaMethod;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.reflection.CachedClass;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.csl.api.CodeCompletionContext;
import org.netbeans.modules.csl.api.CodeCompletionHandler;
import org.netbeans.modules.csl.api.CodeCompletionResult;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.ParameterInfo;
import org.netbeans.modules.csl.spi.DefaultCompletionResult;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.groovy.editor.api.AstPath;
import org.netbeans.modules.groovy.editor.api.AstUtilities;
import org.netbeans.modules.groovy.editor.api.GroovyIndex;
import org.netbeans.modules.groovy.editor.api.GroovyTypeAnalyzer;
import org.netbeans.modules.groovy.editor.api.GroovyUtils;
import org.netbeans.modules.groovy.editor.api.NbUtilities;
import org.netbeans.modules.groovy.editor.api.completion.CaretLocation;
import org.netbeans.modules.groovy.editor.api.completion.CompletionItem;
import org.netbeans.modules.groovy.editor.api.completion.FieldSignature;
import org.netbeans.modules.groovy.editor.api.completion.GroovyKeyword;
import org.netbeans.modules.groovy.editor.api.completion.HTMLJavadocParser;
import org.netbeans.modules.groovy.editor.api.completion.KeywordCategory;
import org.netbeans.modules.groovy.editor.api.completion.MethodSignature;
import org.netbeans.modules.groovy.editor.api.elements.AstMethodElement;
import org.netbeans.modules.groovy.editor.api.elements.IndexedClass;
import org.netbeans.modules.groovy.editor.api.lexer.GroovyTokenId;
import org.netbeans.modules.groovy.editor.api.lexer.LexUtilities;
import org.netbeans.modules.groovy.editor.completion.CompleteElementHandler;
import org.netbeans.modules.groovy.editor.completion.VariableFinderVisitor;
import org.netbeans.modules.groovy.support.api.GroovySettings;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class CompletionHandler
implements CodeCompletionHandler {
    private static final Logger LOG = Logger.getLogger(CompletionHandler.class.getName());
    private final PropertyChangeListener docListener;
    private int anchor;
    private String jdkJavaDocBase = null;
    private String groovyJavaDocBase = null;
    private String groovyApiDocBase = null;
    private Set<GroovyKeyword> keywords;

    public CompletionHandler() {
        JavaPlatformManager platformMan = JavaPlatformManager.getDefault();
        JavaPlatform platform = platformMan.getDefaultPlatform();
        List docfolder = platform.getJavadocFolders();
        for (URL url : docfolder) {
            LOG.log(Level.FINEST, "JDK Doc path: {0}", url.toString());
            this.jdkJavaDocBase = url.toString();
        }
        GroovySettings groovySettings = GroovySettings.getInstance();
        this.docListener = new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                CompletionHandler completionHandler = CompletionHandler.this;
                synchronized (completionHandler) {
                    CompletionHandler.this.groovyJavaDocBase = null;
                    CompletionHandler.this.groovyApiDocBase = null;
                }
            }
        };
        groovySettings.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.docListener, (Object)this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getGroovyJavadocBase() {
        CompletionHandler completionHandler = this;
        synchronized (completionHandler) {
            if (this.groovyJavaDocBase == null) {
                String docroot = GroovySettings.getInstance().getGroovyDoc() + "/";
                this.groovyJavaDocBase = CompletionHandler.directoryNameToUrl(docroot + "groovy-jdk/");
            }
            return this.groovyJavaDocBase;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getGroovyApiDocBase() {
        CompletionHandler completionHandler = this;
        synchronized (completionHandler) {
            if (this.groovyApiDocBase == null) {
                String docroot = GroovySettings.getInstance().getGroovyDoc() + "/";
                this.groovyApiDocBase = CompletionHandler.directoryNameToUrl(docroot + "gapi/");
            }
            return this.groovyApiDocBase;
        }
    }

    private static String directoryNameToUrl(String dirname) {
        if (dirname == null) {
            return "";
        }
        File dirFile = new File(dirname);
        if (dirFile != null && dirFile.exists() && dirFile.isDirectory()) {
            String fileURL = "";
            if (org.openide.util.Utilities.isWindows()) {
                dirname = dirname.replace("\\", "/");
                fileURL = "file:/";
            } else {
                fileURL = "file://";
            }
            return fileURL + dirname;
        }
        return "";
    }

    private static void printASTNodeInformation(String description, ASTNode node) {
        LOG.log(Level.FINEST, "--------------------------------------------------------");
        LOG.log(Level.FINEST, "{0}", description);
        if (node == null) {
            LOG.log(Level.FINEST, "node == null");
        } else {
            LOG.log(Level.FINEST, "Node.getText()  : " + node.getText());
            LOG.log(Level.FINEST, "Node.toString() : " + node.toString());
            LOG.log(Level.FINEST, "Node.getClass() : " + node.getClass());
            LOG.log(Level.FINEST, "Node.hashCode() : " + node.hashCode());
            if (node instanceof ModuleNode) {
                LOG.log(Level.FINEST, "ModuleNode.getClasses() : " + ((ModuleNode)node).getClasses());
                LOG.log(Level.FINEST, "SourceUnit.getName() : " + ((ModuleNode)node).getContext().getName());
            }
        }
        LOG.log(Level.FINEST, "--------------------------------------------------------");
    }

    private static void printMethod(MetaMethod mm) {
        LOG.log(Level.FINEST, "--------------------------------------------------");
        LOG.log(Level.FINEST, "getName()           : " + mm.getName());
        LOG.log(Level.FINEST, "toString()          : " + mm.toString());
        LOG.log(Level.FINEST, "getDescriptor()     : " + mm.getDescriptor());
        LOG.log(Level.FINEST, "getSignature()      : " + mm.getSignature());
        LOG.log(Level.FINEST, "getDeclaringClass() : " + mm.getDeclaringClass());
    }

    CompletionContext getCompletionContext(CompletionRequest request) {
        Token t;
        int position = request.lexOffset;
        Token beforeLiteral = null;
        Token before2 = null;
        Token before1 = null;
        Token active = null;
        Token after1 = null;
        Token after2 = null;
        Token afterLiteral = null;
        TokenSequence<? extends GroovyTokenId> ts = LexUtilities.getGroovyTokenSequence(request.doc, position);
        int difference = 0;
        difference = ts.move(position);
        if (ts.isValid() && ts.moveNext() && ts.offset() >= 0) {
            active = ts.token();
        }
        if (active != null) {
            if (active.id() == GroovyTokenId.WHITESPACE && difference == 0) {
                LOG.log(Level.FINEST, "ts.movePrevious() - 1");
                ts.movePrevious();
            } else if (active.id() == GroovyTokenId.NLS) {
                ts.movePrevious();
                if (ts.token().id() == GroovyTokenId.DOT) {
                    ts.moveNext();
                } else {
                    LOG.log(Level.FINEST, "ts.movePrevious() - 2");
                }
            }
        }
        int stopAt = 0;
        while (ts.isValid() && ts.movePrevious() && ts.offset() >= 0 && (t = ts.token()).id() != GroovyTokenId.NLS) {
            if (t.id() == GroovyTokenId.WHITESPACE) continue;
            if (stopAt == 0) {
                before1 = t;
            } else if (stopAt == 1) {
                before2 = t;
            } else if (stopAt == 2) break;
            ++stopAt;
        }
        ts.move(position);
        while (ts.isValid() && ts.movePrevious() && ts.offset() >= 0 && (t = ts.token()).id() != GroovyTokenId.NLS && t.id() != GroovyTokenId.LBRACE) {
            if (!((GroovyTokenId)t.id()).primaryCategory().equals("keyword")) continue;
            beforeLiteral = t;
            break;
        }
        ts.move(position);
        while (ts.isValid() && ts.moveNext() && ts.offset() < request.doc.getLength() && (t = ts.token()).id() != GroovyTokenId.NLS && t.id() != GroovyTokenId.RBRACE) {
            if (!((GroovyTokenId)t.id()).primaryCategory().equals("keyword")) continue;
            afterLiteral = t;
            break;
        }
        ts.move(position);
        stopAt = 0;
        while (ts.isValid() && ts.moveNext() && ts.offset() < request.doc.getLength() && (t = ts.token()).id() != GroovyTokenId.NLS) {
            if (t.id() == GroovyTokenId.WHITESPACE) continue;
            if (stopAt == 0) {
                after1 = t;
            } else if (stopAt == 1) {
                after2 = t;
            } else if (stopAt == 2) break;
            ++stopAt;
        }
        LOG.log(Level.FINEST, "---------------------------------------------------------------");
        LOG.log(Level.FINEST, "move() diff   : {0}", difference);
        LOG.log(Level.FINEST, "beforeLiteral : {0}", beforeLiteral);
        LOG.log(Level.FINEST, "before2       : {0}", before2);
        LOG.log(Level.FINEST, "before1       : {0}", before1);
        LOG.log(Level.FINEST, "active        : {0}", active);
        LOG.log(Level.FINEST, "after1        : {0}", after1);
        LOG.log(Level.FINEST, "after2        : {0}", after2);
        LOG.log(Level.FINEST, "afterLiteral  : {0}", afterLiteral);
        return new CompletionContext((Token<? extends GroovyTokenId>)beforeLiteral, (Token<? extends GroovyTokenId>)before2, (Token<? extends GroovyTokenId>)before1, (Token<? extends GroovyTokenId>)active, (Token<? extends GroovyTokenId>)after1, (Token<? extends GroovyTokenId>)after2, (Token<? extends GroovyTokenId>)afterLiteral, ts);
    }

    boolean checkForPackageStatement(CompletionRequest request) {
        TokenSequence<? extends GroovyTokenId> ts = LexUtilities.getGroovyTokenSequence(request.doc, 1);
        if (ts != null) {
            ts.move(1);
            while (ts.isValid() && ts.moveNext() && ts.offset() < request.doc.getLength()) {
                Token t = ts.token();
                if (t.id() != GroovyTokenId.LITERAL_package) continue;
                return true;
            }
        }
        return false;
    }

    private CaretLocation getCaretLocationFromRequest(CompletionRequest request) {
        ASTNode node;
        Token t;
        int position = request.lexOffset;
        TokenSequence<? extends GroovyTokenId> ts = LexUtilities.getGroovyTokenSequence(request.doc, position);
        ts.move(position);
        if (ts.isValid() && ts.moveNext() && ts.offset() < request.doc.getLength()) {
            Token tparent;
            t = ts.token();
            if (t.id() == GroovyTokenId.LINE_COMMENT || t.id() == GroovyTokenId.BLOCK_COMMENT) {
                return CaretLocation.INSIDE_COMMENT;
            }
            if (t.id() == GroovyTokenId.STRING_LITERAL) {
                return CaretLocation.INSIDE_STRING;
            }
            if (t.id() == GroovyTokenId.NLS && ts.isValid() && ts.movePrevious() && ts.offset() >= 0 && (tparent = ts.token()).id() == GroovyTokenId.LINE_COMMENT) {
                return CaretLocation.INSIDE_COMMENT;
            }
        }
        ts.move(position);
        while (ts.isValid() && ts.moveNext() && ts.offset() < request.doc.getLength()) {
            t = ts.token();
            if (t.id() != GroovyTokenId.LITERAL_package) continue;
            return CaretLocation.ABOVE_PACKAGE;
        }
        boolean classDefBeforePosition = false;
        ts.move(position);
        while (ts.isValid() && ts.movePrevious() && ts.offset() >= 0) {
            Token t2 = ts.token();
            if (t2.id() != GroovyTokenId.LITERAL_class && t2.id() != GroovyTokenId.LITERAL_interface) continue;
            classDefBeforePosition = true;
            break;
        }
        boolean classDefAfterPosition = false;
        ts.move(position);
        while (ts.isValid() && ts.moveNext() && ts.offset() < request.doc.getLength()) {
            Token t3 = ts.token();
            if (t3.id() != GroovyTokenId.LITERAL_class && t3.id() != GroovyTokenId.LITERAL_interface) continue;
            classDefAfterPosition = true;
            break;
        }
        if (request.path != null && (node = request.path.root()) instanceof ModuleNode) {
            ModuleNode module = (ModuleNode)node;
            String name = null;
            for (ClassNode clazz : module.getClasses()) {
                if (!clazz.isScript()) continue;
                name = clazz.getName();
                request.scriptMode = true;
                break;
            }
            if (name != null) {
                for (ClassNode clazz : module.getClasses()) {
                    if (clazz.isScript() || !name.equals(clazz.getName())) continue;
                    request.scriptMode = false;
                    break;
                }
            }
        }
        if (!request.scriptMode && !classDefBeforePosition && classDefAfterPosition) {
            return CaretLocation.ABOVE_FIRST_CLASS;
        }
        if (!classDefBeforePosition && request.scriptMode) {
            return CaretLocation.INSIDE_METHOD;
        }
        if (request.path == null) {
            LOG.log(Level.FINEST, "path == null");
            return null;
        }
        for (ASTNode current : request.path) {
            if (current instanceof ClosureExpression) {
                return CaretLocation.INSIDE_CLOSURE;
            }
            if (current instanceof FieldNode) {
                FieldNode fn = (FieldNode)current;
                if (!fn.isClosureSharedVariable()) continue;
                return CaretLocation.INSIDE_CLOSURE;
            }
            if (current instanceof MethodNode) {
                return CaretLocation.INSIDE_METHOD;
            }
            if (current instanceof ClassNode) {
                return CaretLocation.INSIDE_CLASS;
            }
            if (current instanceof ModuleNode) {
                return CaretLocation.OUTSIDE_CLASSES;
            }
            if (!(current instanceof Parameter)) continue;
            return CaretLocation.INSIDE_PARAMETERS;
        }
        return CaretLocation.UNDEFINED;
    }

    private ArgumentListExpression getSurroundingArgumentList(AstPath path) {
        if (path == null) {
            LOG.log(Level.FINEST, "path == null");
            return null;
        }
        LOG.log(Level.FINEST, "AEL, Path : {0}", path);
        for (ASTNode current : path) {
            if (!(current instanceof ArgumentListExpression)) continue;
            return (ArgumentListExpression)current;
        }
        return null;
    }

    private ASTNode getSurroundingMethodOrClosure(CompletionRequest request) {
        if (request.path == null) {
            LOG.log(Level.FINEST, "path == null");
            return null;
        }
        LOG.log(Level.FINEST, "getSurroundingMethodOrClosure() ----------------------------------------");
        LOG.log(Level.FINEST, "Path : {0}", request.path);
        for (ASTNode current : request.path) {
            if (current instanceof MethodNode) {
                MethodNode mn = (MethodNode)current;
                LOG.log(Level.FINEST, "Found Method: {0}", mn.getName());
                return mn;
            }
            if (current instanceof FieldNode) {
                FieldNode fn = (FieldNode)current;
                if (!fn.isClosureSharedVariable()) continue;
                LOG.log(Level.FINEST, "Found Closure(Field): {0}", fn.getName());
                return fn;
            }
            if (!(current instanceof ClosureExpression)) continue;
            LOG.log(Level.FINEST, "Found Closure(Expr.): {0}", ((ClosureExpression)current).getText());
            return current;
        }
        return null;
    }

    private ClassNode getSurroundingClassNode(CompletionRequest request) {
        if (request.path == null) {
            LOG.log(Level.FINEST, "path == null");
            return null;
        }
        for (ASTNode current : request.path) {
            if (!(current instanceof ClassNode)) continue;
            ClassNode classNode = (ClassNode)current;
            LOG.log(Level.FINEST, "Found surrounding Class: {0}", classNode.getName());
            return classNode;
        }
        return null;
    }

    private AstPath getPathFromRequest(CompletionRequest request) {
        ModuleNode root = AstUtilities.getRoot(request.info);
        if (root == null) {
            LOG.log(Level.FINEST, "AstUtilities.getRoot(request.info) returned null.");
            LOG.log(Level.FINEST, "request.info   = {0}", request.info);
            LOG.log(Level.FINEST, "request.prefix = {0}", request.prefix);
            return null;
        }
        return new AstPath((ASTNode)root, request.astOffset, request.doc);
    }

    private AstPath getPath(ParserResult info, BaseDocument doc, int astOffset) {
        ModuleNode root = AstUtilities.getRoot(info);
        if (root == null) {
            LOG.log(Level.FINEST, "AstUtilities.getRoot(request.info) returned null.");
            LOG.log(Level.FINEST, "request.info   = {0}", info);
            return null;
        }
        return new AstPath((ASTNode)root, astOffset, doc);
    }

    private AstPath getPathFromInfo(int caretOffset, ParserResult info) {
        assert (info != null);
        ModuleNode root = AstUtilities.getRoot(info);
        if (root == null) {
            return null;
        }
        BaseDocument doc = (BaseDocument)info.getSnapshot().getSource().getDocument(true);
        return new AstPath((ASTNode)root, caretOffset, doc);
    }

    private boolean completeKeywords(List<CompletionProposal> proposals, CompletionRequest request) {
        LOG.log(Level.FINEST, "-> completeKeywords");
        String prefix = request.prefix;
        if (request.location == CaretLocation.INSIDE_PARAMETERS) {
            LOG.log(Level.FINEST, "no keywords completion inside of parameters");
            return false;
        }
        if (request.isBehindDot()) {
            LOG.log(Level.FINEST, "We are invoked right behind a dot.");
            return false;
        }
        boolean havePackage = this.checkForPackageStatement(request);
        this.keywords = EnumSet.allOf(GroovyKeyword.class);
        this.filterPackageStatement(havePackage);
        this.filterPrefix(prefix);
        this.filterLocation(request.location);
        this.filterClassInterfaceOrdering(request.ctx);
        this.filterMethodDefinitions(request.ctx);
        this.filterKeywordsNextToEachOther(request.ctx);
        for (GroovyKeyword groovyKeyword : this.keywords) {
            LOG.log(Level.FINEST, "Adding keyword proposal : {0}", groovyKeyword.name);
            proposals.add((CompletionProposal)new CompletionItem.KeywordItem(groovyKeyword.name, null, this.anchor, request.info, groovyKeyword.isGroovy));
        }
        return true;
    }

    void filterPackageStatement(boolean havePackage) {
        for (GroovyKeyword groovyKeyword : this.keywords) {
            if (!groovyKeyword.name.equals("package") || !havePackage) continue;
            this.keywords.remove((Object)groovyKeyword);
        }
    }

    void filterPrefix(String prefix) {
        for (GroovyKeyword groovyKeyword : this.keywords) {
            if (groovyKeyword.name.startsWith(prefix)) continue;
            this.keywords.remove((Object)groovyKeyword);
        }
    }

    void filterLocation(CaretLocation location) {
        for (GroovyKeyword groovyKeyword : this.keywords) {
            if (this.checkKeywordAllowance(groovyKeyword, location)) continue;
            this.keywords.remove((Object)groovyKeyword);
        }
    }

    void filterClassInterfaceOrdering(CompletionContext ctx) {
        if (ctx == null || ctx.beforeLiteral == null) {
            return;
        }
        if (ctx.beforeLiteral.id() == GroovyTokenId.LITERAL_interface) {
            this.keywords.clear();
            this.keywords.add(GroovyKeyword.KEYWORD_extends);
        } else if (ctx.beforeLiteral.id() == GroovyTokenId.LITERAL_class) {
            this.keywords.clear();
            this.keywords.add(GroovyKeyword.KEYWORD_extends);
            this.keywords.add(GroovyKeyword.KEYWORD_implements);
        }
    }

    void filterMethodDefinitions(CompletionContext ctx) {
        if (ctx == null || ctx.afterLiteral == null) {
            return;
        }
        if (ctx.afterLiteral.id() == GroovyTokenId.LITERAL_void || ctx.afterLiteral.id() == GroovyTokenId.IDENTIFIER || ((GroovyTokenId)ctx.afterLiteral.id()).primaryCategory().equals("number")) {
            for (GroovyKeyword groovyKeyword : this.keywords) {
                if (groovyKeyword.category != KeywordCategory.PRIMITIVE) continue;
                LOG.log(Level.FINEST, "filterMethodDefinitions - removing : {0}", groovyKeyword.name);
                this.keywords.remove((Object)groovyKeyword);
            }
        }
    }

    void filterKeywordsNextToEachOther(CompletionContext ctx) {
        if (ctx == null) {
            return;
        }
        boolean filter = false;
        if (ctx.after1 != null && ((GroovyTokenId)ctx.after1.id()).primaryCategory().equals("keyword")) {
            filter = true;
        }
        if (ctx.before1 != null && ((GroovyTokenId)ctx.before1.id()).primaryCategory().equals("keyword")) {
            filter = true;
        }
        if (filter) {
            for (GroovyKeyword groovyKeyword : this.keywords) {
                if (groovyKeyword.category != KeywordCategory.KEYWORD) continue;
                LOG.log(Level.FINEST, "filterMethodDefinitions - removing : {0}", groovyKeyword.name);
                this.keywords.remove((Object)groovyKeyword);
            }
        }
    }

    boolean checkKeywordAllowance(GroovyKeyword groovyKeyword, CaretLocation location) {
        if (location == null) {
            return false;
        }
        switch (location) {
            case ABOVE_FIRST_CLASS: {
                if (!groovyKeyword.aboveFistClass) break;
                return true;
            }
            case OUTSIDE_CLASSES: {
                if (!groovyKeyword.outsideClasses) break;
                return true;
            }
            case INSIDE_CLASS: {
                if (!groovyKeyword.insideClass) break;
                return true;
            }
            case INSIDE_METHOD: 
            case INSIDE_CLOSURE: {
                if (!groovyKeyword.insideCode) break;
                return true;
            }
        }
        return false;
    }

    private boolean completeNewVars(List<CompletionProposal> proposals, CompletionRequest request, List<String> newVars) {
        LOG.log(Level.FINEST, "-> completeNewVars");
        if (request.location == CaretLocation.OUTSIDE_CLASSES) {
            LOG.log(Level.FINEST, "outside of any class, bail out.");
            return false;
        }
        if (request.isBehindDot()) {
            LOG.log(Level.FINEST, "We are invoked right behind a dot.");
            return false;
        }
        if (newVars == null) {
            LOG.log(Level.FINEST, "Can not propose with newVars == null");
            return false;
        }
        boolean stuffAdded = false;
        for (String var : newVars) {
            LOG.log(Level.FINEST, "Variable candidate: {0}", var);
            if (!var.startsWith(request.prefix)) continue;
            proposals.add((CompletionProposal)new CompletionItem.NewVarItem(var, this.anchor));
            stuffAdded = true;
        }
        return stuffAdded;
    }

    private boolean completeFields(List<CompletionProposal> proposals, CompletionRequest request) {
        ClassNode declaringClass;
        LOG.log(Level.FINEST, "-> completeFields");
        if (request.location == CaretLocation.INSIDE_PARAMETERS && !request.isBehindDot()) {
            LOG.log(Level.FINEST, "no fields completion inside of parameters-list");
            return false;
        }
        if (request.dotContext != null && request.dotContext.isMethodsOnly()) {
            return false;
        }
        if (request.isBehindDot()) {
            ClasspathInfo pathInfo;
            LOG.log(Level.FINEST, "We are invoked right behind a dot.");
            PackageCompletionRequest packageRequest = this.getPackageRequest(request);
            if (packageRequest.basePackage.length() > 0 && this.isValidPackage(pathInfo = this.getClasspathInfoFromRequest(request), packageRequest.basePackage)) {
                LOG.log(Level.FINEST, "The string before the dot seems to be a valid package");
                return false;
            }
            declaringClass = this.getBeforeDotDeclaringClass(request);
            if (declaringClass == null) {
                LOG.log(Level.FINEST, "No declaring class found");
                return false;
            }
        } else {
            declaringClass = this.getSurroundingClassNode(request);
            if (declaringClass == null) {
                LOG.log(Level.FINEST, "No surrounding class found, bail out ...");
                return false;
            }
        }
        int anchorShift = 0;
        String fieldName = request.prefix;
        if (request.prefix.startsWith("$")) {
            fieldName = request.prefix.substring(1);
            anchorShift = 1;
        }
        Map<FieldSignature, ? extends CompletionItem> result = CompleteElementHandler.forCompilationInfo(request.info).getFields(this.getSurroundingClassNode(request), declaringClass, fieldName, this.anchor + anchorShift);
        proposals.addAll(result.values());
        return true;
    }

    private boolean completeLocalVars(List<CompletionProposal> proposals, CompletionRequest request) {
        LOG.log(Level.FINEST, "-> completeLocalVars");
        if (!(request.location == CaretLocation.INSIDE_CLOSURE || request.location == CaretLocation.INSIDE_METHOD || request.location == CaretLocation.INSIDE_STRING && request.prefix.matches("\\$[^\\{].*"))) {
            LOG.log(Level.FINEST, "Not inside method, closure or in-string variable, bail out.");
            return false;
        }
        if (request.isBehindDot()) {
            LOG.log(Level.FINEST, "We are invoked right behind a dot.");
            return false;
        }
        VariableFinderVisitor vis = new VariableFinderVisitor(((ModuleNode)request.path.root()).getContext(), request.path, request.doc, request.astOffset);
        vis.collect();
        boolean updated = false;
        int anchorShift = 0;
        String varPrefix = request.prefix;
        if (request.prefix.startsWith("$")) {
            varPrefix = request.prefix.substring(1);
            anchorShift = 1;
        }
        for (Variable node : vis.getVariables()) {
            String varName = node.getName();
            LOG.log(Level.FINEST, "Node found: {0}", varName);
            if (varPrefix.length() < 1) {
                proposals.add((CompletionProposal)new CompletionItem.LocalVarItem(node, this.anchor + anchorShift));
                updated = true;
                continue;
            }
            if (varName.equals(varPrefix) || !varName.startsWith(varPrefix)) continue;
            proposals.add((CompletionProposal)new CompletionItem.LocalVarItem(node, this.anchor + anchorShift));
            updated = true;
        }
        return updated;
    }

    private boolean checkForVariableDefinition(CompletionRequest request) {
        LOG.log(Level.FINEST, "checkForVariableDefinition()");
        CompletionContext ctx = request.ctx;
        if (ctx == null || ctx.before1 == null) {
            return false;
        }
        GroovyTokenId id = (GroovyTokenId)ctx.before1.id();
        switch (id) {
            case LITERAL_boolean: 
            case LITERAL_byte: 
            case LITERAL_char: 
            case LITERAL_double: 
            case LITERAL_float: 
            case LITERAL_int: 
            case LITERAL_long: 
            case LITERAL_short: 
            case LITERAL_def: {
                LOG.log(Level.FINEST, "LITERAL_* discovered");
                return true;
            }
            case IDENTIFIER: {
                ASTNode node = this.getASTNodeForToken(ctx.before1, request);
                LOG.log(Level.FINEST, "getASTNodeForToken(ASTNode) : {0}", node);
                if (node != null && (node instanceof ClassExpression || node instanceof DeclarationExpression)) {
                    LOG.log(Level.FINEST, "ClassExpression or DeclarationExpression discovered");
                    return true;
                }
                return false;
            }
        }
        LOG.log(Level.FINEST, "default:");
        return false;
    }

    private ASTNode getASTNodeForToken(Token<? extends GroovyTokenId> tid, CompletionRequest request) {
        LOG.log(Level.FINEST, "getASTNodeForToken()");
        TokenHierarchy th = TokenHierarchy.get((Document)request.doc);
        int position = tid.offset(th);
        ModuleNode rootNode = AstUtilities.getRoot(request.info);
        if (rootNode == null) {
            return null;
        }
        int astOffset = AstUtilities.getAstOffset((Parser.Result)request.info, position);
        if (astOffset == -1) {
            return null;
        }
        BaseDocument document = (BaseDocument)request.info.getSnapshot().getSource().getDocument(false);
        if (document == null) {
            LOG.log(Level.FINEST, "Could not get BaseDocument. It's null");
            return null;
        }
        AstPath path = new AstPath((ASTNode)rootNode, astOffset, document);
        ASTNode node = path.leaf();
        LOG.log(Level.FINEST, "path = {0}", path);
        LOG.log(Level.FINEST, "node: {0}", node);
        return node;
    }

    private List<String> getNewVarNameSuggestion(CompletionContext ctx) {
        String typeName;
        LOG.log(Level.FINEST, "getNewVarNameSuggestion()");
        ArrayList<String> result = new ArrayList<String>();
        if (ctx == null || ctx.before1 == null) {
            return result;
        }
        if (ctx.before1.id() == GroovyTokenId.LITERAL_boolean) {
            result.add("b");
        } else if (ctx.before1.id() == GroovyTokenId.LITERAL_byte) {
            result.add("b");
        } else if (ctx.before1.id() == GroovyTokenId.LITERAL_char) {
            result.add("c");
        } else if (ctx.before1.id() == GroovyTokenId.LITERAL_double) {
            result.add("d");
        } else if (ctx.before1.id() == GroovyTokenId.LITERAL_float) {
            result.add("f");
        } else if (ctx.before1.id() == GroovyTokenId.LITERAL_int) {
            result.add("i");
        } else if (ctx.before1.id() == GroovyTokenId.LITERAL_long) {
            result.add("l");
        } else if (ctx.before1.id() == GroovyTokenId.LITERAL_short) {
            result.add("s");
        }
        if (ctx.before1.id() == GroovyTokenId.IDENTIFIER && (typeName = ((Object)ctx.before1.text()).toString()) != null) {
            this.addIfNotIn(result, typeName.substring(0, 1).toLowerCase(Locale.ENGLISH));
            this.addIfNotIn(result, typeName.toLowerCase(Locale.ENGLISH));
            this.addIfNotIn(result, CompletionHandler.camelCaseHunch(typeName));
            this.addIfNotIn(result, typeName.substring(0, 1).toLowerCase(Locale.ENGLISH) + typeName.substring(1));
        }
        return result;
    }

    void addIfNotIn(List<String> result, String name) {
        if (name.length() > 0 && !result.contains(name)) {
            LOG.log(Level.FINEST, "Adding new-var suggestion : {0}", name);
            result.add(name);
        }
    }

    private static String camelCaseHunch(CharSequence name) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (!Character.isUpperCase(c)) continue;
            char lc = Character.toLowerCase(c);
            sb.append(lc);
        }
        return sb.toString();
    }

    boolean checkForRequestBehindImportStatement(CompletionRequest request) {
        int rowStart = 0;
        int nonWhite = 0;
        try {
            rowStart = Utilities.getRowStart((BaseDocument)request.doc, (int)request.lexOffset);
            nonWhite = Utilities.getFirstNonWhiteFwd((BaseDocument)request.doc, (int)rowStart);
        }
        catch (BadLocationException ex) {
            LOG.log(Level.FINEST, "Trouble doing getRowStart() or getFirstNonWhiteFwd(): {0}", ex.getMessage());
        }
        Token<? extends GroovyTokenId> importToken = LexUtilities.getToken(request.doc, nonWhite);
        if (importToken != null && importToken.id() == GroovyTokenId.LITERAL_import) {
            LOG.log(Level.FINEST, "Right behind an import statement");
            return true;
        }
        return false;
    }

    boolean checkBehindDot(CompletionRequest request) {
        boolean behindDot = false;
        if (request == null || request.ctx == null || request.ctx.before1 == null) {
            behindDot = false;
        } else if (CharSequenceUtilities.textEquals((CharSequence)request.ctx.before1.text(), (CharSequence)".") || ((Object)request.ctx.before1.text()).toString().equals(request.prefix) && request.ctx.before2 != null && CharSequenceUtilities.textEquals((CharSequence)request.ctx.before2.text(), (CharSequence)".")) {
            behindDot = true;
        }
        return behindDot;
    }

    PackageCompletionRequest getPackageRequest(CompletionRequest request) {
        String pkgString;
        Token t;
        Token t2;
        int position = request.lexOffset;
        PackageCompletionRequest result = new PackageCompletionRequest();
        TokenSequence<? extends GroovyTokenId> ts = LexUtilities.getGroovyTokenSequence(request.doc, position);
        ts.move(position);
        Token token = null;
        boolean remainingTokens = true;
        while (ts.isValid() && (remainingTokens = ts.movePrevious()) && ts.offset() >= 0 && ((t2 = ts.token()).id() == GroovyTokenId.DOT || t2.id() == GroovyTokenId.IDENTIFIER)) {
            token = t2;
        }
        StringBuffer buf = new StringBuffer();
        Token lastToken = null;
        if (!remainingTokens && token != null && ts.isValid()) {
            buf.append(((Object)token.text()).toString());
            lastToken = token;
        }
        while (ts.isValid() && ts.moveNext() && ts.offset() < position && ((t = ts.token()).id() == GroovyTokenId.DOT || t.id() == GroovyTokenId.IDENTIFIER)) {
            buf.append(((Object)t.text()).toString());
            lastToken = t;
        }
        result.fullString = buf.toString();
        if (buf.length() == 0) {
            result.basePackage = "";
            result.prefix = "";
        } else if (lastToken != null && lastToken.id() == GroovyTokenId.DOT) {
            pkgString = buf.toString();
            result.basePackage = pkgString.substring(0, pkgString.length() - 1);
            result.prefix = "";
        } else if (lastToken != null && lastToken.id() == GroovyTokenId.IDENTIFIER) {
            pkgString = buf.toString();
            result.prefix = ((Object)lastToken.text()).toString();
            result.basePackage = pkgString.substring(0, pkgString.length() - result.prefix.length());
            if (result.basePackage.endsWith(".")) {
                result.basePackage = result.basePackage.substring(0, result.basePackage.length() - 1);
            }
        }
        LOG.log(Level.FINEST, "-- fullString : >{0}<", result.fullString);
        LOG.log(Level.FINEST, "-- basePackage: >{0}<", result.basePackage);
        LOG.log(Level.FINEST, "-- prefix:      >{0}<", result.prefix);
        return result;
    }

    private DotCompletionContext getDotCompletionContext(CompletionRequest request) {
        Token t;
        if (request.dotContext != null) {
            return request.dotContext;
        }
        int position = request.lexOffset;
        TokenSequence<? extends GroovyTokenId> ts = LexUtilities.getGroovyTokenSequence(request.doc, position);
        int difference = ts.move(position);
        Token active = null;
        if (ts.isValid() && ts.moveNext() && ts.offset() >= 0) {
            active = ts.token();
        }
        if (LOG.isLoggable(Level.FINE) && ts.isValid() && active != null) {
            LOG.log(Level.FINE, "Current token text {0}", active.text());
        }
        if (ts.isValid() && ts.movePrevious() && ts.offset() >= 0 && (t = ts.token()).id() != GroovyTokenId.DOT && t.id() != GroovyTokenId.OPTIONAL_DOT && t.id() != GroovyTokenId.MEMBER_POINTER && t.id() != GroovyTokenId.WHITESPACE && t.id() != GroovyTokenId.NLS) {
            if (t.id() != GroovyTokenId.IDENTIFIER) {
                return null;
            }
            ts.movePrevious();
        }
        boolean remainingTokens = true;
        if (ts.token().id() != GroovyTokenId.DOT && ts.token().id() != GroovyTokenId.OPTIONAL_DOT && ts.token().id() != GroovyTokenId.MEMBER_POINTER) {
            Token t2;
            while (ts.isValid() && (remainingTokens = ts.movePrevious()) && ts.offset() >= 0 && ((t2 = ts.token()).id() == GroovyTokenId.WHITESPACE || t2.id() == GroovyTokenId.NLS)) {
            }
        }
        if (ts.token().id() != GroovyTokenId.DOT && ts.token().id() != GroovyTokenId.OPTIONAL_DOT && ts.token().id() != GroovyTokenId.MEMBER_POINTER || !remainingTokens) {
            return null;
        }
        boolean methodsOnly = false;
        if (ts.token().id() == GroovyTokenId.MEMBER_POINTER) {
            methodsOnly = true;
        }
        Token t3 = null;
        while (ts.isValid() && ts.movePrevious() && ts.offset() >= 0 && ((t3 = ts.token()).id() == GroovyTokenId.WHITESPACE || t3.id() == GroovyTokenId.NLS)) {
        }
        int lexOffset = ts.offset();
        int astOffset = AstUtilities.getAstOffset((Parser.Result)request.info, lexOffset);
        AstPath realPath = this.getPath(request.info, request.doc, astOffset);
        return new DotCompletionContext(lexOffset, astOffset, realPath, methodsOnly);
    }

    private ClasspathInfo getClasspathInfoFromRequest(CompletionRequest request) {
        FileObject fileObject = request.info.getSnapshot().getSource().getFileObject();
        if (fileObject != null) {
            return ClasspathInfo.create((FileObject)fileObject);
        }
        return null;
    }

    private JavaSource getJavaSourceFromRequest(CompletionRequest request) {
        ClasspathInfo pathInfo = this.getClasspathInfoFromRequest(request);
        assert (pathInfo != null);
        JavaSource javaSource = JavaSource.create((ClasspathInfo)pathInfo, (FileObject[])new FileObject[0]);
        if (javaSource == null) {
            LOG.log(Level.FINEST, "Problem retrieving JavaSource from ClassPathInfo, exiting.");
            return null;
        }
        return javaSource;
    }

    private boolean completePackages(List<CompletionProposal> proposals, CompletionRequest request) {
        LOG.log(Level.FINEST, "-> completePackages");
        PackageCompletionRequest packageRequest = this.getPackageRequest(request);
        if (request.isBehindDot() && packageRequest.basePackage.length() <= 0) {
            return false;
        }
        LOG.log(Level.FINEST, "Token fullString = >{0}<", packageRequest.fullString);
        ClasspathInfo pathInfo = this.getClasspathInfoFromRequest(request);
        assert (pathInfo != null) : "Can not get ClasspathInfo";
        if (request.ctx.before1 != null && CharSequenceUtilities.textEquals((CharSequence)request.ctx.before1.text(), (CharSequence)"*") && request.behindImport) {
            return false;
        }
        Set pkgSet = pathInfo.getClassIndex().getPackageNames(packageRequest.fullString, true, EnumSet.allOf(ClassIndex.SearchScope.class));
        for (String singlePackage : pkgSet) {
            LOG.log(Level.FINEST, "PKG set item: {0}", singlePackage);
            if (packageRequest.prefix.equals("")) {
                singlePackage = singlePackage.substring(packageRequest.fullString.length());
            } else if (!packageRequest.basePackage.equals("")) {
                singlePackage = singlePackage.substring(packageRequest.basePackage.length() + 1);
            }
            if (!singlePackage.startsWith(packageRequest.prefix) || singlePackage.length() <= 0) continue;
            CompletionItem.PackageItem item = new CompletionItem.PackageItem(singlePackage, this.anchor, request.info);
            if (request.behindImport) {
                item.setSmart(true);
            }
            proposals.add((CompletionProposal)item);
        }
        return false;
    }

    private boolean isValidPackage(ClasspathInfo pathInfo, String pkg) {
        assert (pathInfo != null) : "ClasspathInfo can not be null";
        Set pkgSet = pathInfo.getClassIndex().getPackageNames(pkg, true, EnumSet.allOf(ClassIndex.SearchScope.class));
        if (pkgSet.size() > 0) {
            LOG.log(Level.FINEST, "Packages with prefix : {0}", pkg);
            LOG.log(Level.FINEST, "               found : {0}", pkgSet);
            for (String singlePkg : pkgSet) {
                if (!singlePkg.equals(pkg)) continue;
                LOG.log(Level.FINEST, "Exact match found.");
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean completeTypes(List<CompletionProposal> proposals, CompletionRequest request) {
        LOG.log(Level.FINEST, "-> completeTypes");
        PackageCompletionRequest packageRequest = this.getPackageRequest(request);
        if (packageRequest.basePackage.length() == 0 && packageRequest.prefix.length() == 0 && packageRequest.fullString.equals(".")) {
            return false;
        }
        if (request.ctx.before1 != null && ((Object)request.ctx.before1.text()).toString().equals("new") && request.prefix.length() > 0) {
            return false;
        }
        boolean onlyInterfaces = false;
        if (request.ctx.beforeLiteral != null && request.ctx.beforeLiteral.id() == GroovyTokenId.LITERAL_implements) {
            LOG.log(Level.FINEST, "Completing only interfaces after implements keyword.");
            onlyInterfaces = true;
        }
        ModuleNode mn = null;
        AstPath path = request.path;
        if (path != null) {
            for (ASTNode current : path) {
                if (!(current instanceof ModuleNode)) continue;
                LOG.log(Level.FINEST, "Found ModuleNode");
                mn = (ModuleNode)current;
            }
        }
        String currentPackage = null;
        if (mn != null) {
            currentPackage = mn.getPackageName();
        } else {
            ClassNode node = this.getSurroundingClassNode(request);
            if (node != null) {
                currentPackage = node.getPackageName();
            }
        }
        HashSet<TypeHolder> addedTypes = new HashSet<TypeHolder>();
        JavaSource javaSource = this.getJavaSourceFromRequest(request);
        if (packageRequest.basePackage.length() > 0 || request.behindImport) {
            if (!request.behindImport || packageRequest.basePackage.length() != 0) {
                List<TypeHolder> stringTypelist = this.getElementListForPackageAsTypeHolder(javaSource, packageRequest.basePackage, currentPackage);
                if (stringTypelist == null) {
                    LOG.log(Level.FINEST, "Typelist is null for package : {0}", packageRequest.basePackage);
                    return false;
                }
                LOG.log(Level.FINEST, "Number of types found:  {0}", stringTypelist.size());
                for (TypeHolder singleType : stringTypelist) {
                    this.addToProposalUsingFilter(addedTypes, proposals, request, singleType, onlyInterfaces);
                }
            }
            return true;
        }
        if (request.isBehindDot()) {
            return false;
        }
        if (mn != null) {
            LOG.log(Level.FINEST, "We are living in package : {0} ", currentPackage);
            GroovyIndex index = null;
            FileObject fo = request.info.getSnapshot().getSource().getFileObject();
            if (fo != null) {
                index = GroovyIndex.get(QuerySupport.findRoots((FileObject)fo, Collections.singleton("classpath/source"), Collections.emptyList(), Collections.emptyList()));
            }
            if (index != null) {
                Set<IndexedClass> classes = index.getClasses(request.prefix, QuerySupport.Kind.CASE_INSENSITIVE_PREFIX, true, false, false);
                if (classes.size() == 0) {
                    LOG.log(Level.FINEST, "Nothing found in GroovyIndex");
                } else {
                    LOG.log(Level.FINEST, "Found this number of classes : {0} ", classes.size());
                    HashSet<TypeHolder> typelist = new HashSet<TypeHolder>();
                    for (IndexedClass indexedClass : classes) {
                        LOG.log(Level.FINEST, "FQN classname from index : {0} ", indexedClass.getFqn());
                        ElementKind ek = indexedClass.getKind() == org.netbeans.modules.csl.api.ElementKind.CLASS ? ElementKind.CLASS : ElementKind.INTERFACE;
                        typelist.add(new TypeHolder(indexedClass.getFqn(), ek));
                    }
                    for (TypeHolder type : typelist) {
                        this.addToProposalUsingFilter(addedTypes, proposals, request, type, onlyInterfaces);
                    }
                }
            }
        }
        ArrayList<String> localDefaultImports = new ArrayList<String>();
        if (mn != null) {
            List imports = mn.getImports();
            if (imports != null) {
                for (ImportNode importNode : imports) {
                    LOG.log(Level.FINEST, "From getImports() : {0} ", importNode.getClassName());
                    ElementKind ek = importNode.getClass().isInterface() ? ElementKind.INTERFACE : ElementKind.CLASS;
                    this.addToProposalUsingFilter(addedTypes, proposals, request, new TypeHolder(importNode.getClassName(), ek), onlyInterfaces);
                }
            }
            List importsPkg = mn.getImportPackages();
            for (String wildcardImport : importsPkg) {
                LOG.log(Level.FINEST, "From getImportPackages() : {0} ", wildcardImport);
                if (wildcardImport.endsWith(".")) {
                    wildcardImport = wildcardImport.substring(0, wildcardImport.length() - 1);
                }
                localDefaultImports.add(wildcardImport);
            }
        }
        localDefaultImports.addAll(GroovyUtils.DEFAULT_IMPORT_PACKAGES);
        for (String singlePackage : localDefaultImports) {
            List<TypeHolder> typeList = this.getElementListForPackageAsTypeHolder(javaSource, singlePackage, currentPackage);
            if (typeList == null) {
                LOG.log(Level.FINEST, "Typelist is null for package : {0}", singlePackage);
                continue;
            }
            LOG.log(Level.FINEST, "Number of types found:  {0}", typeList.size());
            for (TypeHolder element : typeList) {
                this.addToProposalUsingFilter(addedTypes, proposals, request, element, onlyInterfaces);
            }
        }
        for (String className : GroovyUtils.DEFAULT_IMPORT_CLASSES) {
            this.addToProposalUsingFilter(addedTypes, proposals, request, new TypeHolder(className, ElementKind.CLASS), onlyInterfaces);
        }
        return true;
    }

    void addToProposalUsingFilter(Set<TypeHolder> alreadyPresent, List<CompletionProposal> proposals, CompletionRequest request, TypeHolder type, boolean onlyInterfaces) {
        if (onlyInterfaces && type.getKind() != ElementKind.INTERFACE || alreadyPresent.contains(type)) {
            return;
        }
        String typeName = NbUtilities.stripPackage(type.getName());
        if (typeName.toUpperCase(Locale.ENGLISH).startsWith(request.prefix.toUpperCase(Locale.ENGLISH))) {
            alreadyPresent.add(type);
            proposals.add((CompletionProposal)new CompletionItem.TypeItem(typeName, this.anchor, type.getKind()));
        }
    }

    List<? extends Element> getElementListForPackage(Elements elements, JavaSource javaSource, String pkg) {
        LOG.log(Level.FINEST, "getElementListForPackage(), Package :  {0}", pkg);
        List<? extends Element> typelist = null;
        if (elements != null && pkg != null) {
            LOG.log(Level.FINEST, "TypeSearcherHelper.run(), elements retrieved");
            PackageElement packageElement = elements.getPackageElement(pkg);
            if (packageElement == null) {
                LOG.log(Level.FINEST, "packageElement is null");
            } else {
                typelist = packageElement.getEnclosedElements();
            }
        }
        LOG.log(Level.FINEST, "Returning Typlist");
        return typelist;
    }

    List<TypeHolder> getElementListForPackageAsTypeHolder(JavaSource javaSource, final String pkg, final String currentPackage) {
        LOG.log(Level.FINEST, "getElementListForPackageAsString(), Package :  {0}", pkg);
        final ArrayList<TypeHolder> result = new ArrayList<TypeHolder>();
        if (javaSource != null) {
            try {
                javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController info) {
                        List<? extends Element> typelist = null;
                        Elements elements = info.getElements();
                        if (elements != null && pkg != null) {
                            LOG.log(Level.FINEST, "TypeSearcherHelper.run(), elements retrieved");
                            PackageElement packageElement = elements.getPackageElement(pkg);
                            if (packageElement == null) {
                                LOG.log(Level.FINEST, "packageElement is null");
                            } else {
                                typelist = packageElement.getEnclosedElements();
                                boolean samePackage = pkg.equals(currentPackage);
                                for (Element element : typelist) {
                                    Set<Modifier> modifiers = element.getModifiers();
                                    if (!modifiers.contains((Object)Modifier.PUBLIC) && (!samePackage || !modifiers.contains((Object)Modifier.PROTECTED) && (modifiers.contains((Object)Modifier.PUBLIC) || modifiers.contains((Object)Modifier.PRIVATE)))) continue;
                                    result.add(new TypeHolder(element.toString(), element.getKind()));
                                }
                            }
                        }
                    }
                }, true);
            }
            catch (IOException ex) {
                LOG.log(Level.FINEST, "IOException : {0}", ex.getMessage());
            }
        }
        return result;
    }

    boolean isPackageAlreadyProposed(Set<String> pkgSet, String prefix) {
        for (String singlePackage : pkgSet) {
            if (!prefix.startsWith(singlePackage)) continue;
            return true;
        }
        return false;
    }

    private ClassNode getBeforeDotDeclaringClass(CompletionRequest request) {
        assert (request.isBehindDot() || request.ctx.before1 == null);
        if (request.declaringClass != null && request.declaringClass instanceof ClassNode) {
            LOG.log(Level.FINEST, "returning declaringClass from request.");
            return request.declaringClass;
        }
        DotCompletionContext dotCompletionContext = this.getDotCompletionContext(request);
        if (!(request.isBehindDot() || request.ctx.before1 != null || request.location != CaretLocation.INSIDE_CLOSURE && request.location != CaretLocation.INSIDE_METHOD)) {
            request.declaringClass = this.getSurroundingClassNode(request);
            return request.declaringClass;
        }
        if (dotCompletionContext == null || dotCompletionContext.getAstPath() == null || dotCompletionContext.getAstPath().leaf() == null) {
            return null;
        }
        request.beforeDotPath = dotCompletionContext.getAstPath();
        Object declClass = null;
        GroovyTypeAnalyzer typeAnalyzer = new GroovyTypeAnalyzer(request.doc);
        Set<ClassNode> infered = typeAnalyzer.getTypes(dotCompletionContext.getAstPath(), dotCompletionContext.getAstOffset());
        if (!infered.isEmpty()) {
            return infered.iterator().next();
        }
        if (declClass != null) {
            request.declaringClass = declClass;
            return request.declaringClass;
        }
        if (dotCompletionContext.getAstPath().leaf() instanceof VariableExpression) {
            VariableExpression variable = (VariableExpression)dotCompletionContext.getAstPath().leaf();
            if ("this".equals(variable.getName())) {
                request.declaringClass = this.getSurroundingClassNode(request);
                return request.declaringClass;
            }
            if ("super".equals(variable.getName())) {
                ClassNode thisClass = this.getSurroundingClassNode(request);
                request.declaringClass = thisClass.getSuperClass();
                if (request.declaringClass == null) {
                    return new ClassNode("java.lang.Object", 1, null);
                }
                return request.declaringClass;
            }
        }
        if (dotCompletionContext.getAstPath().leaf() instanceof Expression) {
            Expression expression = (Expression)dotCompletionContext.getAstPath().leaf();
            if (expression instanceof RangeExpression && "java.lang.Object".equals(expression.getType().getName())) {
                try {
                    expression.setType(new ClassNode(Class.forName("groovy.lang.Range")));
                }
                catch (ClassNotFoundException ex) {
                    expression.setType(new ClassNode("groovy.lang.Range", 513, null));
                }
            }
            request.declaringClass = expression.getType();
        }
        return request.declaringClass;
    }

    private static List<CompletionItem.ParameterDescriptor> getParameterList(ExecutableElement exe) {
        ArrayList<CompletionItem.ParameterDescriptor> paramList = new ArrayList<CompletionItem.ParameterDescriptor>();
        if (exe != null) {
            List<? extends VariableElement> params = null;
            try {
                params = exe.getParameters();
                int i = 1;
                for (VariableElement variableElement : params) {
                    String fullName;
                    TypeMirror tm = variableElement.asType();
                    String name = fullName = ((Object)tm).toString();
                    if (tm.getKind() == TypeKind.DECLARED) {
                        name = NbUtilities.stripPackage(fullName);
                    }
                    String varName = "param" + String.valueOf(i);
                    paramList.add(new CompletionItem.ParameterDescriptor(fullName, name, varName));
                    ++i;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return paramList;
    }

    public static String getParameterListForMethod(ExecutableElement exe) {
        StringBuffer sb = new StringBuffer();
        if (exe != null) {
            List<? extends VariableElement> params = null;
            try {
                params = exe.getParameters();
                for (VariableElement variableElement : params) {
                    TypeMirror tm = variableElement.asType();
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    if (tm.getKind() == TypeKind.DECLARED || tm.getKind() == TypeKind.ARRAY) {
                        sb.append(NbUtilities.stripPackage(((Object)tm).toString()));
                        continue;
                    }
                    sb.append(((Object)tm).toString());
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return sb.toString();
    }

    private boolean completeMethods(final List<CompletionProposal> proposals, final CompletionRequest request) {
        ClasspathInfo pathInfo;
        LOG.log(Level.FINEST, "-> completeMethods");
        if (request.location == CaretLocation.INSIDE_PARAMETERS) {
            LOG.log(Level.FINEST, "no method completion inside of parameters");
            return false;
        }
        if (request == null || request.ctx == null) {
            return false;
        }
        if (request.ctx.before1 != null && ((Object)request.ctx.before1.text()).toString().equals("new") && request.prefix.length() > 0) {
            LOG.log(Level.FINEST, "This looks like a constructor ...");
            final ArrayList<String> localDefaultImports = new ArrayList<String>();
            localDefaultImports.addAll(GroovyUtils.DEFAULT_IMPORT_PACKAGES);
            final JavaSource javaSource = this.getJavaSourceFromRequest(request);
            if (javaSource != null) {
                try {
                    javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                        public void run(CompilationController info) {
                            for (String singlePackage : localDefaultImports) {
                                List<? extends Element> typelist = CompletionHandler.this.getElementListForPackage(info.getElements(), javaSource, singlePackage);
                                if (typelist == null) {
                                    LOG.log(Level.FINEST, "Typelist is null for package : {0}", singlePackage);
                                    continue;
                                }
                                LOG.log(Level.FINEST, "Number of types found:  {0}", typelist.size());
                                for (Element element : typelist) {
                                    if (element.getKind() != ElementKind.CLASS) continue;
                                    TypeElement te = (TypeElement)element;
                                    List<? extends Element> enclosed = te.getEnclosedElements();
                                    String constructorName = te.getSimpleName().toString();
                                    for (Element element2 : enclosed) {
                                        if (element2.getKind() != ElementKind.CONSTRUCTOR || !constructorName.toUpperCase(Locale.ENGLISH).startsWith(request.prefix.toUpperCase(Locale.ENGLISH))) continue;
                                        LOG.log(Level.FINEST, "Constructor call candidate added : {0}", constructorName);
                                        String paramListString = CompletionHandler.getParameterListForMethod((ExecutableElement)element2);
                                        List paramList = CompletionHandler.getParameterList((ExecutableElement)element2);
                                        proposals.add(new CompletionItem.ConstructorItem(constructorName, paramListString, paramList, CompletionHandler.this.anchor, false));
                                    }
                                }
                            }
                        }
                    }, true);
                }
                catch (IOException ex) {
                    LOG.log(Level.FINEST, "IOException : {0}", ex.getMessage());
                }
            }
            return !proposals.isEmpty();
        }
        if (!request.isBehindDot() && request.ctx.before1 != null) {
            LOG.log(Level.FINEST, "I'm not invoked behind a dot.");
            return false;
        }
        ClassNode declaringClass = this.getBeforeDotDeclaringClass(request);
        if (declaringClass == null) {
            LOG.log(Level.FINEST, "No declaring class found");
            return false;
        }
        PackageCompletionRequest packageRequest = this.getPackageRequest(request);
        if (packageRequest.basePackage.length() > 0 && this.isValidPackage(pathInfo = this.getClasspathInfoFromRequest(request), packageRequest.basePackage)) {
            LOG.log(Level.FINEST, "The string before the dot seems to be a valid package");
            return false;
        }
        Map<MethodSignature, ? extends CompletionItem> result = CompleteElementHandler.forCompilationInfo(request.info).getMethods(this.getSurroundingClassNode(request), declaringClass, request.prefix, this.anchor, request.dotContext != null && request.dotContext.isMethodsOnly());
        proposals.addAll(result.values());
        return true;
    }

    private boolean completeCamelCase(List<CompletionProposal> proposals, CompletionRequest request) {
        LOG.log(Level.FINEST, "-> completeCamelCase");
        if (request.location != CaretLocation.INSIDE_CLASS) {
            LOG.log(Level.FINEST, "Not inside a class");
            return false;
        }
        String prefix = request.prefix;
        if (prefix != null && prefix.length() > 0 && prefix.equals(prefix.toUpperCase())) {
            ClassNode requestedClass = this.getSurroundingClassNode(request);
            if (requestedClass == null) {
                LOG.log(Level.FINEST, "No surrounding class found, bail out ...");
                return false;
            }
            String camelCaseSignature = this.computeCamelCaseSignature(requestedClass.getName());
            LOG.log(Level.FINEST, "Class name          : {0}", requestedClass.getName());
            LOG.log(Level.FINEST, "CamelCase signature : {0}", camelCaseSignature);
            if (camelCaseSignature.startsWith(prefix)) {
                LOG.log(Level.FINEST, "Prefix matches Class's CamelCase signature. Adding.");
                proposals.add((CompletionProposal)new CompletionItem.ConstructorItem(requestedClass.getName(), null, null, this.anchor, true));
                return true;
            }
        }
        return false;
    }

    private String computeCamelCaseSignature(String name) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < name.length(); ++i) {
            if (!Character.isUpperCase(name.charAt(i))) continue;
            sb.append(name.charAt(i));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CodeCompletionResult complete(CodeCompletionContext context) {
        ParserResult info = context.getParserResult();
        String prefix = context.getPrefix();
        int lexOffset = context.getCaretOffset();
        int astOffset = AstUtilities.getAstOffset((Parser.Result)info, lexOffset);
        LOG.log(Level.FINEST, "complete(...), prefix      : {0}", prefix);
        LOG.log(Level.FINEST, "complete(...), lexOffset   : {0}", lexOffset);
        LOG.log(Level.FINEST, "complete(...), astOffset   : {0}", astOffset);
        if (prefix == null) {
            prefix = "";
        }
        ArrayList<CompletionProposal> proposals = new ArrayList<CompletionProposal>();
        this.anchor = lexOffset - prefix.length();
        Document document = info.getSnapshot().getSource().getDocument(false);
        if (document == null) {
            return CodeCompletionResult.NONE;
        }
        BaseDocument doc = (BaseDocument)document;
        doc.readLock();
        try {
            CompletionRequest request = new CompletionRequest();
            request.lexOffset = lexOffset;
            request.astOffset = astOffset;
            request.doc = doc;
            request.info = info;
            request.prefix = prefix;
            request.scriptMode = false;
            request.path = this.getPathFromRequest(request);
            LOG.log(Level.FINEST, "complete(...), path        : {0}", request.path);
            request.location = this.getCaretLocationFromRequest(request);
            LOG.log(Level.FINEST, "I am here in sourcecode: {0}", (Object)request.location);
            if (request.location == CaretLocation.ABOVE_PACKAGE || request.location == CaretLocation.INSIDE_COMMENT) {
                DefaultCompletionResult defaultCompletionResult = new DefaultCompletionResult(proposals, false);
                return defaultCompletionResult;
            }
            request.ctx = this.getCompletionContext(request);
            assert (request.ctx != null);
            request.dotContext = this.getDotCompletionContext(request);
            if (request.isBehindDot()) {
                request.declaringClass = this.getBeforeDotDeclaringClass(request);
            }
            boolean definitionLine = this.checkForVariableDefinition(request);
            request.behindImport = this.checkForRequestBehindImportStatement(request);
            List<String> newVars = null;
            if (definitionLine) {
                newVars = this.getNewVarNameSuggestion(request.ctx);
            } else {
                if (request.location != CaretLocation.OUTSIDE_CLASSES && request.location != CaretLocation.INSIDE_STRING) {
                    this.completePackages(proposals, request);
                    this.completeTypes(proposals, request);
                }
                if (!request.behindImport) {
                    if (request.location != CaretLocation.INSIDE_STRING) {
                        this.completeKeywords(proposals, request);
                        this.completeMethods(proposals, request);
                    }
                    this.completeFields(proposals, request);
                    this.completeLocalVars(proposals, request);
                }
            }
            this.completeNewVars(proposals, request, newVars);
            this.completeCamelCase(proposals, request);
            DefaultCompletionResult defaultCompletionResult = new DefaultCompletionResult(proposals, false);
            return defaultCompletionResult;
        }
        finally {
            doc.readUnlock();
        }
    }

    public static String getMethodSignature(MetaMethod method, boolean forURL, boolean isGDK) {
        String methodSignature = method.getSignature();
        methodSignature = methodSignature.trim();
        if (isGDK) {
            int firstSpace = methodSignature.indexOf(" ");
            if (firstSpace != -1) {
                methodSignature = methodSignature.substring(firstSpace + 1);
            }
            if (forURL) {
                methodSignature = methodSignature.replaceAll(", ", ",%20");
            }
            return methodSignature;
        }
        String[] parts = methodSignature.split("[()]");
        if (parts.length < 2) {
            return "";
        }
        String paramsBody = CompletionHandler.decodeTypes(parts[1], forURL);
        return parts[0] + "(" + paramsBody + ")";
    }

    static String decodeTypes(String encodedType, boolean forURL) {
        String DELIMITER = ",";
        DELIMITER = forURL ? DELIMITER + "%20" : DELIMITER + " ";
        StringBuffer sb = new StringBuffer("");
        boolean nextIsAnArray = false;
        for (int i = 0; i < encodedType.length(); ++i) {
            char c = encodedType.charAt(i);
            if (c == '[') {
                nextIsAnArray = true;
                continue;
            }
            if (c == 'Z') {
                sb.append("boolean");
            } else if (c == 'B') {
                sb.append("byte");
            } else if (c == 'C') {
                sb.append("char");
            } else if (c == 'D') {
                sb.append("double");
            } else if (c == 'F') {
                sb.append("float");
            } else if (c == 'I') {
                sb.append("int");
            } else if (c == 'J') {
                sb.append("long");
            } else if (c == 'S') {
                sb.append("short");
            } else if (c == 'L') {
                int semicolon = encodedType.indexOf(";", ++i);
                String typeName = encodedType.substring(i, semicolon);
                typeName = typeName.replace('/', '.');
                if (forURL) {
                    sb.append(typeName);
                } else {
                    sb.append(NbUtilities.stripPackage(typeName));
                }
                i = semicolon;
            }
            if (nextIsAnArray) {
                sb.append("[]");
                nextIsAnArray = false;
            }
            if (i >= encodedType.length() - 1) continue;
            sb.append(DELIMITER);
        }
        return sb.toString();
    }

    public String document(ParserResult info, ElementHandle element) {
        LOG.log(Level.FINEST, "document(), ElementHandle : {0}", element);
        String error = NbBundle.getMessage(CompletionHandler.class, (String)"GroovyCompletion_NoJavaDocFound");
        String doctext = null;
        if (element instanceof AstMethodElement) {
            String className;
            AstMethodElement ame = (AstMethodElement)element;
            String base = "";
            String javadoc = this.getGroovyJavadocBase();
            if (this.jdkJavaDocBase != null && !ame.isGDK()) {
                base = this.jdkJavaDocBase;
            } else if (javadoc != null && ame.isGDK()) {
                base = javadoc;
            } else {
                LOG.log(Level.FINEST, "Neither JDK nor GDK or error locating: {0}", ame.isGDK());
                return error;
            }
            MetaMethod mm = ame.getMethod();
            CompletionHandler.printMethod(mm);
            if (ame.isGDK()) {
                className = mm.getDeclaringClass().getName();
            } else {
                CachedClass cc;
                String declName = null;
                if (mm != null && (cc = mm.getDeclaringClass()) != null) {
                    declName = cc.getName();
                }
                className = declName != null ? declName : ame.getClz().getName();
            }
            String classNamePath = className.replace(".", "/");
            classNamePath = classNamePath + ".html";
            if (!ame.isGDK()) {
                File testFile;
                String apiDoc = this.getGroovyApiDocBase();
                try {
                    URL url = new URL(apiDoc + classNamePath);
                    testFile = new File(url.toURI());
                }
                catch (MalformedURLException ex) {
                    LOG.log(Level.FINEST, "MalformedURLException: {0}", ex);
                    return error;
                }
                catch (URISyntaxException uriEx) {
                    LOG.log(Level.FINEST, "URISyntaxException: {0}", uriEx);
                    return error;
                }
                if (testFile != null && testFile.exists()) {
                    base = apiDoc;
                }
            }
            String sig = CompletionHandler.getMethodSignature(ame.getMethod(), true, ame.isGDK());
            String printSig = CompletionHandler.getMethodSignature(ame.getMethod(), false, ame.isGDK());
            String urlName = base + classNamePath + "#" + sig;
            try {
                LOG.log(Level.FINEST, "Trying to load URL = {0}", urlName);
                doctext = HTMLJavadocParser.getJavadocText(new URL(urlName), false, ame.isGDK());
            }
            catch (MalformedURLException ex) {
                LOG.log(Level.FINEST, "document(), URL trouble: {0}", ex);
                return error;
            }
            if (doctext == null) {
                return error;
            }
            doctext = "<h3>" + className + "." + printSig + "</h3><BR>" + doctext;
        }
        return doctext;
    }

    public ElementHandle resolveLink(String link, ElementHandle originalHandle) {
        return originalHandle;
    }

    public String getPrefix(ParserResult info, int caretOffset, boolean upToOffset) {
        return null;
    }

    public CodeCompletionHandler.QueryType getAutoQuery(JTextComponent component, String typedText) {
        char c = typedText.charAt(0);
        if (c == '.') {
            return CodeCompletionHandler.QueryType.COMPLETION;
        }
        return CodeCompletionHandler.QueryType.NONE;
    }

    public String resolveTemplateVariable(String variable, ParserResult info, int caretOffset, String name, Map parameters) {
        return null;
    }

    public Set<String> getApplicableTemplates(Document d, int selectionBegin, int selectionEnd) {
        return Collections.emptySet();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ParameterInfo parameters(ParserResult info, int caretOffset, CompletionProposal proposal) {
        LOG.log(Level.FINEST, "parameters(), caretOffset = {0}", caretOffset);
        ArrayList<String> paramList = new ArrayList<String>();
        AstPath path = this.getPathFromInfo(caretOffset, info);
        BaseDocument doc = (BaseDocument)info.getSnapshot().getSource().getDocument(true);
        if (path != null) {
            ArgumentListExpression ael = this.getSurroundingArgumentList(path);
            if (ael != null) {
                List<ASTNode> children = AstUtilities.children(ael);
                int idx = 1;
                int index = -1;
                int offset = -1;
                for (ASTNode node : children) {
                    OffsetRange range = AstUtilities.getRange(node, doc);
                    paramList.add(node.getText());
                    if (range.containsInclusive(caretOffset)) {
                        offset = range.getStart();
                        index = idx;
                    }
                    ++idx;
                }
                if (paramList == null || paramList.isEmpty()) return ParameterInfo.NONE;
                return new ParameterInfo(paramList, index, offset);
            }
            LOG.log(Level.FINEST, "ArgumentListExpression ==  null");
            return ParameterInfo.NONE;
        }
        LOG.log(Level.FINEST, "path ==  null");
        return ParameterInfo.NONE;
    }

    private static class TypeHolder {
        private final String name;
        private final ElementKind kind;

        public TypeHolder(String name, ElementKind kind) {
            this.name = name;
            this.kind = kind;
        }

        public ElementKind getKind() {
            return this.kind;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TypeHolder other = (TypeHolder)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return this.kind == other.kind;
        }

        public int hashCode() {
            int hash = 3;
            hash = 59 * hash + (this.name != null ? this.name.hashCode() : 0);
            hash = 59 * hash + (this.kind != null ? this.kind.hashCode() : 0);
            return hash;
        }
    }

    static class CompletionRequest {
        ParserResult info;
        int lexOffset;
        int astOffset;
        BaseDocument doc;
        String prefix = "";
        CaretLocation location;
        boolean scriptMode;
        boolean behindImport;
        CompletionContext ctx;
        AstPath path;
        AstPath beforeDotPath;
        ClassNode declaringClass;
        DotCompletionContext dotContext;

        CompletionRequest() {
        }

        public boolean isBehindDot() {
            return this.dotContext != null;
        }
    }

    private static class DotCompletionContext {
        private final int lexOffset;
        private final int astOffset;
        private final AstPath astPath;
        private final boolean methodsOnly;

        public DotCompletionContext(int lexOffset, int astOffset, AstPath astPath, boolean methodsOnly) {
            this.lexOffset = lexOffset;
            this.astOffset = astOffset;
            this.astPath = astPath;
            this.methodsOnly = methodsOnly;
        }

        public int getLexOffset() {
            return this.lexOffset;
        }

        public int getAstOffset() {
            return this.astOffset;
        }

        public AstPath getAstPath() {
            return this.astPath;
        }

        public boolean isMethodsOnly() {
            return this.methodsOnly;
        }
    }

    class PackageCompletionRequest {
        String fullString = "";
        String basePackage = "";
        String prefix = "";

        PackageCompletionRequest() {
        }
    }

    class CompletionContext {
        Token<? extends GroovyTokenId> beforeLiteral;
        Token<? extends GroovyTokenId> before2;
        Token<? extends GroovyTokenId> before1;
        Token<? extends GroovyTokenId> active;
        Token<? extends GroovyTokenId> after1;
        Token<? extends GroovyTokenId> after2;
        Token<? extends GroovyTokenId> afterLiteral;
        TokenSequence<?> ts;

        public CompletionContext(Token<? extends GroovyTokenId> beforeLiteral, Token<? extends GroovyTokenId> before2, Token<? extends GroovyTokenId> before1, Token<? extends GroovyTokenId> active, Token<? extends GroovyTokenId> after1, Token<? extends GroovyTokenId> after2, Token<? extends GroovyTokenId> afterLiteral, TokenSequence<?> ts) {
            this.beforeLiteral = beforeLiteral;
            this.before2 = before2;
            this.before1 = before1;
            this.active = active;
            this.after1 = after1;
            this.after2 = after2;
            this.afterLiteral = afterLiteral;
            this.ts = ts;
        }
    }
}

