/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Value;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidStackFrameExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocalVariableWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.models.AbstractVariable;
import org.netbeans.modules.debugger.jpda.models.CallStackFrameImpl;

class Local
extends AbstractVariable
implements org.netbeans.api.debugger.jpda.LocalVariable {
    LocalVariable local;
    JPDAThread thread;
    int depth;
    String className;
    String genericSignature;

    Local(JPDADebuggerImpl debugger, PrimitiveValue value, String className, LocalVariable local, CallStackFrameImpl frame) {
        super(debugger, value, Local.getID(local, value));
        this.local = local;
        if (frame != null) {
            this.thread = frame.getThread();
            this.depth = frame.getFrameDepth();
        }
        this.className = className;
    }

    private static String getID(LocalVariable local, PrimitiveValue value) {
        try {
            return LocalVariableWrapper.name(local) + LocalVariableWrapper.hashCode(local) + (value instanceof ObjectReference ? "^" : "");
        }
        catch (InternalExceptionWrapper ex) {
            return ex.getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return ex.getLocalizedMessage();
        }
    }

    public String getName() {
        try {
            return LocalVariableWrapper.name(this.local);
        }
        catch (InternalExceptionWrapper ex) {
            return ex.getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return ex.getLocalizedMessage();
        }
    }

    public String getClassName() {
        return this.className;
    }

    protected final void setClassName(String className) {
        this.className = className;
    }

    public String getDeclaredType() {
        try {
            return LocalVariableWrapper.typeName(this.local);
        }
        catch (InternalExceptionWrapper ex) {
            return ex.getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return ex.getLocalizedMessage();
        }
    }

    @Override
    protected final void setValue(Value value) throws InvalidExpressionException {
        try {
            StackFrame sf = ((CallStackFrameImpl)this.thread.getCallStack(this.depth, this.depth + 1)[0]).getStackFrame();
            sf.setValue(this.local, value);
            this.setInnerValue(value);
        }
        catch (AbsentInformationException aiex) {
            throw new InvalidExpressionException((Throwable)aiex);
        }
        catch (InvalidTypeException ex) {
            throw new InvalidExpressionException((Throwable)ex);
        }
        catch (ClassNotLoadedException ex) {
            throw new InvalidExpressionException((Throwable)ex);
        }
        catch (InvalidStackFrameException ex) {
            throw new InvalidExpressionException((Throwable)ex);
        }
        catch (InvalidStackFrameExceptionWrapper ex) {
            throw new InvalidExpressionException((Throwable)ex);
        }
        catch (VMDisconnectedExceptionWrapper ex) {
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            // empty catch block
        }
    }

    final void setFrame(CallStackFrameImpl frame) {
        this.thread = frame.getThread();
        this.depth = frame.getFrameDepth();
    }

    @Override
    public Local clone() {
        Local clon = new Local(this.getDebugger(), (PrimitiveValue)this.getJDIValue(), this.className, this.local, null);
        clon.depth = this.depth;
        clon.thread = this.thread;
        return clon;
    }

    @Override
    public String toString() {
        try {
            return "LocalVariable " + LocalVariableWrapper.name(this.local);
        }
        catch (InternalExceptionWrapper ex) {
            return "LocalVariable " + ex.getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return ex.getLocalizedMessage();
        }
    }
}

