/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.actions;

import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.actions.JPDADebuggerActionProvider;
import org.netbeans.modules.debugger.jpda.actions.MethodChooserSupport;
import org.netbeans.modules.debugger.jpda.actions.StepIntoNextMethod;
import org.netbeans.modules.debugger.jpda.jdi.IllegalThreadStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidStackFrameExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocationWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.StackFrameWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ThreadReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.netbeans.spi.debugger.ui.MethodChooser;

public class StepIntoActionProvider
extends JPDADebuggerActionProvider {
    public static final String SS_STEP_OUT = "SS_ACTION_STEPOUT";
    public static final String ACTION_SMART_STEP_INTO = "smartStepInto";
    private StepIntoNextMethod stepInto;
    private MethodChooser currentMethodChooser;
    static final Map<ContextProvider, Reference<StepIntoActionProvider>> instanceByContext = new WeakHashMap<ContextProvider, Reference<StepIntoActionProvider>>();

    public StepIntoActionProvider(ContextProvider contextProvider) {
        super((JPDADebuggerImpl)((Object)contextProvider.lookupFirst(null, JPDADebugger.class)));
        this.stepInto = new StepIntoNextMethod(contextProvider);
        this.setProviderToDisableOnLazyAction(this);
        instanceByContext.put(contextProvider, new WeakReference<StepIntoActionProvider>(this));
    }

    public Set getActions() {
        return new HashSet<Object>(Arrays.asList(ActionsManager.ACTION_STEP_INTO));
    }

    public void doAction(Object action) {
        this.runAction(action, true, null);
    }

    public void postAction(final Object action, final Runnable actionPerformedNotifier) {
        this.doLazyAction(action, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    StepIntoActionProvider.this.runAction(action, true, null);
                }
                finally {
                    actionPerformedNotifier.run();
                }
            }
        });
    }

    public void runAction(Object action, boolean doResume, Lock lock) {
        if (ActionsManager.ACTION_STEP_INTO.equals(action) && this.doMethodSelection()) {
            return;
        }
        this.stepInto.runAction(action, doResume, lock);
    }

    @Override
    protected void checkEnabled(int debuggerState) {
        Iterator i = this.getActions().iterator();
        while (i.hasNext()) {
            this.setEnabled(i.next(), debuggerState == 3 && this.getDebuggerImpl().getCurrentThread() != null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doMethodSelection() {
        StepIntoActionProvider stepIntoActionProvider = this;
        synchronized (stepIntoActionProvider) {
            if (this.currentMethodChooser != null) {
                this.currentMethodChooser.releaseUI(true);
                return true;
            }
        }
        final String[] methodPtr = new String[1];
        final String[] urlPtr = new String[1];
        final int[] linePtr = new int[1];
        final int[] offsetPtr = new int[1];
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    EditorContext context = EditorContextBridge.getContext();
                    methodPtr[0] = context.getSelectedMethodName();
                    linePtr[0] = context.getCurrentLineNumber();
                    offsetPtr[0] = EditorContextBridge.getCurrentOffset();
                    urlPtr[0] = context.getCurrentURL();
                }
            });
        }
        catch (InvocationTargetException ex) {
            return false;
        }
        catch (InterruptedException ex) {
            return false;
        }
        int methodLine = linePtr[0];
        int methodOffset = offsetPtr[0];
        String url = urlPtr[0];
        if (methodLine < 0 || url == null || !url.endsWith(".java")) {
            return false;
        }
        JPDAThreadImpl ct = (JPDAThreadImpl)this.debugger.getCurrentThread();
        ThreadReference threadReference = ct.getThreadReference();
        ReferenceType clazz = null;
        try {
            if (ThreadReferenceWrapper.frameCount(threadReference) < 1) {
                return false;
            }
            clazz = LocationWrapper.declaringType(StackFrameWrapper.location(ThreadReferenceWrapper.frame(threadReference, 0)));
        }
        catch (InternalExceptionWrapper ex) {
        }
        catch (ObjectCollectedExceptionWrapper ex) {
        }
        catch (InvalidStackFrameExceptionWrapper ex) {
        }
        catch (IncompatibleThreadStateException ex) {
        }
        catch (IllegalThreadStateExceptionWrapper ex) {
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            // empty catch block
        }
        if (clazz != null) {
            if (this.debugger.getState() == 4) {
                return false;
            }
            final MethodChooserSupport cSupport = new MethodChooserSupport(this.debugger, url, clazz, methodLine, methodOffset);
            boolean continuedDirectly = cSupport.init();
            if (cSupport.getSegmentsCount() == 0) {
                return false;
            }
            if (continuedDirectly) {
                return true;
            }
            MethodChooser.ReleaseListener releaseListener = new MethodChooser.ReleaseListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void released(boolean performAction) {
                    3 var2_2 = this;
                    synchronized (var2_2) {
                        StepIntoActionProvider.this.currentMethodChooser = null;
                        cSupport.tearDown();
                        if (performAction) {
                            cSupport.doStepInto();
                        }
                    }
                }
            };
            MethodChooser chooser = cSupport.createChooser();
            chooser.addReleaseListener(releaseListener);
            boolean success = chooser.showUI();
            if (success && chooser.isUIActive()) {
                StepIntoActionProvider stepIntoActionProvider2 = this;
                synchronized (stepIntoActionProvider2) {
                    cSupport.tearUp(chooser);
                    this.currentMethodChooser = chooser;
                }
            } else {
                chooser.removeReleaseListener(releaseListener);
            }
            return success;
        }
        return false;
    }
}

