/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.memory;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.results.memory.MemoryCCTProvider;
import org.netbeans.lib.profiler.results.memory.MemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.PresoObjAllocCCTNode;
import org.netbeans.lib.profiler.results.memory.RuntimeMemoryCCTNode;

public class AllocMemoryResultsSnapshot
extends MemoryResultsSnapshot {
    private static final String MEMORY_ALLOC_MSG = ResourceBundle.getBundle("org.netbeans.lib.profiler.results.memory.Bundle").getString("AllocMemoryResultsSnapshot_MemoryAllocMsg");
    private int[] objectsCounts;

    public AllocMemoryResultsSnapshot() {
    }

    public AllocMemoryResultsSnapshot(long beginTime, long timeTaken, MemoryCCTProvider provider, ProfilerClient client) throws ClientUtils.TargetAppOrVMTerminated {
        super(beginTime, timeTaken, provider, client);
    }

    public int[] getObjectsCounts() {
        return this.objectsCounts;
    }

    @Override
    public void performInit(ProfilerClient client, MemoryCCTProvider provider) throws ClientUtils.TargetAppOrVMTerminated {
        int[] cnts = client.getAllocatedObjectsCountResults();
        this.objectsCounts = new int[cnts.length];
        System.arraycopy(cnts, 0, this.objectsCounts, 0, cnts.length);
        if (LOGGER.isLoggable(Level.FINEST)) {
            this.debugValues();
        }
    }

    @Override
    public void readFromStream(DataInputStream in) throws IOException {
        super.readFromStream(in);
        int len = in.readInt();
        this.objectsCounts = new int[len];
        for (int i = 0; i < len; ++i) {
            this.objectsCounts[i] = in.readInt();
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            this.debugValues();
        }
    }

    @Override
    public String toString() {
        return MessageFormat.format(MEMORY_ALLOC_MSG, super.toString());
    }

    @Override
    public void writeToStream(DataOutputStream out) throws IOException {
        super.writeToStream(out);
        out.writeInt(this.objectsCounts.length);
        for (int i = 0; i < this.objectsCounts.length; ++i) {
            out.writeInt(this.objectsCounts[i]);
        }
    }

    @Override
    protected PresoObjAllocCCTNode createPresentationCCT(RuntimeMemoryCCTNode rootNode, int classId, boolean dontShowZeroLiveObjAllocPaths) {
        return PresoObjAllocCCTNode.createPresentationCCTFromSnapshot(this, rootNode, this.getClassName(classId));
    }

    @Override
    void debugValues() {
        super.debugValues();
        LOGGER.finest("objectsCounts.length: " + this.debugLength(this.objectsCounts));
    }
}

