/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ide.ergonomics.fod;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.startup.layers.LayerCacheManager;
import org.netbeans.modules.ide.ergonomics.fod.FeatureInfo;
import org.netbeans.modules.ide.ergonomics.fod.FeatureManager;
import org.netbeans.modules.ide.ergonomics.fod.FoDEditorOpened;
import org.netbeans.spi.project.ProjectFactory;
import org.netbeans.spi.project.support.ant.AntBasedProjectType;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.MultiFileSystem;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public final class FoDFileSystem
extends MultiFileSystem
implements Runnable,
ChangeListener,
LookupListener {
    private static final LayerCacheManager manager = LayerCacheManager.create((String)"all-ergonomics.dat");
    static final Logger LOG = Logger.getLogger(FoDFileSystem.class.getPackage().getName());
    private static RequestProcessor RP = new RequestProcessor("Ergonomics");
    private RequestProcessor.Task refresh = RP.create((Runnable)this, true);
    private Lookup.Result<ProjectFactory> factories;
    private Lookup.Result<?> ants;
    private boolean forcedRefresh;
    private final ChangeListener weakL;

    public FoDFileSystem() {
        this.setPropagateMasks(true);
        this.weakL = WeakListeners.change((ChangeListener)this, (Object)FeatureManager.getInstance());
        try {
            FileSystem fs = manager.loadCache();
            if (fs != null) {
                LOG.fine("Using cached layer");
                this.setDelegates(new FileSystem[]{fs});
                return;
            }
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, "Cannot read cache", ex);
        }
        this.refresh();
    }

    public static FoDFileSystem getInstance() {
        return (FoDFileSystem)Lookup.getDefault().lookup(FoDFileSystem.class);
    }

    public void initListener() {
        FeatureManager.getInstance().addChangeListener(this.weakL);
    }

    public void refresh() {
        this.refresh.schedule(0);
        this.refresh.waitFinished();
    }

    public void refreshForce() {
        this.forcedRefresh = true;
        this.refresh.schedule(0);
        this.refresh.waitFinished();
    }

    public void waitFinished() {
        this.refresh.waitFinished();
    }

    @Override
    public void run() {
        boolean empty = true;
        LOG.fine("collecting layers");
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(0, FoDFileSystem.class.getResource("common.xml"));
        for (FeatureInfo featureInfo : FeatureManager.features()) {
            if (!featureInfo.isPresent()) continue;
            LOG.log(Level.FINEST, "adding feature {0}", featureInfo.clusterName);
            if (featureInfo.getLayerURL() != null) {
                urls.add(featureInfo.getLayerURL());
            }
            if (!featureInfo.isEnabled()) continue;
            empty = false;
        }
        if (empty && this.noAdditionalProjects() && !FoDEditorOpened.anEditorIsOpened) {
            LOG.fine("adding default layer");
            urls.add(0, FoDFileSystem.class.getResource("default.xml"));
        }
        if (this.forcedRefresh) {
            this.forcedRefresh = false;
            LOG.log(Level.INFO, "Forced refresh. Setting delegates to empty");
            this.setDelegates(new FileSystem[0]);
            LOG.log(Level.INFO, "New delegates count: {0}", urls.size());
            LOG.log(Level.INFO, "{0}", urls);
        }
        LOG.log(Level.FINE, "delegating to {0} layers", urls.size());
        LOG.log(Level.FINEST, "{0}", urls);
        try {
            FileSystem fs = this.getDelegates().length == 0 ? manager.createEmptyFileSystem() : this.getDelegates()[0];
            fs = manager.store(fs, urls);
            this.setDelegates(new FileSystem[]{fs});
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, "Cannot save cache", ex);
        }
        LOG.fine("done");
        FeatureManager.dumpModules();
    }

    public FeatureInfo whichProvides(FileObject template) {
        String path = template.getPath();
        for (FeatureInfo featureInfo : FeatureManager.features()) {
            FileSystem fs = featureInfo.getXMLFileSystem();
            if (fs.findResource(path) == null) continue;
            return featureInfo;
        }
        return null;
    }

    public URL getDelegateFileSystem(FileObject template) {
        String path = template.getPath();
        for (FeatureInfo featureInfo : FeatureManager.features()) {
            FileSystem fs = featureInfo.getXMLFileSystem();
            if (fs.findResource(path) == null) continue;
            return featureInfo.getLayerURL();
        }
        return null;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.refresh.schedule(500);
    }

    public void resultChanged(LookupEvent ev) {
        this.refresh.schedule(0);
    }

    private boolean noAdditionalProjects() {
        if (this.factories == null) {
            this.factories = Lookup.getDefault().lookupResult(ProjectFactory.class);
            this.factories.addLookupListener((LookupListener)this);
            this.ants = Lookup.getDefault().lookupResult(AntBasedProjectType.class);
            this.ants.addLookupListener((LookupListener)this);
        }
        for (ProjectFactory pf : this.factories.allInstances()) {
            if (pf.getClass().getName().contains("AntBasedProjectFactorySingleton") || pf.getClass().getName().startsWith("org.netbeans.modules.ide.ergonomics")) continue;
            return false;
        }
        return this.ants.allItems().isEmpty();
    }
}

